/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DateTimeDefaultValues;
import software.amazon.awssdk.services.quicksight.model.DateTimeValueWhenUnsetConfiguration;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimeParameterDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimeParameterDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DateTimeParameterDeclaration.getter(DateTimeParameterDeclaration::name)).setter(DateTimeParameterDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DateTimeDefaultValues> DEFAULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultValues").getter(DateTimeParameterDeclaration.getter(DateTimeParameterDeclaration::defaultValues)).setter(DateTimeParameterDeclaration.setter(Builder::defaultValues)).constructor(DateTimeDefaultValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(DateTimeParameterDeclaration.getter(DateTimeParameterDeclaration::timeGranularityAsString)).setter(DateTimeParameterDeclaration.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<DateTimeValueWhenUnsetConfiguration> VALUE_WHEN_UNSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueWhenUnset").getter(DateTimeParameterDeclaration.getter(DateTimeParameterDeclaration::valueWhenUnset)).setter(DateTimeParameterDeclaration.setter(Builder::valueWhenUnset)).constructor(DateTimeValueWhenUnsetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueWhenUnset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFAULT_VALUES_FIELD, TIME_GRANULARITY_FIELD, VALUE_WHEN_UNSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final DateTimeDefaultValues defaultValues;
    private final String timeGranularity;
    private final DateTimeValueWhenUnsetConfiguration valueWhenUnset;

    private DateTimeParameterDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultValues = builder.defaultValues;
        this.timeGranularity = builder.timeGranularity;
        this.valueWhenUnset = builder.valueWhenUnset;
    }

    public final String name() {
        return this.name;
    }

    public final DateTimeDefaultValues defaultValues() {
        return this.defaultValues;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final DateTimeValueWhenUnsetConfiguration valueWhenUnset() {
        return this.valueWhenUnset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueWhenUnset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeParameterDeclaration)) {
            return false;
        }
        DateTimeParameterDeclaration other = (DateTimeParameterDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultValues(), other.defaultValues()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.valueWhenUnset(), other.valueWhenUnset());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimeParameterDeclaration").add("Name", (Object)this.name()).add("DefaultValues", (Object)this.defaultValues()).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("ValueWhenUnset", (Object)this.valueWhenUnset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefaultValues": {
                return Optional.ofNullable(clazz.cast(this.defaultValues()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "ValueWhenUnset": {
                return Optional.ofNullable(clazz.cast(this.valueWhenUnset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeParameterDeclaration, T> g) {
        return obj -> g.apply((DateTimeParameterDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private DateTimeDefaultValues defaultValues;
        private String timeGranularity;
        private DateTimeValueWhenUnsetConfiguration valueWhenUnset;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeParameterDeclaration model) {
            this.name(model.name);
            this.defaultValues(model.defaultValues);
            this.timeGranularity(model.timeGranularity);
            this.valueWhenUnset(model.valueWhenUnset);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DateTimeDefaultValues.Builder getDefaultValues() {
            return this.defaultValues != null ? this.defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(DateTimeDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(DateTimeDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final DateTimeValueWhenUnsetConfiguration.Builder getValueWhenUnset() {
            return this.valueWhenUnset != null ? this.valueWhenUnset.toBuilder() : null;
        }

        public final void setValueWhenUnset(DateTimeValueWhenUnsetConfiguration.BuilderImpl valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset != null ? valueWhenUnset.build() : null;
        }

        @Override
        public final Builder valueWhenUnset(DateTimeValueWhenUnsetConfiguration valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset;
            return this;
        }

        public DateTimeParameterDeclaration build() {
            return new DateTimeParameterDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimeParameterDeclaration> {
        public Builder name(String var1);

        public Builder defaultValues(DateTimeDefaultValues var1);

        default public Builder defaultValues(Consumer<DateTimeDefaultValues.Builder> defaultValues) {
            return this.defaultValues((DateTimeDefaultValues)((DateTimeDefaultValues.Builder)DateTimeDefaultValues.builder().applyMutation(defaultValues)).build());
        }

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);

        public Builder valueWhenUnset(DateTimeValueWhenUnsetConfiguration var1);

        default public Builder valueWhenUnset(Consumer<DateTimeValueWhenUnsetConfiguration.Builder> valueWhenUnset) {
            return this.valueWhenUnset((DateTimeValueWhenUnsetConfiguration)((DateTimeValueWhenUnsetConfiguration.Builder)DateTimeValueWhenUnsetConfiguration.builder().applyMutation(valueWhenUnset)).build());
        }
    }
}

