/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total options for a table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TotalOptions implements SdkPojo, Serializable, ToCopyableBuilder<TotalOptions.Builder, TotalOptions> {
    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalsVisibility").getter(getter(TotalOptions::totalsVisibilityAsString))
            .setter(setter(Builder::totalsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()).build();

    private static final SdkField<String> PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Placement").getter(getter(TotalOptions::placementAsString)).setter(setter(Builder::placement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()).build();

    private static final SdkField<String> SCROLL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScrollStatus").getter(getter(TotalOptions::scrollStatusAsString)).setter(setter(Builder::scrollStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScrollStatus").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(TotalOptions::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final SdkField<TableCellStyle> TOTAL_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("TotalCellStyle")
            .getter(getter(TotalOptions::totalCellStyle)).setter(setter(Builder::totalCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCellStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTALS_VISIBILITY_FIELD,
            PLACEMENT_FIELD, SCROLL_STATUS_FIELD, CUSTOM_LABEL_FIELD, TOTAL_CELL_STYLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String totalsVisibility;

    private final String placement;

    private final String scrollStatus;

    private final String customLabel;

    private final TableCellStyle totalCellStyle;

    private TotalOptions(BuilderImpl builder) {
        this.totalsVisibility = builder.totalsVisibility;
        this.placement = builder.placement;
        this.scrollStatus = builder.scrollStatus;
        this.customLabel = builder.customLabel;
        this.totalCellStyle = builder.totalCellStyle;
    }

    /**
     * <p>
     * The visibility configuration for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration for the total cells.
     * @see Visibility
     */
    public final Visibility totalsVisibility() {
        return Visibility.fromValue(totalsVisibility);
    }

    /**
     * <p>
     * The visibility configuration for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration for the total cells.
     * @see Visibility
     */
    public final String totalsVisibilityAsString() {
        return totalsVisibility;
    }

    /**
     * <p>
     * The placement (start, end) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placement} will
     * return {@link TableTotalsPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #placementAsString}.
     * </p>
     * 
     * @return The placement (start, end) for the total cells.
     * @see TableTotalsPlacement
     */
    public final TableTotalsPlacement placement() {
        return TableTotalsPlacement.fromValue(placement);
    }

    /**
     * <p>
     * The placement (start, end) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placement} will
     * return {@link TableTotalsPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #placementAsString}.
     * </p>
     * 
     * @return The placement (start, end) for the total cells.
     * @see TableTotalsPlacement
     */
    public final String placementAsString() {
        return placement;
    }

    /**
     * <p>
     * The scroll status (pinned, scrolled) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scrollStatus} will
     * return {@link TableTotalsScrollStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scrollStatusAsString}.
     * </p>
     * 
     * @return The scroll status (pinned, scrolled) for the total cells.
     * @see TableTotalsScrollStatus
     */
    public final TableTotalsScrollStatus scrollStatus() {
        return TableTotalsScrollStatus.fromValue(scrollStatus);
    }

    /**
     * <p>
     * The scroll status (pinned, scrolled) for the total cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scrollStatus} will
     * return {@link TableTotalsScrollStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scrollStatusAsString}.
     * </p>
     * 
     * @return The scroll status (pinned, scrolled) for the total cells.
     * @see TableTotalsScrollStatus
     */
    public final String scrollStatusAsString() {
        return scrollStatus;
    }

    /**
     * <p>
     * The custom label string for the total cells.
     * </p>
     * 
     * @return The custom label string for the total cells.
     */
    public final String customLabel() {
        return customLabel;
    }

    /**
     * <p>
     * Cell styling options for the total cells.
     * </p>
     * 
     * @return Cell styling options for the total cells.
     */
    public final TableCellStyle totalCellStyle() {
        return totalCellStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(placementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scrollStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(totalCellStyle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalOptions)) {
            return false;
        }
        TotalOptions other = (TotalOptions) obj;
        return Objects.equals(totalsVisibilityAsString(), other.totalsVisibilityAsString())
                && Objects.equals(placementAsString(), other.placementAsString())
                && Objects.equals(scrollStatusAsString(), other.scrollStatusAsString())
                && Objects.equals(customLabel(), other.customLabel()) && Objects.equals(totalCellStyle(), other.totalCellStyle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TotalOptions").add("TotalsVisibility", totalsVisibilityAsString())
                .add("Placement", placementAsString()).add("ScrollStatus", scrollStatusAsString())
                .add("CustomLabel", customLabel()).add("TotalCellStyle", totalCellStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalsVisibility":
            return Optional.ofNullable(clazz.cast(totalsVisibilityAsString()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placementAsString()));
        case "ScrollStatus":
            return Optional.ofNullable(clazz.cast(scrollStatusAsString()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        case "TotalCellStyle":
            return Optional.ofNullable(clazz.cast(totalCellStyle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TotalOptions, T> g) {
        return obj -> g.apply((TotalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TotalOptions> {
        /**
         * <p>
         * The visibility configuration for the total cells.
         * </p>
         * 
         * @param totalsVisibility
         *        The visibility configuration for the total cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(String totalsVisibility);

        /**
         * <p>
         * The visibility configuration for the total cells.
         * </p>
         * 
         * @param totalsVisibility
         *        The visibility configuration for the total cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(Visibility totalsVisibility);

        /**
         * <p>
         * The placement (start, end) for the total cells.
         * </p>
         * 
         * @param placement
         *        The placement (start, end) for the total cells.
         * @see TableTotalsPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsPlacement
         */
        Builder placement(String placement);

        /**
         * <p>
         * The placement (start, end) for the total cells.
         * </p>
         * 
         * @param placement
         *        The placement (start, end) for the total cells.
         * @see TableTotalsPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsPlacement
         */
        Builder placement(TableTotalsPlacement placement);

        /**
         * <p>
         * The scroll status (pinned, scrolled) for the total cells.
         * </p>
         * 
         * @param scrollStatus
         *        The scroll status (pinned, scrolled) for the total cells.
         * @see TableTotalsScrollStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsScrollStatus
         */
        Builder scrollStatus(String scrollStatus);

        /**
         * <p>
         * The scroll status (pinned, scrolled) for the total cells.
         * </p>
         * 
         * @param scrollStatus
         *        The scroll status (pinned, scrolled) for the total cells.
         * @see TableTotalsScrollStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableTotalsScrollStatus
         */
        Builder scrollStatus(TableTotalsScrollStatus scrollStatus);

        /**
         * <p>
         * The custom label string for the total cells.
         * </p>
         * 
         * @param customLabel
         *        The custom label string for the total cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);

        /**
         * <p>
         * Cell styling options for the total cells.
         * </p>
         * 
         * @param totalCellStyle
         *        Cell styling options for the total cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCellStyle(TableCellStyle totalCellStyle);

        /**
         * <p>
         * Cell styling options for the total cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #totalCellStyle(TableCellStyle)}.
         * 
         * @param totalCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalCellStyle(TableCellStyle)
         */
        default Builder totalCellStyle(Consumer<TableCellStyle.Builder> totalCellStyle) {
            return totalCellStyle(TableCellStyle.builder().applyMutation(totalCellStyle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String totalsVisibility;

        private String placement;

        private String scrollStatus;

        private String customLabel;

        private TableCellStyle totalCellStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(TotalOptions model) {
            totalsVisibility(model.totalsVisibility);
            placement(model.placement);
            scrollStatus(model.scrollStatus);
            customLabel(model.customLabel);
            totalCellStyle(model.totalCellStyle);
        }

        public final String getTotalsVisibility() {
            return totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        public final String getPlacement() {
            return placement;
        }

        public final void setPlacement(String placement) {
            this.placement = placement;
        }

        @Override
        public final Builder placement(String placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public final Builder placement(TableTotalsPlacement placement) {
            this.placement(placement == null ? null : placement.toString());
            return this;
        }

        public final String getScrollStatus() {
            return scrollStatus;
        }

        public final void setScrollStatus(String scrollStatus) {
            this.scrollStatus = scrollStatus;
        }

        @Override
        public final Builder scrollStatus(String scrollStatus) {
            this.scrollStatus = scrollStatus;
            return this;
        }

        @Override
        public final Builder scrollStatus(TableTotalsScrollStatus scrollStatus) {
            this.scrollStatus(scrollStatus == null ? null : scrollStatus.toString());
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final TableCellStyle.Builder getTotalCellStyle() {
            return totalCellStyle != null ? totalCellStyle.toBuilder() : null;
        }

        public final void setTotalCellStyle(TableCellStyle.BuilderImpl totalCellStyle) {
            this.totalCellStyle = totalCellStyle != null ? totalCellStyle.build() : null;
        }

        @Override
        public final Builder totalCellStyle(TableCellStyle totalCellStyle) {
            this.totalCellStyle = totalCellStyle;
            return this;
        }

        @Override
        public TotalOptions build() {
            return new TotalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
