/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cell conditional formatting option for a pivot table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableCellConditionalFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableCellConditionalFormatting.Builder, PivotTableCellConditionalFormatting> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(PivotTableCellConditionalFormatting::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<TextConditionalFormat> TEXT_FORMAT_FIELD = SdkField
            .<TextConditionalFormat> builder(MarshallingType.SDK_POJO).memberName("TextFormat")
            .getter(getter(PivotTableCellConditionalFormatting::textFormat)).setter(setter(Builder::textFormat))
            .constructor(TextConditionalFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextFormat").build()).build();

    private static final SdkField<PivotTableConditionalFormattingScope> SCOPE_FIELD = SdkField
            .<PivotTableConditionalFormattingScope> builder(MarshallingType.SDK_POJO).memberName("Scope")
            .getter(getter(PivotTableCellConditionalFormatting::scope)).setter(setter(Builder::scope))
            .constructor(PivotTableConditionalFormattingScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            TEXT_FORMAT_FIELD, SCOPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final TextConditionalFormat textFormat;

    private final PivotTableConditionalFormattingScope scope;

    private PivotTableCellConditionalFormatting(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.textFormat = builder.textFormat;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The field ID of the cell for conditional formatting.
     * </p>
     * 
     * @return The field ID of the cell for conditional formatting.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The text format of the cell for conditional formatting.
     * </p>
     * 
     * @return The text format of the cell for conditional formatting.
     */
    public final TextConditionalFormat textFormat() {
        return textFormat;
    }

    /**
     * <p>
     * The scope of the cell for conditional formatting.
     * </p>
     * 
     * @return The scope of the cell for conditional formatting.
     */
    public final PivotTableConditionalFormattingScope scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(textFormat());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableCellConditionalFormatting)) {
            return false;
        }
        PivotTableCellConditionalFormatting other = (PivotTableCellConditionalFormatting) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(textFormat(), other.textFormat())
                && Objects.equals(scope(), other.scope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableCellConditionalFormatting").add("FieldId", fieldId()).add("TextFormat", textFormat())
                .add("Scope", scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "TextFormat":
            return Optional.ofNullable(clazz.cast(textFormat()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableCellConditionalFormatting, T> g) {
        return obj -> g.apply((PivotTableCellConditionalFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableCellConditionalFormatting> {
        /**
         * <p>
         * The field ID of the cell for conditional formatting.
         * </p>
         * 
         * @param fieldId
         *        The field ID of the cell for conditional formatting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The text format of the cell for conditional formatting.
         * </p>
         * 
         * @param textFormat
         *        The text format of the cell for conditional formatting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textFormat(TextConditionalFormat textFormat);

        /**
         * <p>
         * The text format of the cell for conditional formatting.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextConditionalFormat.Builder} avoiding
         * the need to create one manually via {@link TextConditionalFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextConditionalFormat.Builder#build()} is called immediately and
         * its result is passed to {@link #textFormat(TextConditionalFormat)}.
         * 
         * @param textFormat
         *        a consumer that will call methods on {@link TextConditionalFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textFormat(TextConditionalFormat)
         */
        default Builder textFormat(Consumer<TextConditionalFormat.Builder> textFormat) {
            return textFormat(TextConditionalFormat.builder().applyMutation(textFormat).build());
        }

        /**
         * <p>
         * The scope of the cell for conditional formatting.
         * </p>
         * 
         * @param scope
         *        The scope of the cell for conditional formatting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(PivotTableConditionalFormattingScope scope);

        /**
         * <p>
         * The scope of the cell for conditional formatting.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PivotTableConditionalFormattingScope.Builder} avoiding the need to create one manually via
         * {@link PivotTableConditionalFormattingScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableConditionalFormattingScope.Builder#build()} is called
         * immediately and its result is passed to {@link #scope(PivotTableConditionalFormattingScope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link PivotTableConditionalFormattingScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(PivotTableConditionalFormattingScope)
         */
        default Builder scope(Consumer<PivotTableConditionalFormattingScope.Builder> scope) {
            return scope(PivotTableConditionalFormattingScope.builder().applyMutation(scope).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private TextConditionalFormat textFormat;

        private PivotTableConditionalFormattingScope scope;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableCellConditionalFormatting model) {
            fieldId(model.fieldId);
            textFormat(model.textFormat);
            scope(model.scope);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final TextConditionalFormat.Builder getTextFormat() {
            return textFormat != null ? textFormat.toBuilder() : null;
        }

        public final void setTextFormat(TextConditionalFormat.BuilderImpl textFormat) {
            this.textFormat = textFormat != null ? textFormat.build() : null;
        }

        @Override
        public final Builder textFormat(TextConditionalFormat textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public final PivotTableConditionalFormattingScope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(PivotTableConditionalFormattingScope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(PivotTableConditionalFormattingScope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public PivotTableCellConditionalFormatting build() {
            return new PivotTableCellConditionalFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
