/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The login credentials to use to import a data source resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobDataSourceCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobDataSourceCredentials.Builder, AssetBundleImportJobDataSourceCredentials> {
    private static final SdkField<AssetBundleImportJobDataSourceCredentialPair> CREDENTIAL_PAIR_FIELD = SdkField
            .<AssetBundleImportJobDataSourceCredentialPair> builder(MarshallingType.SDK_POJO).memberName("CredentialPair")
            .getter(getter(AssetBundleImportJobDataSourceCredentials::credentialPair)).setter(setter(Builder::credentialPair))
            .constructor(AssetBundleImportJobDataSourceCredentialPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialPair").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(AssetBundleImportJobDataSourceCredentials::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_PAIR_FIELD,
            SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssetBundleImportJobDataSourceCredentialPair credentialPair;

    private final String secretArn;

    private AssetBundleImportJobDataSourceCredentials(BuilderImpl builder) {
        this.credentialPair = builder.credentialPair;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * A username and password credential pair to be used to create the imported data source. Leave this field blank if
     * you are using an Secrets Manager Secret to provide credentials.
     * </p>
     * 
     * @return A username and password credential pair to be used to create the imported data source. Leave this field
     *         blank if you are using an Secrets Manager Secret to provide credentials.
     */
    public final AssetBundleImportJobDataSourceCredentialPair credentialPair() {
        return credentialPair;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager Secret to be used to create the imported data source leave this field blank if you
     * aren't using a Secret in place of a credential pair.
     * </p>
     * 
     * @return The ARN of the Secrets Manager Secret to be used to create the imported data source leave this field
     *         blank if you aren't using a Secret in place of a credential pair.
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialPair());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDataSourceCredentials)) {
            return false;
        }
        AssetBundleImportJobDataSourceCredentials other = (AssetBundleImportJobDataSourceCredentials) obj;
        return Objects.equals(credentialPair(), other.credentialPair()) && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobDataSourceCredentials")
                .add("CredentialPair", credentialPair() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecretArn", secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CredentialPair":
            return Optional.ofNullable(clazz.cast(credentialPair()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDataSourceCredentials, T> g) {
        return obj -> g.apply((AssetBundleImportJobDataSourceCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobDataSourceCredentials> {
        /**
         * <p>
         * A username and password credential pair to be used to create the imported data source. Leave this field blank
         * if you are using an Secrets Manager Secret to provide credentials.
         * </p>
         * 
         * @param credentialPair
         *        A username and password credential pair to be used to create the imported data source. Leave this
         *        field blank if you are using an Secrets Manager Secret to provide credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialPair(AssetBundleImportJobDataSourceCredentialPair credentialPair);

        /**
         * <p>
         * A username and password credential pair to be used to create the imported data source. Leave this field blank
         * if you are using an Secrets Manager Secret to provide credentials.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleImportJobDataSourceCredentialPair.Builder} avoiding the need to create one manually via
         * {@link AssetBundleImportJobDataSourceCredentialPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleImportJobDataSourceCredentialPair.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #credentialPair(AssetBundleImportJobDataSourceCredentialPair)}.
         * 
         * @param credentialPair
         *        a consumer that will call methods on {@link AssetBundleImportJobDataSourceCredentialPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialPair(AssetBundleImportJobDataSourceCredentialPair)
         */
        default Builder credentialPair(Consumer<AssetBundleImportJobDataSourceCredentialPair.Builder> credentialPair) {
            return credentialPair(AssetBundleImportJobDataSourceCredentialPair.builder().applyMutation(credentialPair).build());
        }

        /**
         * <p>
         * The ARN of the Secrets Manager Secret to be used to create the imported data source leave this field blank if
         * you aren't using a Secret in place of a credential pair.
         * </p>
         * 
         * @param secretArn
         *        The ARN of the Secrets Manager Secret to be used to create the imported data source leave this field
         *        blank if you aren't using a Secret in place of a credential pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private AssetBundleImportJobDataSourceCredentialPair credentialPair;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDataSourceCredentials model) {
            credentialPair(model.credentialPair);
            secretArn(model.secretArn);
        }

        public final AssetBundleImportJobDataSourceCredentialPair.Builder getCredentialPair() {
            return credentialPair != null ? credentialPair.toBuilder() : null;
        }

        public final void setCredentialPair(AssetBundleImportJobDataSourceCredentialPair.BuilderImpl credentialPair) {
            this.credentialPair = credentialPair != null ? credentialPair.build() : null;
        }

        @Override
        public final Builder credentialPair(AssetBundleImportJobDataSourceCredentialPair credentialPair) {
            this.credentialPair = credentialPair;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public AssetBundleImportJobDataSourceCredentials build() {
            return new AssetBundleImportJobDataSourceCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
