/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of the asset bundle zip file that contains the data that you want to import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportSource.Builder, AssetBundleImportSource> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Body").getter(getter(AssetBundleImportSource::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(AssetBundleImportSource::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes body;

    private final String s3Uri;

    private AssetBundleImportSource(BuilderImpl builder) {
        this.body = builder.body;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p>
     * The bytes of the Base64 encoded asset bundle import zip file. This file can't exceed 20MB.
     * </p>
     * <p>
     * If you are calling the APIs from the Amazon Web Services Java, JavaScript, Python, or PHP SDKs, the SDK encodes
     * Base64 automatically to allow the direct setting of the zip file's bytes. If you are using a SDK of a different
     * language or are receiving related errors, try to Base64 encode your data.
     * </p>
     * 
     * @return The bytes of the Base64 encoded asset bundle import zip file. This file can't exceed 20MB.</p>
     *         <p>
     *         If you are calling the APIs from the Amazon Web Services Java, JavaScript, Python, or PHP SDKs, the SDK
     *         encodes Base64 automatically to allow the direct setting of the zip file's bytes. If you are using a SDK
     *         of a different language or are receiving related errors, try to Base64 encode your data.
     */
    public final SdkBytes body() {
        return body;
    }

    /**
     * <p>
     * The Amazon S3 uri for an asset bundle import file that exists in an Amazon S3 bucket that the caller has read
     * access to. The file must be a zip format file and can't exceed 20MB.
     * </p>
     * 
     * @return The Amazon S3 uri for an asset bundle import file that exists in an Amazon S3 bucket that the caller has
     *         read access to. The file must be a zip format file and can't exceed 20MB.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportSource)) {
            return false;
        }
        AssetBundleImportSource other = (AssetBundleImportSource) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportSource").add("Body", body() == null ? null : "*** Sensitive Data Redacted ***")
                .add("S3Uri", s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportSource, T> g) {
        return obj -> g.apply((AssetBundleImportSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportSource> {
        /**
         * <p>
         * The bytes of the Base64 encoded asset bundle import zip file. This file can't exceed 20MB.
         * </p>
         * <p>
         * If you are calling the APIs from the Amazon Web Services Java, JavaScript, Python, or PHP SDKs, the SDK
         * encodes Base64 automatically to allow the direct setting of the zip file's bytes. If you are using a SDK of a
         * different language or are receiving related errors, try to Base64 encode your data.
         * </p>
         * 
         * @param body
         *        The bytes of the Base64 encoded asset bundle import zip file. This file can't exceed 20MB.</p>
         *        <p>
         *        If you are calling the APIs from the Amazon Web Services Java, JavaScript, Python, or PHP SDKs, the
         *        SDK encodes Base64 automatically to allow the direct setting of the zip file's bytes. If you are using
         *        a SDK of a different language or are receiving related errors, try to Base64 encode your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        /**
         * <p>
         * The Amazon S3 uri for an asset bundle import file that exists in an Amazon S3 bucket that the caller has read
         * access to. The file must be a zip format file and can't exceed 20MB.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 uri for an asset bundle import file that exists in an Amazon S3 bucket that the caller
         *        has read access to. The file must be a zip format file and can't exceed 20MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes body;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportSource model) {
            body(model.body);
            s3Uri(model.s3Uri);
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public AssetBundleImportSource build() {
            return new AssetBundleImportSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
