/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the presentation of the data labels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLabelOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLabelOptions.Builder, DataLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(DataLabelOptions::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> CATEGORY_LABEL_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryLabelVisibility").getter(getter(DataLabelOptions::categoryLabelVisibilityAsString))
            .setter(setter(Builder::categoryLabelVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelVisibility").build())
            .build();

    private static final SdkField<String> MEASURE_LABEL_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureLabelVisibility").getter(getter(DataLabelOptions::measureLabelVisibilityAsString))
            .setter(setter(Builder::measureLabelVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureLabelVisibility").build())
            .build();

    private static final SdkField<List<DataLabelType>> DATA_LABEL_TYPES_FIELD = SdkField
            .<List<DataLabelType>> builder(MarshallingType.LIST)
            .memberName("DataLabelTypes")
            .getter(getter(DataLabelOptions::dataLabelTypes))
            .setter(setter(Builder::dataLabelTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabelTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLabelType> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLabelType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Position").getter(getter(DataLabelOptions::positionAsString)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()).build();

    private static final SdkField<String> LABEL_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelContent").getter(getter(DataLabelOptions::labelContentAsString))
            .setter(setter(Builder::labelContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelContent").build()).build();

    private static final SdkField<FontConfiguration> LABEL_FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelFontConfiguration")
            .getter(getter(DataLabelOptions::labelFontConfiguration)).setter(setter(Builder::labelFontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelFontConfiguration").build())
            .build();

    private static final SdkField<String> LABEL_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelColor").getter(getter(DataLabelOptions::labelColor)).setter(setter(Builder::labelColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelColor").build()).build();

    private static final SdkField<String> OVERLAP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Overlap")
            .getter(getter(DataLabelOptions::overlapAsString)).setter(setter(Builder::overlap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overlap").build()).build();

    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalsVisibility").getter(getter(DataLabelOptions::totalsVisibilityAsString))
            .setter(setter(Builder::totalsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            CATEGORY_LABEL_VISIBILITY_FIELD, MEASURE_LABEL_VISIBILITY_FIELD, DATA_LABEL_TYPES_FIELD, POSITION_FIELD,
            LABEL_CONTENT_FIELD, LABEL_FONT_CONFIGURATION_FIELD, LABEL_COLOR_FIELD, OVERLAP_FIELD, TOTALS_VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final String categoryLabelVisibility;

    private final String measureLabelVisibility;

    private final List<DataLabelType> dataLabelTypes;

    private final String position;

    private final String labelContent;

    private final FontConfiguration labelFontConfiguration;

    private final String labelColor;

    private final String overlap;

    private final String totalsVisibility;

    private DataLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.categoryLabelVisibility = builder.categoryLabelVisibility;
        this.measureLabelVisibility = builder.measureLabelVisibility;
        this.dataLabelTypes = builder.dataLabelTypes;
        this.position = builder.position;
        this.labelContent = builder.labelContent;
        this.labelFontConfiguration = builder.labelFontConfiguration;
        this.labelColor = builder.labelColor;
        this.overlap = builder.overlap;
        this.totalsVisibility = builder.totalsVisibility;
    }

    /**
     * <p>
     * Determines the visibility of the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the data labels.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Determines the visibility of the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the data labels.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * Determines the visibility of the category field labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #categoryLabelVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the category field labels.
     * @see Visibility
     */
    public final Visibility categoryLabelVisibility() {
        return Visibility.fromValue(categoryLabelVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the category field labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #categoryLabelVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the category field labels.
     * @see Visibility
     */
    public final String categoryLabelVisibilityAsString() {
        return categoryLabelVisibility;
    }

    /**
     * <p>
     * Determines the visibility of the measure field labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #measureLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #measureLabelVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the measure field labels.
     * @see Visibility
     */
    public final Visibility measureLabelVisibility() {
        return Visibility.fromValue(measureLabelVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the measure field labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #measureLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #measureLabelVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the measure field labels.
     * @see Visibility
     */
    public final String measureLabelVisibilityAsString() {
        return measureLabelVisibility;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataLabelTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataLabelTypes() {
        return dataLabelTypes != null && !(dataLabelTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The option that determines the data label type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataLabelTypes} method.
     * </p>
     * 
     * @return The option that determines the data label type.
     */
    public final List<DataLabelType> dataLabelTypes() {
        return dataLabelTypes;
    }

    /**
     * <p>
     * Determines the position of the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link DataLabelPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #positionAsString}.
     * </p>
     * 
     * @return Determines the position of the data labels.
     * @see DataLabelPosition
     */
    public final DataLabelPosition position() {
        return DataLabelPosition.fromValue(position);
    }

    /**
     * <p>
     * Determines the position of the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link DataLabelPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #positionAsString}.
     * </p>
     * 
     * @return Determines the position of the data labels.
     * @see DataLabelPosition
     */
    public final String positionAsString() {
        return position;
    }

    /**
     * <p>
     * Determines the content of the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelContent} will
     * return {@link DataLabelContent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelContentAsString}.
     * </p>
     * 
     * @return Determines the content of the data labels.
     * @see DataLabelContent
     */
    public final DataLabelContent labelContent() {
        return DataLabelContent.fromValue(labelContent);
    }

    /**
     * <p>
     * Determines the content of the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelContent} will
     * return {@link DataLabelContent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #labelContentAsString}.
     * </p>
     * 
     * @return Determines the content of the data labels.
     * @see DataLabelContent
     */
    public final String labelContentAsString() {
        return labelContent;
    }

    /**
     * <p>
     * Determines the font configuration of the data labels.
     * </p>
     * 
     * @return Determines the font configuration of the data labels.
     */
    public final FontConfiguration labelFontConfiguration() {
        return labelFontConfiguration;
    }

    /**
     * <p>
     * Determines the color of the data labels.
     * </p>
     * 
     * @return Determines the color of the data labels.
     */
    public final String labelColor() {
        return labelColor;
    }

    /**
     * <p>
     * Determines whether overlap is enabled or disabled for the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overlap} will
     * return {@link DataLabelOverlap#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #overlapAsString}.
     * </p>
     * 
     * @return Determines whether overlap is enabled or disabled for the data labels.
     * @see DataLabelOverlap
     */
    public final DataLabelOverlap overlap() {
        return DataLabelOverlap.fromValue(overlap);
    }

    /**
     * <p>
     * Determines whether overlap is enabled or disabled for the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overlap} will
     * return {@link DataLabelOverlap#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #overlapAsString}.
     * </p>
     * 
     * @return Determines whether overlap is enabled or disabled for the data labels.
     * @see DataLabelOverlap
     */
    public final String overlapAsString() {
        return overlap;
    }

    /**
     * <p>
     * Determines the visibility of the total.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the total.
     * @see Visibility
     */
    public final Visibility totalsVisibility() {
        return Visibility.fromValue(totalsVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the total.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the total.
     * @see Visibility
     */
    public final String totalsVisibilityAsString() {
        return totalsVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(measureLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataLabelTypes() ? dataLabelTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelContentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(labelColor());
        hashCode = 31 * hashCode + Objects.hashCode(overlapAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalsVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLabelOptions)) {
            return false;
        }
        DataLabelOptions other = (DataLabelOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(categoryLabelVisibilityAsString(), other.categoryLabelVisibilityAsString())
                && Objects.equals(measureLabelVisibilityAsString(), other.measureLabelVisibilityAsString())
                && hasDataLabelTypes() == other.hasDataLabelTypes() && Objects.equals(dataLabelTypes(), other.dataLabelTypes())
                && Objects.equals(positionAsString(), other.positionAsString())
                && Objects.equals(labelContentAsString(), other.labelContentAsString())
                && Objects.equals(labelFontConfiguration(), other.labelFontConfiguration())
                && Objects.equals(labelColor(), other.labelColor()) && Objects.equals(overlapAsString(), other.overlapAsString())
                && Objects.equals(totalsVisibilityAsString(), other.totalsVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLabelOptions").add("Visibility", visibilityAsString())
                .add("CategoryLabelVisibility", categoryLabelVisibilityAsString())
                .add("MeasureLabelVisibility", measureLabelVisibilityAsString())
                .add("DataLabelTypes", hasDataLabelTypes() ? dataLabelTypes() : null).add("Position", positionAsString())
                .add("LabelContent", labelContentAsString()).add("LabelFontConfiguration", labelFontConfiguration())
                .add("LabelColor", labelColor()).add("Overlap", overlapAsString())
                .add("TotalsVisibility", totalsVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "CategoryLabelVisibility":
            return Optional.ofNullable(clazz.cast(categoryLabelVisibilityAsString()));
        case "MeasureLabelVisibility":
            return Optional.ofNullable(clazz.cast(measureLabelVisibilityAsString()));
        case "DataLabelTypes":
            return Optional.ofNullable(clazz.cast(dataLabelTypes()));
        case "Position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        case "LabelContent":
            return Optional.ofNullable(clazz.cast(labelContentAsString()));
        case "LabelFontConfiguration":
            return Optional.ofNullable(clazz.cast(labelFontConfiguration()));
        case "LabelColor":
            return Optional.ofNullable(clazz.cast(labelColor()));
        case "Overlap":
            return Optional.ofNullable(clazz.cast(overlapAsString()));
        case "TotalsVisibility":
            return Optional.ofNullable(clazz.cast(totalsVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLabelOptions, T> g) {
        return obj -> g.apply((DataLabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLabelOptions> {
        /**
         * <p>
         * Determines the visibility of the data labels.
         * </p>
         * 
         * @param visibility
         *        Determines the visibility of the data labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Determines the visibility of the data labels.
         * </p>
         * 
         * @param visibility
         *        Determines the visibility of the data labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * Determines the visibility of the category field labels.
         * </p>
         * 
         * @param categoryLabelVisibility
         *        Determines the visibility of the category field labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder categoryLabelVisibility(String categoryLabelVisibility);

        /**
         * <p>
         * Determines the visibility of the category field labels.
         * </p>
         * 
         * @param categoryLabelVisibility
         *        Determines the visibility of the category field labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder categoryLabelVisibility(Visibility categoryLabelVisibility);

        /**
         * <p>
         * Determines the visibility of the measure field labels.
         * </p>
         * 
         * @param measureLabelVisibility
         *        Determines the visibility of the measure field labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder measureLabelVisibility(String measureLabelVisibility);

        /**
         * <p>
         * Determines the visibility of the measure field labels.
         * </p>
         * 
         * @param measureLabelVisibility
         *        Determines the visibility of the measure field labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder measureLabelVisibility(Visibility measureLabelVisibility);

        /**
         * <p>
         * The option that determines the data label type.
         * </p>
         * 
         * @param dataLabelTypes
         *        The option that determines the data label type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabelTypes(Collection<DataLabelType> dataLabelTypes);

        /**
         * <p>
         * The option that determines the data label type.
         * </p>
         * 
         * @param dataLabelTypes
         *        The option that determines the data label type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabelTypes(DataLabelType... dataLabelTypes);

        /**
         * <p>
         * The option that determines the data label type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataLabelType.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DataLabelType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataLabelType.Builder#build()} is called immediately
         * and its result is passed to {@link #dataLabelTypes(List<DataLabelType>)}.
         * 
         * @param dataLabelTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataLabelType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabelTypes(java.util.Collection<DataLabelType>)
         */
        Builder dataLabelTypes(Consumer<DataLabelType.Builder>... dataLabelTypes);

        /**
         * <p>
         * Determines the position of the data labels.
         * </p>
         * 
         * @param position
         *        Determines the position of the data labels.
         * @see DataLabelPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelPosition
         */
        Builder position(String position);

        /**
         * <p>
         * Determines the position of the data labels.
         * </p>
         * 
         * @param position
         *        Determines the position of the data labels.
         * @see DataLabelPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelPosition
         */
        Builder position(DataLabelPosition position);

        /**
         * <p>
         * Determines the content of the data labels.
         * </p>
         * 
         * @param labelContent
         *        Determines the content of the data labels.
         * @see DataLabelContent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelContent
         */
        Builder labelContent(String labelContent);

        /**
         * <p>
         * Determines the content of the data labels.
         * </p>
         * 
         * @param labelContent
         *        Determines the content of the data labels.
         * @see DataLabelContent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelContent
         */
        Builder labelContent(DataLabelContent labelContent);

        /**
         * <p>
         * Determines the font configuration of the data labels.
         * </p>
         * 
         * @param labelFontConfiguration
         *        Determines the font configuration of the data labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelFontConfiguration(FontConfiguration labelFontConfiguration);

        /**
         * <p>
         * Determines the font configuration of the data labels.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #labelFontConfiguration(FontConfiguration)}.
         * 
         * @param labelFontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelFontConfiguration(FontConfiguration)
         */
        default Builder labelFontConfiguration(Consumer<FontConfiguration.Builder> labelFontConfiguration) {
            return labelFontConfiguration(FontConfiguration.builder().applyMutation(labelFontConfiguration).build());
        }

        /**
         * <p>
         * Determines the color of the data labels.
         * </p>
         * 
         * @param labelColor
         *        Determines the color of the data labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelColor(String labelColor);

        /**
         * <p>
         * Determines whether overlap is enabled or disabled for the data labels.
         * </p>
         * 
         * @param overlap
         *        Determines whether overlap is enabled or disabled for the data labels.
         * @see DataLabelOverlap
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelOverlap
         */
        Builder overlap(String overlap);

        /**
         * <p>
         * Determines whether overlap is enabled or disabled for the data labels.
         * </p>
         * 
         * @param overlap
         *        Determines whether overlap is enabled or disabled for the data labels.
         * @see DataLabelOverlap
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelOverlap
         */
        Builder overlap(DataLabelOverlap overlap);

        /**
         * <p>
         * Determines the visibility of the total.
         * </p>
         * 
         * @param totalsVisibility
         *        Determines the visibility of the total.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(String totalsVisibility);

        /**
         * <p>
         * Determines the visibility of the total.
         * </p>
         * 
         * @param totalsVisibility
         *        Determines the visibility of the total.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(Visibility totalsVisibility);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private String categoryLabelVisibility;

        private String measureLabelVisibility;

        private List<DataLabelType> dataLabelTypes = DefaultSdkAutoConstructList.getInstance();

        private String position;

        private String labelContent;

        private FontConfiguration labelFontConfiguration;

        private String labelColor;

        private String overlap;

        private String totalsVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLabelOptions model) {
            visibility(model.visibility);
            categoryLabelVisibility(model.categoryLabelVisibility);
            measureLabelVisibility(model.measureLabelVisibility);
            dataLabelTypes(model.dataLabelTypes);
            position(model.position);
            labelContent(model.labelContent);
            labelFontConfiguration(model.labelFontConfiguration);
            labelColor(model.labelColor);
            overlap(model.overlap);
            totalsVisibility(model.totalsVisibility);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getCategoryLabelVisibility() {
            return categoryLabelVisibility;
        }

        public final void setCategoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
        }

        @Override
        public final Builder categoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
            return this;
        }

        @Override
        public final Builder categoryLabelVisibility(Visibility categoryLabelVisibility) {
            this.categoryLabelVisibility(categoryLabelVisibility == null ? null : categoryLabelVisibility.toString());
            return this;
        }

        public final String getMeasureLabelVisibility() {
            return measureLabelVisibility;
        }

        public final void setMeasureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
        }

        @Override
        public final Builder measureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
            return this;
        }

        @Override
        public final Builder measureLabelVisibility(Visibility measureLabelVisibility) {
            this.measureLabelVisibility(measureLabelVisibility == null ? null : measureLabelVisibility.toString());
            return this;
        }

        public final List<DataLabelType.Builder> getDataLabelTypes() {
            List<DataLabelType.Builder> result = DataLabelTypesCopier.copyToBuilder(this.dataLabelTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataLabelTypes(Collection<DataLabelType.BuilderImpl> dataLabelTypes) {
            this.dataLabelTypes = DataLabelTypesCopier.copyFromBuilder(dataLabelTypes);
        }

        @Override
        public final Builder dataLabelTypes(Collection<DataLabelType> dataLabelTypes) {
            this.dataLabelTypes = DataLabelTypesCopier.copy(dataLabelTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLabelTypes(DataLabelType... dataLabelTypes) {
            dataLabelTypes(Arrays.asList(dataLabelTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLabelTypes(Consumer<DataLabelType.Builder>... dataLabelTypes) {
            dataLabelTypes(Stream.of(dataLabelTypes).map(c -> DataLabelType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(DataLabelPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final String getLabelContent() {
            return labelContent;
        }

        public final void setLabelContent(String labelContent) {
            this.labelContent = labelContent;
        }

        @Override
        public final Builder labelContent(String labelContent) {
            this.labelContent = labelContent;
            return this;
        }

        @Override
        public final Builder labelContent(DataLabelContent labelContent) {
            this.labelContent(labelContent == null ? null : labelContent.toString());
            return this;
        }

        public final FontConfiguration.Builder getLabelFontConfiguration() {
            return labelFontConfiguration != null ? labelFontConfiguration.toBuilder() : null;
        }

        public final void setLabelFontConfiguration(FontConfiguration.BuilderImpl labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration != null ? labelFontConfiguration.build() : null;
        }

        @Override
        public final Builder labelFontConfiguration(FontConfiguration labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration;
            return this;
        }

        public final String getLabelColor() {
            return labelColor;
        }

        public final void setLabelColor(String labelColor) {
            this.labelColor = labelColor;
        }

        @Override
        public final Builder labelColor(String labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public final String getOverlap() {
            return overlap;
        }

        public final void setOverlap(String overlap) {
            this.overlap = overlap;
        }

        @Override
        public final Builder overlap(String overlap) {
            this.overlap = overlap;
            return this;
        }

        @Override
        public final Builder overlap(DataLabelOverlap overlap) {
            this.overlap(overlap == null ? null : overlap.toString());
            return this;
        }

        public final String getTotalsVisibility() {
            return totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        @Override
        public DataLabelOptions build() {
            return new DataLabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
