/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssetBundleExportJobRequest extends QuickSightRequest implements
        ToCopyableBuilder<StartAssetBundleExportJobRequest.Builder, StartAssetBundleExportJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(StartAssetBundleExportJobRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleExportJobId").getter(getter(StartAssetBundleExportJobRequest::assetBundleExportJobId))
            .setter(setter(Builder::assetBundleExportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(StartAssetBundleExportJobRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAllDependencies").getter(getter(StartAssetBundleExportJobRequest::includeAllDependencies))
            .setter(setter(Builder::includeAllDependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build())
            .build();

    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFormat").getter(getter(StartAssetBundleExportJobRequest::exportFormatAsString))
            .setter(setter(Builder::exportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()).build();

    private static final SdkField<AssetBundleCloudFormationOverridePropertyConfiguration> CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD = SdkField
            .<AssetBundleCloudFormationOverridePropertyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudFormationOverridePropertyConfiguration")
            .getter(getter(StartAssetBundleExportJobRequest::cloudFormationOverridePropertyConfiguration))
            .setter(setter(Builder::cloudFormationOverridePropertyConfiguration))
            .constructor(AssetBundleCloudFormationOverridePropertyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudFormationOverridePropertyConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, RESOURCE_ARNS_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD,
            CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD));

    private final String awsAccountId;

    private final String assetBundleExportJobId;

    private final List<String> resourceArns;

    private final Boolean includeAllDependencies;

    private final String exportFormat;

    private final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;

    private StartAssetBundleExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.resourceArns = builder.resourceArns;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.cloudFormationOverridePropertyConfiguration = builder.cloudFormationOverridePropertyConfiguration;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account to export assets from.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account to export assets from.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID
     * for another job.
     * </p>
     * 
     * @return The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse
     *         this ID for another job.
     */
    public final String assetBundleExportJobId() {
        return assetBundleExportJobId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of resource ARNs to export. The following resources are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Analysis</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Dashboard</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataSet</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataSource</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RefreshSchedule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Theme</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VPCConnection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The API caller must have the necessary permissions in their IAM role to access each resource before the resources
     * can be exported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return An array of resource ARNs to export. The following resources are supported.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Analysis</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Dashboard</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataSet</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataSource</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RefreshSchedule</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Theme</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VPCConnection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The API caller must have the necessary permissions in their IAM role to access each resource before the
     *         resources can be exported.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the job.
     * For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set
     * <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and dataource resource that is a
     * dependency of the dashboard is also exported.
     * </p>
     * 
     * @return A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the
     *         job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set
     *         <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and dataource resource that
     *         is a dependency of the dashboard is also exported.
     */
    public final Boolean includeAllDependencies() {
        return includeAllDependencies;
    }

    /**
     * <p>
     * The export data format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The export data format.
     * @see AssetBundleExportFormat
     */
    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(exportFormat);
    }

    /**
     * <p>
     * The export data format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The export data format.
     * @see AssetBundleExportFormat
     */
    public final String exportFormatAsString() {
        return exportFormat;
    }

    /**
     * <p>
     * An optional collection of structures that generate CloudFormation parameters to override the existing resource
     * property values when the resource is exported to a new CloudFormation template.
     * </p>
     * <p>
     * Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API call
     * is set to <code>CLOUDFORMATION_JSON</code>.
     * </p>
     * 
     * @return An optional collection of structures that generate CloudFormation parameters to override the existing
     *         resource property values when the resource is exported to a new CloudFormation template.</p>
     *         <p>
     *         Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code>
     *         API call is set to <code>CLOUDFORMATION_JSON</code>.
     */
    public final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration() {
        return cloudFormationOverridePropertyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationOverridePropertyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleExportJobRequest)) {
            return false;
        }
        StartAssetBundleExportJobRequest other = (StartAssetBundleExportJobRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(assetBundleExportJobId(), other.assetBundleExportJobId())
                && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(includeAllDependencies(), other.includeAllDependencies())
                && Objects.equals(exportFormatAsString(), other.exportFormatAsString())
                && Objects.equals(cloudFormationOverridePropertyConfiguration(),
                        other.cloudFormationOverridePropertyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssetBundleExportJobRequest").add("AwsAccountId", awsAccountId())
                .add("AssetBundleExportJobId", assetBundleExportJobId())
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("IncludeAllDependencies", includeAllDependencies()).add("ExportFormat", exportFormatAsString())
                .add("CloudFormationOverridePropertyConfiguration", cloudFormationOverridePropertyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssetBundleExportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleExportJobId()));
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "IncludeAllDependencies":
            return Optional.ofNullable(clazz.cast(includeAllDependencies()));
        case "ExportFormat":
            return Optional.ofNullable(clazz.cast(exportFormatAsString()));
        case "CloudFormationOverridePropertyConfiguration":
            return Optional.ofNullable(clazz.cast(cloudFormationOverridePropertyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleExportJobRequest, T> g) {
        return obj -> g.apply((StartAssetBundleExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssetBundleExportJobRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account to export assets from.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account to export assets from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this
         * ID for another job.
         * </p>
         * 
         * @param assetBundleExportJobId
         *        The ID of the job. This ID is unique while the job is running. After the job is completed, you can
         *        reuse this ID for another job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleExportJobId(String assetBundleExportJobId);

        /**
         * <p>
         * An array of resource ARNs to export. The following resources are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Analysis</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dashboard</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RefreshSchedule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Theme</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPCConnection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The API caller must have the necessary permissions in their IAM role to access each resource before the
         * resources can be exported.
         * </p>
         * 
         * @param resourceArns
         *        An array of resource ARNs to export. The following resources are supported.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Analysis</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dashboard</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSource</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RefreshSchedule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Theme</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPCConnection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The API caller must have the necessary permissions in their IAM role to access each resource before
         *        the resources can be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * An array of resource ARNs to export. The following resources are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Analysis</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dashboard</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RefreshSchedule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Theme</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPCConnection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The API caller must have the necessary permissions in their IAM role to access each resource before the
         * resources can be exported.
         * </p>
         * 
         * @param resourceArns
         *        An array of resource ARNs to export. The following resources are supported.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Analysis</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dashboard</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSource</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RefreshSchedule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Theme</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPCConnection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The API caller must have the necessary permissions in their IAM role to access each resource before
         *        the resources can be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the
         * job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set
         * <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and dataource resource that is
         * a dependency of the dashboard is also exported.
         * </p>
         * 
         * @param includeAllDependencies
         *        A Boolean that determines whether all dependencies of each resource ARN are recursively exported with
         *        the job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If
         *        you set <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and dataource
         *        resource that is a dependency of the dashboard is also exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllDependencies(Boolean includeAllDependencies);

        /**
         * <p>
         * The export data format.
         * </p>
         * 
         * @param exportFormat
         *        The export data format.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(String exportFormat);

        /**
         * <p>
         * The export data format.
         * </p>
         * 
         * @param exportFormat
         *        The export data format.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(AssetBundleExportFormat exportFormat);

        /**
         * <p>
         * An optional collection of structures that generate CloudFormation parameters to override the existing
         * resource property values when the resource is exported to a new CloudFormation template.
         * </p>
         * <p>
         * Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API
         * call is set to <code>CLOUDFORMATION_JSON</code>.
         * </p>
         * 
         * @param cloudFormationOverridePropertyConfiguration
         *        An optional collection of structures that generate CloudFormation parameters to override the existing
         *        resource property values when the resource is exported to a new CloudFormation template.</p>
         *        <p>
         *        Use this field if the <code>ExportFormat</code> field of a
         *        <code>StartAssetBundleExportJobRequest</code> API call is set to <code>CLOUDFORMATION_JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration);

        /**
         * <p>
         * An optional collection of structures that generate CloudFormation parameters to override the existing
         * resource property values when the resource is exported to a new CloudFormation template.
         * </p>
         * <p>
         * Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API
         * call is set to <code>CLOUDFORMATION_JSON</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder} avoiding the need to create one
         * manually via {@link AssetBundleCloudFormationOverridePropertyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration)}.
         * 
         * @param cloudFormationOverridePropertyConfiguration
         *        a consumer that will call methods on
         *        {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration)
         */
        default Builder cloudFormationOverridePropertyConfiguration(
                Consumer<AssetBundleCloudFormationOverridePropertyConfiguration.Builder> cloudFormationOverridePropertyConfiguration) {
            return cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration.builder()
                    .applyMutation(cloudFormationOverridePropertyConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String assetBundleExportJobId;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeAllDependencies;

        private String exportFormat;

        private AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleExportJobRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            assetBundleExportJobId(model.assetBundleExportJobId);
            resourceArns(model.resourceArns);
            includeAllDependencies(model.includeAllDependencies);
            exportFormat(model.exportFormat);
            cloudFormationOverridePropertyConfiguration(model.cloudFormationOverridePropertyConfiguration);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final AssetBundleCloudFormationOverridePropertyConfiguration.Builder getCloudFormationOverridePropertyConfiguration() {
            return cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration.toBuilder()
                    : null;
        }

        public final void setCloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration.BuilderImpl cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssetBundleExportJobRequest build() {
            return new StartAssetBundleExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
