/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the default settings of a free-form layout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFreeFormLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultFreeFormLayoutConfiguration.Builder, DefaultFreeFormLayoutConfiguration> {
    private static final SdkField<FreeFormLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField
            .<FreeFormLayoutCanvasSizeOptions> builder(MarshallingType.SDK_POJO).memberName("CanvasSizeOptions")
            .getter(getter(DefaultFreeFormLayoutConfiguration::canvasSizeOptions)).setter(setter(Builder::canvasSizeOptions))
            .constructor(FreeFormLayoutCanvasSizeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANVAS_SIZE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FreeFormLayoutCanvasSizeOptions canvasSizeOptions;

    private DefaultFreeFormLayoutConfiguration(BuilderImpl builder) {
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    /**
     * <p>
     * Determines the screen canvas size options for a free-form layout.
     * </p>
     * 
     * @return Determines the screen canvas size options for a free-form layout.
     */
    public final FreeFormLayoutCanvasSizeOptions canvasSizeOptions() {
        return canvasSizeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canvasSizeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFreeFormLayoutConfiguration)) {
            return false;
        }
        DefaultFreeFormLayoutConfiguration other = (DefaultFreeFormLayoutConfiguration) obj;
        return Objects.equals(canvasSizeOptions(), other.canvasSizeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultFreeFormLayoutConfiguration").add("CanvasSizeOptions", canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanvasSizeOptions":
            return Optional.ofNullable(clazz.cast(canvasSizeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultFreeFormLayoutConfiguration, T> g) {
        return obj -> g.apply((DefaultFreeFormLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultFreeFormLayoutConfiguration> {
        /**
         * <p>
         * Determines the screen canvas size options for a free-form layout.
         * </p>
         * 
         * @param canvasSizeOptions
         *        Determines the screen canvas size options for a free-form layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canvasSizeOptions(FreeFormLayoutCanvasSizeOptions canvasSizeOptions);

        /**
         * <p>
         * Determines the screen canvas size options for a free-form layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link FreeFormLayoutCanvasSizeOptions.Builder}
         * avoiding the need to create one manually via {@link FreeFormLayoutCanvasSizeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FreeFormLayoutCanvasSizeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #canvasSizeOptions(FreeFormLayoutCanvasSizeOptions)}.
         * 
         * @param canvasSizeOptions
         *        a consumer that will call methods on {@link FreeFormLayoutCanvasSizeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canvasSizeOptions(FreeFormLayoutCanvasSizeOptions)
         */
        default Builder canvasSizeOptions(Consumer<FreeFormLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return canvasSizeOptions(FreeFormLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FreeFormLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFreeFormLayoutConfiguration model) {
            canvasSizeOptions(model.canvasSizeOptions);
        }

        public final FreeFormLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return canvasSizeOptions != null ? canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(FreeFormLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(FreeFormLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        @Override
        public DefaultFreeFormLayoutConfiguration build() {
            return new DefaultFreeFormLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
