/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a <code>PivotTableVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableConfiguration.Builder, PivotTableConfiguration> {
    private static final SdkField<PivotTableFieldWells> FIELD_WELLS_FIELD = SdkField
            .<PivotTableFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(PivotTableConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(PivotTableFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<PivotTableSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<PivotTableSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(PivotTableConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(PivotTableSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<PivotTableOptions> TABLE_OPTIONS_FIELD = SdkField
            .<PivotTableOptions> builder(MarshallingType.SDK_POJO).memberName("TableOptions")
            .getter(getter(PivotTableConfiguration::tableOptions)).setter(setter(Builder::tableOptions))
            .constructor(PivotTableOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptions").build()).build();

    private static final SdkField<PivotTableTotalOptions> TOTAL_OPTIONS_FIELD = SdkField
            .<PivotTableTotalOptions> builder(MarshallingType.SDK_POJO).memberName("TotalOptions")
            .getter(getter(PivotTableConfiguration::totalOptions)).setter(setter(Builder::totalOptions))
            .constructor(PivotTableTotalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalOptions").build()).build();

    private static final SdkField<PivotTableFieldOptions> FIELD_OPTIONS_FIELD = SdkField
            .<PivotTableFieldOptions> builder(MarshallingType.SDK_POJO).memberName("FieldOptions")
            .getter(getter(PivotTableConfiguration::fieldOptions)).setter(setter(Builder::fieldOptions))
            .constructor(PivotTableFieldOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldOptions").build()).build();

    private static final SdkField<PivotTablePaginatedReportOptions> PAGINATED_REPORT_OPTIONS_FIELD = SdkField
            .<PivotTablePaginatedReportOptions> builder(MarshallingType.SDK_POJO).memberName("PaginatedReportOptions")
            .getter(getter(PivotTableConfiguration::paginatedReportOptions)).setter(setter(Builder::paginatedReportOptions))
            .constructor(PivotTablePaginatedReportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginatedReportOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, TABLE_OPTIONS_FIELD, TOTAL_OPTIONS_FIELD, FIELD_OPTIONS_FIELD,
            PAGINATED_REPORT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PivotTableFieldWells fieldWells;

    private final PivotTableSortConfiguration sortConfiguration;

    private final PivotTableOptions tableOptions;

    private final PivotTableTotalOptions totalOptions;

    private final PivotTableFieldOptions fieldOptions;

    private final PivotTablePaginatedReportOptions paginatedReportOptions;

    private PivotTableConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.tableOptions = builder.tableOptions;
        this.totalOptions = builder.totalOptions;
        this.fieldOptions = builder.fieldOptions;
        this.paginatedReportOptions = builder.paginatedReportOptions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final PivotTableFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration for a <code>PivotTableVisual</code>.
     * </p>
     * 
     * @return The sort configuration for a <code>PivotTableVisual</code>.
     */
    public final PivotTableSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The table options for a pivot table visual.
     * </p>
     * 
     * @return The table options for a pivot table visual.
     */
    public final PivotTableOptions tableOptions() {
        return tableOptions;
    }

    /**
     * <p>
     * The total options for a pivot table visual.
     * </p>
     * 
     * @return The total options for a pivot table visual.
     */
    public final PivotTableTotalOptions totalOptions() {
        return totalOptions;
    }

    /**
     * <p>
     * The field options for a pivot table visual.
     * </p>
     * 
     * @return The field options for a pivot table visual.
     */
    public final PivotTableFieldOptions fieldOptions() {
        return fieldOptions;
    }

    /**
     * <p>
     * The paginated report options for a pivot table visual.
     * </p>
     * 
     * @return The paginated report options for a pivot table visual.
     */
    public final PivotTablePaginatedReportOptions paginatedReportOptions() {
        return paginatedReportOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tableOptions());
        hashCode = 31 * hashCode + Objects.hashCode(totalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(fieldOptions());
        hashCode = 31 * hashCode + Objects.hashCode(paginatedReportOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableConfiguration)) {
            return false;
        }
        PivotTableConfiguration other = (PivotTableConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(tableOptions(), other.tableOptions()) && Objects.equals(totalOptions(), other.totalOptions())
                && Objects.equals(fieldOptions(), other.fieldOptions())
                && Objects.equals(paginatedReportOptions(), other.paginatedReportOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("TableOptions", tableOptions())
                .add("TotalOptions", totalOptions()).add("FieldOptions", fieldOptions())
                .add("PaginatedReportOptions", paginatedReportOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "TableOptions":
            return Optional.ofNullable(clazz.cast(tableOptions()));
        case "TotalOptions":
            return Optional.ofNullable(clazz.cast(totalOptions()));
        case "FieldOptions":
            return Optional.ofNullable(clazz.cast(fieldOptions()));
        case "PaginatedReportOptions":
            return Optional.ofNullable(clazz.cast(paginatedReportOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableConfiguration, T> g) {
        return obj -> g.apply((PivotTableConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(PivotTableFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableFieldWells.Builder} avoiding
         * the need to create one manually via {@link PivotTableFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(PivotTableFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link PivotTableFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(PivotTableFieldWells)
         */
        default Builder fieldWells(Consumer<PivotTableFieldWells.Builder> fieldWells) {
            return fieldWells(PivotTableFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration for a <code>PivotTableVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration for a <code>PivotTableVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(PivotTableSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration for a <code>PivotTableVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link PivotTableSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(PivotTableSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link PivotTableSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(PivotTableSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<PivotTableSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(PivotTableSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The table options for a pivot table visual.
         * </p>
         * 
         * @param tableOptions
         *        The table options for a pivot table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptions(PivotTableOptions tableOptions);

        /**
         * <p>
         * The table options for a pivot table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableOptions.Builder} avoiding the
         * need to create one manually via {@link PivotTableOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tableOptions(PivotTableOptions)}.
         * 
         * @param tableOptions
         *        a consumer that will call methods on {@link PivotTableOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableOptions(PivotTableOptions)
         */
        default Builder tableOptions(Consumer<PivotTableOptions.Builder> tableOptions) {
            return tableOptions(PivotTableOptions.builder().applyMutation(tableOptions).build());
        }

        /**
         * <p>
         * The total options for a pivot table visual.
         * </p>
         * 
         * @param totalOptions
         *        The total options for a pivot table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalOptions(PivotTableTotalOptions totalOptions);

        /**
         * <p>
         * The total options for a pivot table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableTotalOptions.Builder} avoiding
         * the need to create one manually via {@link PivotTableTotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableTotalOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #totalOptions(PivotTableTotalOptions)}.
         * 
         * @param totalOptions
         *        a consumer that will call methods on {@link PivotTableTotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalOptions(PivotTableTotalOptions)
         */
        default Builder totalOptions(Consumer<PivotTableTotalOptions.Builder> totalOptions) {
            return totalOptions(PivotTableTotalOptions.builder().applyMutation(totalOptions).build());
        }

        /**
         * <p>
         * The field options for a pivot table visual.
         * </p>
         * 
         * @param fieldOptions
         *        The field options for a pivot table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldOptions(PivotTableFieldOptions fieldOptions);

        /**
         * <p>
         * The field options for a pivot table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableFieldOptions.Builder} avoiding
         * the need to create one manually via {@link PivotTableFieldOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableFieldOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldOptions(PivotTableFieldOptions)}.
         * 
         * @param fieldOptions
         *        a consumer that will call methods on {@link PivotTableFieldOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldOptions(PivotTableFieldOptions)
         */
        default Builder fieldOptions(Consumer<PivotTableFieldOptions.Builder> fieldOptions) {
            return fieldOptions(PivotTableFieldOptions.builder().applyMutation(fieldOptions).build());
        }

        /**
         * <p>
         * The paginated report options for a pivot table visual.
         * </p>
         * 
         * @param paginatedReportOptions
         *        The paginated report options for a pivot table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginatedReportOptions(PivotTablePaginatedReportOptions paginatedReportOptions);

        /**
         * <p>
         * The paginated report options for a pivot table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTablePaginatedReportOptions.Builder}
         * avoiding the need to create one manually via {@link PivotTablePaginatedReportOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTablePaginatedReportOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #paginatedReportOptions(PivotTablePaginatedReportOptions)}.
         * 
         * @param paginatedReportOptions
         *        a consumer that will call methods on {@link PivotTablePaginatedReportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paginatedReportOptions(PivotTablePaginatedReportOptions)
         */
        default Builder paginatedReportOptions(Consumer<PivotTablePaginatedReportOptions.Builder> paginatedReportOptions) {
            return paginatedReportOptions(PivotTablePaginatedReportOptions.builder().applyMutation(paginatedReportOptions)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PivotTableFieldWells fieldWells;

        private PivotTableSortConfiguration sortConfiguration;

        private PivotTableOptions tableOptions;

        private PivotTableTotalOptions totalOptions;

        private PivotTableFieldOptions fieldOptions;

        private PivotTablePaginatedReportOptions paginatedReportOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            tableOptions(model.tableOptions);
            totalOptions(model.totalOptions);
            fieldOptions(model.fieldOptions);
            paginatedReportOptions(model.paginatedReportOptions);
        }

        public final PivotTableFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(PivotTableFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(PivotTableFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final PivotTableSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(PivotTableSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(PivotTableSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final PivotTableOptions.Builder getTableOptions() {
            return tableOptions != null ? tableOptions.toBuilder() : null;
        }

        public final void setTableOptions(PivotTableOptions.BuilderImpl tableOptions) {
            this.tableOptions = tableOptions != null ? tableOptions.build() : null;
        }

        @Override
        public final Builder tableOptions(PivotTableOptions tableOptions) {
            this.tableOptions = tableOptions;
            return this;
        }

        public final PivotTableTotalOptions.Builder getTotalOptions() {
            return totalOptions != null ? totalOptions.toBuilder() : null;
        }

        public final void setTotalOptions(PivotTableTotalOptions.BuilderImpl totalOptions) {
            this.totalOptions = totalOptions != null ? totalOptions.build() : null;
        }

        @Override
        public final Builder totalOptions(PivotTableTotalOptions totalOptions) {
            this.totalOptions = totalOptions;
            return this;
        }

        public final PivotTableFieldOptions.Builder getFieldOptions() {
            return fieldOptions != null ? fieldOptions.toBuilder() : null;
        }

        public final void setFieldOptions(PivotTableFieldOptions.BuilderImpl fieldOptions) {
            this.fieldOptions = fieldOptions != null ? fieldOptions.build() : null;
        }

        @Override
        public final Builder fieldOptions(PivotTableFieldOptions fieldOptions) {
            this.fieldOptions = fieldOptions;
            return this;
        }

        public final PivotTablePaginatedReportOptions.Builder getPaginatedReportOptions() {
            return paginatedReportOptions != null ? paginatedReportOptions.toBuilder() : null;
        }

        public final void setPaginatedReportOptions(PivotTablePaginatedReportOptions.BuilderImpl paginatedReportOptions) {
            this.paginatedReportOptions = paginatedReportOptions != null ? paginatedReportOptions.build() : null;
        }

        @Override
        public final Builder paginatedReportOptions(PivotTablePaginatedReportOptions paginatedReportOptions) {
            this.paginatedReportOptions = paginatedReportOptions;
            return this;
        }

        @Override
        public PivotTableConfiguration build() {
            return new PivotTableConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
