/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetBundleExportJobResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAssetBundleExportJobResponse.Builder, DescribeAssetBundleExportJobResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(DescribeAssetBundleExportJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DownloadUrl").getter(getter(DescribeAssetBundleExportJobResponse::downloadUrl))
            .setter(setter(Builder::downloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUrl").build()).build();

    private static final SdkField<List<AssetBundleExportJobError>> ERRORS_FIELD = SdkField
            .<List<AssetBundleExportJobError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DescribeAssetBundleExportJobResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeAssetBundleExportJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeAssetBundleExportJobResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleExportJobId").getter(getter(DescribeAssetBundleExportJobResponse::assetBundleExportJobId))
            .setter(setter(Builder::assetBundleExportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build())
            .build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeAssetBundleExportJobResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(DescribeAssetBundleExportJobResponse::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAllDependencies").getter(getter(DescribeAssetBundleExportJobResponse::includeAllDependencies))
            .setter(setter(Builder::includeAllDependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build())
            .build();

    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFormat").getter(getter(DescribeAssetBundleExportJobResponse::exportFormatAsString))
            .setter(setter(Builder::exportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()).build();

    private static final SdkField<AssetBundleCloudFormationOverridePropertyConfiguration> CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD = SdkField
            .<AssetBundleCloudFormationOverridePropertyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudFormationOverridePropertyConfiguration")
            .getter(getter(DescribeAssetBundleExportJobResponse::cloudFormationOverridePropertyConfiguration))
            .setter(setter(Builder::cloudFormationOverridePropertyConfiguration))
            .constructor(AssetBundleCloudFormationOverridePropertyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudFormationOverridePropertyConfiguration").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAssetBundleExportJobResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAssetBundleExportJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            DOWNLOAD_URL_FIELD, ERRORS_FIELD, ARN_FIELD, CREATED_TIME_FIELD, ASSET_BUNDLE_EXPORT_JOB_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, RESOURCE_ARNS_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD,
            CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String jobStatus;

    private final String downloadUrl;

    private final List<AssetBundleExportJobError> errors;

    private final String arn;

    private final Instant createdTime;

    private final String assetBundleExportJobId;

    private final String awsAccountId;

    private final List<String> resourceArns;

    private final Boolean includeAllDependencies;

    private final String exportFormat;

    private final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;

    private final String requestId;

    private final Integer status;

    private DescribeAssetBundleExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.downloadUrl = builder.downloadUrl;
        this.errors = builder.errors;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.awsAccountId = builder.awsAccountId;
        this.resourceArns = builder.resourceArns;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.cloudFormationOverridePropertyConfiguration = builder.cloudFormationOverridePropertyConfiguration;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Indicates the status of a job through its queuing and execution.
     * </p>
     * <p>
     * Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
     * <code>SUCCESSFUL</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job through its queuing and execution.</p>
     *         <p>
     *         Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
     *         <code>SUCCESSFUL</code> or <code>FAILED</code>.
     * @see AssetBundleExportJobStatus
     */
    public final AssetBundleExportJobStatus jobStatus() {
        return AssetBundleExportJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Indicates the status of a job through its queuing and execution.
     * </p>
     * <p>
     * Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
     * <code>SUCCESSFUL</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job through its queuing and execution.</p>
     *         <p>
     *         Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
     *         <code>SUCCESSFUL</code> or <code>FAILED</code>.
     * @see AssetBundleExportJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The URL to download the exported asset bundle data from.
     * </p>
     * <p>
     * This URL is available only after the job has succeeded. This URL is valid for 5 minutes after issuance. Call
     * <code>DescribeAssetBundleExportJob</code> again for a fresh URL if needed.
     * </p>
     * <p>
     * The downloaded asset bundle is a zip file named <code>assetbundle-{jobId}.qs</code>. The file has a
     * <code>.qs</code> extension.
     * </p>
     * <p>
     * This URL can't be used in a <code>StartAssetBundleImportJob</code> API call and should only be used for download
     * purposes.
     * </p>
     * 
     * @return The URL to download the exported asset bundle data from.</p>
     *         <p>
     *         This URL is available only after the job has succeeded. This URL is valid for 5 minutes after issuance.
     *         Call <code>DescribeAssetBundleExportJob</code> again for a fresh URL if needed.
     *         </p>
     *         <p>
     *         The downloaded asset bundle is a zip file named <code>assetbundle-{jobId}.qs</code>. The file has a
     *         <code>.qs</code> extension.
     *         </p>
     *         <p>
     *         This URL can't be used in a <code>StartAssetBundleImportJob</code> API call and should only be used for
     *         download purposes.
     */
    public final String downloadUrl() {
        return downloadUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of error records that describes any failures that occurred during the export job processing.
     * </p>
     * <p>
     * Error records accumulate while the job runs. The complete set of error records is available after the job has
     * completed and failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of error records that describes any failures that occurred during the export job processing.</p>
     *         <p>
     *         Error records accumulate while the job runs. The complete set of error records is available after the job
     *         has completed and failed.
     */
    public final List<AssetBundleExportJobError> errors() {
        return errors;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the export job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time that the export job was created.
     * </p>
     * 
     * @return The time that the export job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleExportJob</code> API
     * call.
     * </p>
     * 
     * @return The ID of the job. The job ID is set when you start a new job with a
     *         <code>StartAssetBundleExportJob</code> API call.
     */
    public final String assetBundleExportJobId() {
        return assetBundleExportJobId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that the export job was executed in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that the export job was executed in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource ARNs that exported with the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return A list of resource ARNs that exported with the job.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * The include dependencies flag.
     * </p>
     * 
     * @return The include dependencies flag.
     */
    public final Boolean includeAllDependencies() {
        return includeAllDependencies;
    }

    /**
     * <p>
     * The format of the export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format of the export.
     * @see AssetBundleExportFormat
     */
    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(exportFormat);
    }

    /**
     * <p>
     * The format of the export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format of the export.
     * @see AssetBundleExportFormat
     */
    public final String exportFormatAsString() {
        return exportFormat;
    }

    /**
     * <p>
     * The CloudFormation override property configuration for the export job.
     * </p>
     * 
     * @return The CloudFormation override property configuration for the export job.
     */
    public final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration() {
        return cloudFormationOverridePropertyConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the response.
     * </p>
     * 
     * @return The HTTP status of the response.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationOverridePropertyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetBundleExportJobResponse)) {
            return false;
        }
        DescribeAssetBundleExportJobResponse other = (DescribeAssetBundleExportJobResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(downloadUrl(), other.downloadUrl())
                && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors())
                && Objects.equals(arn(), other.arn())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(assetBundleExportJobId(), other.assetBundleExportJobId())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(includeAllDependencies(), other.includeAllDependencies())
                && Objects.equals(exportFormatAsString(), other.exportFormatAsString())
                && Objects.equals(cloudFormationOverridePropertyConfiguration(),
                        other.cloudFormationOverridePropertyConfiguration()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetBundleExportJobResponse").add("JobStatus", jobStatusAsString())
                .add("DownloadUrl", downloadUrl()).add("Errors", hasErrors() ? errors() : null).add("Arn", arn())
                .add("CreatedTime", createdTime()).add("AssetBundleExportJobId", assetBundleExportJobId())
                .add("AwsAccountId", awsAccountId()).add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("IncludeAllDependencies", includeAllDependencies()).add("ExportFormat", exportFormatAsString())
                .add("CloudFormationOverridePropertyConfiguration", cloudFormationOverridePropertyConfiguration())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "DownloadUrl":
            return Optional.ofNullable(clazz.cast(downloadUrl()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "AssetBundleExportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleExportJobId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "IncludeAllDependencies":
            return Optional.ofNullable(clazz.cast(includeAllDependencies()));
        case "ExportFormat":
            return Optional.ofNullable(clazz.cast(exportFormatAsString()));
        case "CloudFormationOverridePropertyConfiguration":
            return Optional.ofNullable(clazz.cast(cloudFormationOverridePropertyConfiguration()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetBundleExportJobResponse, T> g) {
        return obj -> g.apply((DescribeAssetBundleExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetBundleExportJobResponse> {
        /**
         * <p>
         * Indicates the status of a job through its queuing and execution.
         * </p>
         * <p>
         * Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
         * <code>SUCCESSFUL</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param jobStatus
         *        Indicates the status of a job through its queuing and execution.</p>
         *        <p>
         *        Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
         *        <code>SUCCESSFUL</code> or <code>FAILED</code>.
         * @see AssetBundleExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Indicates the status of a job through its queuing and execution.
         * </p>
         * <p>
         * Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
         * <code>SUCCESSFUL</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param jobStatus
         *        Indicates the status of a job through its queuing and execution.</p>
         *        <p>
         *        Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either
         *        <code>SUCCESSFUL</code> or <code>FAILED</code>.
         * @see AssetBundleExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportJobStatus
         */
        Builder jobStatus(AssetBundleExportJobStatus jobStatus);

        /**
         * <p>
         * The URL to download the exported asset bundle data from.
         * </p>
         * <p>
         * This URL is available only after the job has succeeded. This URL is valid for 5 minutes after issuance. Call
         * <code>DescribeAssetBundleExportJob</code> again for a fresh URL if needed.
         * </p>
         * <p>
         * The downloaded asset bundle is a zip file named <code>assetbundle-{jobId}.qs</code>. The file has a
         * <code>.qs</code> extension.
         * </p>
         * <p>
         * This URL can't be used in a <code>StartAssetBundleImportJob</code> API call and should only be used for
         * download purposes.
         * </p>
         * 
         * @param downloadUrl
         *        The URL to download the exported asset bundle data from.</p>
         *        <p>
         *        This URL is available only after the job has succeeded. This URL is valid for 5 minutes after
         *        issuance. Call <code>DescribeAssetBundleExportJob</code> again for a fresh URL if needed.
         *        </p>
         *        <p>
         *        The downloaded asset bundle is a zip file named <code>assetbundle-{jobId}.qs</code>. The file has a
         *        <code>.qs</code> extension.
         *        </p>
         *        <p>
         *        This URL can't be used in a <code>StartAssetBundleImportJob</code> API call and should only be used
         *        for download purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUrl(String downloadUrl);

        /**
         * <p>
         * An array of error records that describes any failures that occurred during the export job processing.
         * </p>
         * <p>
         * Error records accumulate while the job runs. The complete set of error records is available after the job has
         * completed and failed.
         * </p>
         * 
         * @param errors
         *        An array of error records that describes any failures that occurred during the export job
         *        processing.</p>
         *        <p>
         *        Error records accumulate while the job runs. The complete set of error records is available after the
         *        job has completed and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AssetBundleExportJobError> errors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred during the export job processing.
         * </p>
         * <p>
         * Error records accumulate while the job runs. The complete set of error records is available after the job has
         * completed and failed.
         * </p>
         * 
         * @param errors
         *        An array of error records that describes any failures that occurred during the export job
         *        processing.</p>
         *        <p>
         *        Error records accumulate while the job runs. The complete set of error records is available after the
         *        job has completed and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AssetBundleExportJobError... errors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred during the export job processing.
         * </p>
         * <p>
         * Error records accumulate while the job runs. The complete set of error records is available after the job has
         * completed and failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<AssetBundleExportJobError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<AssetBundleExportJobError>)
         */
        Builder errors(Consumer<AssetBundleExportJobError.Builder>... errors);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the export job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time that the export job was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleExportJob</code>
         * API call.
         * </p>
         * 
         * @param assetBundleExportJobId
         *        The ID of the job. The job ID is set when you start a new job with a
         *        <code>StartAssetBundleExportJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleExportJobId(String assetBundleExportJobId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that the export job was executed in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that the export job was executed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A list of resource ARNs that exported with the job.
         * </p>
         * 
         * @param resourceArns
         *        A list of resource ARNs that exported with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * A list of resource ARNs that exported with the job.
         * </p>
         * 
         * @param resourceArns
         *        A list of resource ARNs that exported with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The include dependencies flag.
         * </p>
         * 
         * @param includeAllDependencies
         *        The include dependencies flag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllDependencies(Boolean includeAllDependencies);

        /**
         * <p>
         * The format of the export.
         * </p>
         * 
         * @param exportFormat
         *        The format of the export.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(String exportFormat);

        /**
         * <p>
         * The format of the export.
         * </p>
         * 
         * @param exportFormat
         *        The format of the export.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(AssetBundleExportFormat exportFormat);

        /**
         * <p>
         * The CloudFormation override property configuration for the export job.
         * </p>
         * 
         * @param cloudFormationOverridePropertyConfiguration
         *        The CloudFormation override property configuration for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration);

        /**
         * <p>
         * The CloudFormation override property configuration for the export job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder} avoiding the need to create one
         * manually via {@link AssetBundleCloudFormationOverridePropertyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration)}.
         * 
         * @param cloudFormationOverridePropertyConfiguration
         *        a consumer that will call methods on
         *        {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration)
         */
        default Builder cloudFormationOverridePropertyConfiguration(
                Consumer<AssetBundleCloudFormationOverridePropertyConfiguration.Builder> cloudFormationOverridePropertyConfiguration) {
            return cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration.builder()
                    .applyMutation(cloudFormationOverridePropertyConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the response.
         * </p>
         * 
         * @param status
         *        The HTTP status of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String downloadUrl;

        private List<AssetBundleExportJobError> errors = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private Instant createdTime;

        private String assetBundleExportJobId;

        private String awsAccountId;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeAllDependencies;

        private String exportFormat;

        private AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetBundleExportJobResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            downloadUrl(model.downloadUrl);
            errors(model.errors);
            arn(model.arn);
            createdTime(model.createdTime);
            assetBundleExportJobId(model.assetBundleExportJobId);
            awsAccountId(model.awsAccountId);
            resourceArns(model.resourceArns);
            includeAllDependencies(model.includeAllDependencies);
            exportFormat(model.exportFormat);
            cloudFormationOverridePropertyConfiguration(model.cloudFormationOverridePropertyConfiguration);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleExportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getDownloadUrl() {
            return downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final List<AssetBundleExportJobError.Builder> getErrors() {
            List<AssetBundleExportJobError.Builder> result = AssetBundleExportJobErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AssetBundleExportJobError.BuilderImpl> errors) {
            this.errors = AssetBundleExportJobErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AssetBundleExportJobError> errors) {
            this.errors = AssetBundleExportJobErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AssetBundleExportJobError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AssetBundleExportJobError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AssetBundleExportJobError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final AssetBundleCloudFormationOverridePropertyConfiguration.Builder getCloudFormationOverridePropertyConfiguration() {
            return cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration.toBuilder()
                    : null;
        }

        public final void setCloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration.BuilderImpl cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeAssetBundleExportJobResponse build() {
            return new DescribeAssetBundleExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
