/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>TimeEqualityFilter</code> filters values that are equal to a given value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeEqualityFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeEqualityFilter.Builder, TimeEqualityFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(TimeEqualityFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(TimeEqualityFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Instant> VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Value")
            .getter(getter(TimeEqualityFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(TimeEqualityFilter::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TimeEqualityFilter::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            VALUE_FIELD, PARAMETER_NAME_FIELD, TIME_GRANULARITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final Instant value;

    private final String parameterName;

    private final String timeGranularity;

    private TimeEqualityFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.value = builder.value;
        this.parameterName = builder.parameterName;
        this.timeGranularity = builder.timeGranularity;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The value of a <code>TimeEquality</code> filter.
     * </p>
     * <p>
     * This field is mutually exclusive to <code>ParameterName</code>.
     * </p>
     * 
     * @return The value of a <code>TimeEquality</code> filter.</p>
     *         <p>
     *         This field is mutually exclusive to <code>ParameterName</code>.
     */
    public final Instant value() {
        return value;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * <p>
     * This field is mutually exclusive to <code>Value</code>.
     * </p>
     * 
     * @return The parameter whose value should be used for the filter value.</p>
     *         <p>
     *         This field is mutually exclusive to <code>Value</code>.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeEqualityFilter)) {
            return false;
        }
        TimeEqualityFilter other = (TimeEqualityFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(value(), other.value()) && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeEqualityFilter").add("FilterId", filterId()).add("Column", column()).add("Value", value())
                .add("ParameterName", parameterName()).add("TimeGranularity", timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeEqualityFilter, T> g) {
        return obj -> g.apply((TimeEqualityFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeEqualityFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The value of a <code>TimeEquality</code> filter.
         * </p>
         * <p>
         * This field is mutually exclusive to <code>ParameterName</code>.
         * </p>
         * 
         * @param value
         *        The value of a <code>TimeEquality</code> filter.</p>
         *        <p>
         *        This field is mutually exclusive to <code>ParameterName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Instant value);

        /**
         * <p>
         * The parameter whose value should be used for the filter value.
         * </p>
         * <p>
         * This field is mutually exclusive to <code>Value</code>.
         * </p>
         * 
         * @param parameterName
         *        The parameter whose value should be used for the filter value.</p>
         *        <p>
         *        This field is mutually exclusive to <code>Value</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private Instant value;

        private String parameterName;

        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeEqualityFilter model) {
            filterId(model.filterId);
            column(model.column);
            value(model.value);
            parameterName(model.parameterName);
            timeGranularity(model.timeGranularity);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Instant getValue() {
            return value;
        }

        public final void setValue(Instant value) {
            this.value = value;
        }

        @Override
        public final Builder value(Instant value) {
            this.value = value;
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        @Override
        public TimeEqualityFilter build() {
            return new TimeEqualityFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
