/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnalysisPermissionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAnalysisPermissionsResponse.Builder, DescribeAnalysisPermissionsResponse> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(DescribeAnalysisPermissionsResponse::analysisId))
            .setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> ANALYSIS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisArn").getter(getter(DescribeAnalysisPermissionsResponse::analysisArn))
            .setter(setter(Builder::analysisArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisArn").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(DescribeAnalysisPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAnalysisPermissionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAnalysisPermissionsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD,
            ANALYSIS_ARN_FIELD, PERMISSIONS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final String analysisId;

    private final String analysisArn;

    private final List<ResourcePermission> permissions;

    private final Integer status;

    private final String requestId;

    private DescribeAnalysisPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.analysisId = builder.analysisId;
        this.analysisArn = builder.analysisArn;
        this.permissions = builder.permissions;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID of the analysis whose permissions you're describing.
     * </p>
     * 
     * @return The ID of the analysis whose permissions you're describing.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.
     */
    public final String analysisArn() {
        return analysisArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that describes the principals and the resource-level permissions on an analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A structure that describes the principals and the resource-level permissions on an analysis.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisPermissionsResponse)) {
            return false;
        }
        DescribeAnalysisPermissionsResponse other = (DescribeAnalysisPermissionsResponse) obj;
        return Objects.equals(analysisId(), other.analysisId()) && Objects.equals(analysisArn(), other.analysisArn())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnalysisPermissionsResponse").add("AnalysisId", analysisId())
                .add("AnalysisArn", analysisArn()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("Status", status()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "AnalysisArn":
            return Optional.ofNullable(clazz.cast(analysisArn()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeAnalysisPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnalysisPermissionsResponse> {
        /**
         * <p>
         * The ID of the analysis whose permissions you're describing.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis whose permissions you're describing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.
         * </p>
         * 
         * @param analysisArn
         *        The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisArn(String analysisArn);

        /**
         * <p>
         * A structure that describes the principals and the resource-level permissions on an analysis.
         * </p>
         * 
         * @param permissions
         *        A structure that describes the principals and the resource-level permissions on an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A structure that describes the principals and the resource-level permissions on an analysis.
         * </p>
         * 
         * @param permissions
         *        A structure that describes the principals and the resource-level permissions on an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A structure that describes the principals and the resource-level permissions on an analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String analysisId;

        private String analysisArn;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisPermissionsResponse model) {
            super(model);
            analysisId(model.analysisId);
            analysisArn(model.analysisArn);
            permissions(model.permissions);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getAnalysisArn() {
            return analysisArn;
        }

        public final void setAnalysisArn(String analysisArn) {
            this.analysisArn = analysisArn;
        }

        @Override
        public final Builder analysisArn(String analysisArn) {
            this.analysisArn = analysisArn;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeAnalysisPermissionsResponse build() {
            return new DescribeAnalysisPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
