/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountSubscriptionResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAccountSubscriptionResponse.Builder, DescribeAccountSubscriptionResponse> {
    private static final SdkField<AccountInfo> ACCOUNT_INFO_FIELD = SdkField.<AccountInfo> builder(MarshallingType.SDK_POJO)
            .memberName("AccountInfo").getter(getter(DescribeAccountSubscriptionResponse::accountInfo))
            .setter(setter(Builder::accountInfo)).constructor(AccountInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountInfo").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAccountSubscriptionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAccountSubscriptionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_INFO_FIELD,
            STATUS_FIELD, REQUEST_ID_FIELD));

    private final AccountInfo accountInfo;

    private final Integer status;

    private final String requestId;

    private DescribeAccountSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.accountInfo = builder.accountInfo;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * A structure that contains the following elements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your Amazon QuickSight account name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The edition of Amazon QuickSight that your account is using.
     * </p>
     * </li>
     * <li>
     * <p>
     * The notification email address that is associated with the Amazon QuickSight account.
     * </p>
     * </li>
     * <li>
     * <p>
     * The authentication type of the Amazon QuickSight account.
     * </p>
     * </li>
     * <li>
     * <p>
     * The status of the Amazon QuickSight account's subscription.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A structure that contains the following elements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your Amazon QuickSight account name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The edition of Amazon QuickSight that your account is using.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The notification email address that is associated with the Amazon QuickSight account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The authentication type of the Amazon QuickSight account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The status of the Amazon QuickSight account's subscription.
     *         </p>
     *         </li>
     */
    public final AccountInfo accountInfo() {
        return accountInfo;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountSubscriptionResponse)) {
            return false;
        }
        DescribeAccountSubscriptionResponse other = (DescribeAccountSubscriptionResponse) obj;
        return Objects.equals(accountInfo(), other.accountInfo()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountSubscriptionResponse").add("AccountInfo", accountInfo()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountInfo":
            return Optional.ofNullable(clazz.cast(accountInfo()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountSubscriptionResponse, T> g) {
        return obj -> g.apply((DescribeAccountSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountSubscriptionResponse> {
        /**
         * <p>
         * A structure that contains the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Your Amazon QuickSight account name.
         * </p>
         * </li>
         * <li>
         * <p>
         * The edition of Amazon QuickSight that your account is using.
         * </p>
         * </li>
         * <li>
         * <p>
         * The notification email address that is associated with the Amazon QuickSight account.
         * </p>
         * </li>
         * <li>
         * <p>
         * The authentication type of the Amazon QuickSight account.
         * </p>
         * </li>
         * <li>
         * <p>
         * The status of the Amazon QuickSight account's subscription.
         * </p>
         * </li>
         * </ul>
         * 
         * @param accountInfo
         *        A structure that contains the following elements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Your Amazon QuickSight account name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The edition of Amazon QuickSight that your account is using.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The notification email address that is associated with the Amazon QuickSight account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The authentication type of the Amazon QuickSight account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The status of the Amazon QuickSight account's subscription.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountInfo(AccountInfo accountInfo);

        /**
         * <p>
         * A structure that contains the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Your Amazon QuickSight account name.
         * </p>
         * </li>
         * <li>
         * <p>
         * The edition of Amazon QuickSight that your account is using.
         * </p>
         * </li>
         * <li>
         * <p>
         * The notification email address that is associated with the Amazon QuickSight account.
         * </p>
         * </li>
         * <li>
         * <p>
         * The authentication type of the Amazon QuickSight account.
         * </p>
         * </li>
         * <li>
         * <p>
         * The status of the Amazon QuickSight account's subscription.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link AccountInfo.Builder} avoiding the need to
         * create one manually via {@link AccountInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #accountInfo(AccountInfo)}.
         * 
         * @param accountInfo
         *        a consumer that will call methods on {@link AccountInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountInfo(AccountInfo)
         */
        default Builder accountInfo(Consumer<AccountInfo.Builder> accountInfo) {
            return accountInfo(AccountInfo.builder().applyMutation(accountInfo).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private AccountInfo accountInfo;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountSubscriptionResponse model) {
            super(model);
            accountInfo(model.accountInfo);
            status(model.status);
            requestId(model.requestId);
        }

        public final AccountInfo.Builder getAccountInfo() {
            return accountInfo != null ? accountInfo.toBuilder() : null;
        }

        public final void setAccountInfo(AccountInfo.BuilderImpl accountInfo) {
            this.accountInfo = accountInfo != null ? accountInfo.build() : null;
        }

        @Override
        public final Builder accountInfo(AccountInfo accountInfo) {
            this.accountInfo = accountInfo;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeAccountSubscriptionResponse build() {
            return new DescribeAccountSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
