/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.StyledCellType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableStyleTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableStyleTarget> {
    private static final SdkField<String> CELL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CellType").getter(TableStyleTarget.getter(TableStyleTarget::cellTypeAsString)).setter(TableStyleTarget.setter(Builder::cellType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cellType;

    private TableStyleTarget(BuilderImpl builder) {
        this.cellType = builder.cellType;
    }

    public final StyledCellType cellType() {
        return StyledCellType.fromValue(this.cellType);
    }

    public final String cellTypeAsString() {
        return this.cellType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cellTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStyleTarget)) {
            return false;
        }
        TableStyleTarget other = (TableStyleTarget)obj;
        return Objects.equals(this.cellTypeAsString(), other.cellTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TableStyleTarget").add("CellType", (Object)this.cellTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CellType": {
                return Optional.ofNullable(clazz.cast(this.cellTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableStyleTarget, T> g) {
        return obj -> g.apply((TableStyleTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cellType;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStyleTarget model) {
            this.cellType(model.cellType);
        }

        public final String getCellType() {
            return this.cellType;
        }

        public final void setCellType(String cellType) {
            this.cellType = cellType;
        }

        @Override
        public final Builder cellType(String cellType) {
            this.cellType = cellType;
            return this;
        }

        @Override
        public final Builder cellType(StyledCellType cellType) {
            this.cellType(cellType == null ? null : cellType.toString());
            return this;
        }

        public TableStyleTarget build() {
            return new TableStyleTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableStyleTarget> {
        public Builder cellType(String var1);

        public Builder cellType(StyledCellType var1);
    }
}

