/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a sankey diagram.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SankeyDiagramFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<SankeyDiagramFieldWells.Builder, SankeyDiagramFieldWells> {
    private static final SdkField<SankeyDiagramAggregatedFieldWells> SANKEY_DIAGRAM_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<SankeyDiagramAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("SankeyDiagramAggregatedFieldWells")
            .getter(getter(SankeyDiagramFieldWells::sankeyDiagramAggregatedFieldWells))
            .setter(setter(Builder::sankeyDiagramAggregatedFieldWells))
            .constructor(SankeyDiagramAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SankeyDiagramAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SANKEY_DIAGRAM_AGGREGATED_FIELD_WELLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SankeyDiagramAggregatedFieldWells sankeyDiagramAggregatedFieldWells;

    private SankeyDiagramFieldWells(BuilderImpl builder) {
        this.sankeyDiagramAggregatedFieldWells = builder.sankeyDiagramAggregatedFieldWells;
    }

    /**
     * <p>
     * The field well configuration of a sankey diagram.
     * </p>
     * 
     * @return The field well configuration of a sankey diagram.
     */
    public final SankeyDiagramAggregatedFieldWells sankeyDiagramAggregatedFieldWells() {
        return sankeyDiagramAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sankeyDiagramAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramFieldWells)) {
            return false;
        }
        SankeyDiagramFieldWells other = (SankeyDiagramFieldWells) obj;
        return Objects.equals(sankeyDiagramAggregatedFieldWells(), other.sankeyDiagramAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SankeyDiagramFieldWells")
                .add("SankeyDiagramAggregatedFieldWells", sankeyDiagramAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SankeyDiagramAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(sankeyDiagramAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SankeyDiagramFieldWells, T> g) {
        return obj -> g.apply((SankeyDiagramFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SankeyDiagramFieldWells> {
        /**
         * <p>
         * The field well configuration of a sankey diagram.
         * </p>
         * 
         * @param sankeyDiagramAggregatedFieldWells
         *        The field well configuration of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sankeyDiagramAggregatedFieldWells(SankeyDiagramAggregatedFieldWells sankeyDiagramAggregatedFieldWells);

        /**
         * <p>
         * The field well configuration of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SankeyDiagramAggregatedFieldWells.Builder} avoiding the need to create one manually via
         * {@link SankeyDiagramAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SankeyDiagramAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sankeyDiagramAggregatedFieldWells(SankeyDiagramAggregatedFieldWells)}.
         * 
         * @param sankeyDiagramAggregatedFieldWells
         *        a consumer that will call methods on {@link SankeyDiagramAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sankeyDiagramAggregatedFieldWells(SankeyDiagramAggregatedFieldWells)
         */
        default Builder sankeyDiagramAggregatedFieldWells(
                Consumer<SankeyDiagramAggregatedFieldWells.Builder> sankeyDiagramAggregatedFieldWells) {
            return sankeyDiagramAggregatedFieldWells(SankeyDiagramAggregatedFieldWells.builder()
                    .applyMutation(sankeyDiagramAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SankeyDiagramAggregatedFieldWells sankeyDiagramAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(SankeyDiagramFieldWells model) {
            sankeyDiagramAggregatedFieldWells(model.sankeyDiagramAggregatedFieldWells);
        }

        public final SankeyDiagramAggregatedFieldWells.Builder getSankeyDiagramAggregatedFieldWells() {
            return sankeyDiagramAggregatedFieldWells != null ? sankeyDiagramAggregatedFieldWells.toBuilder() : null;
        }

        public final void setSankeyDiagramAggregatedFieldWells(
                SankeyDiagramAggregatedFieldWells.BuilderImpl sankeyDiagramAggregatedFieldWells) {
            this.sankeyDiagramAggregatedFieldWells = sankeyDiagramAggregatedFieldWells != null ? sankeyDiagramAggregatedFieldWells
                    .build() : null;
        }

        @Override
        public final Builder sankeyDiagramAggregatedFieldWells(SankeyDiagramAggregatedFieldWells sankeyDiagramAggregatedFieldWells) {
            this.sankeyDiagramAggregatedFieldWells = sankeyDiagramAggregatedFieldWells;
            return this;
        }

        @Override
        public SankeyDiagramFieldWells build() {
            return new SankeyDiagramFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
