/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AuthorizedTargetsListCopier;
import software.amazon.awssdk.services.quicksight.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizedTargetsByService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizedTargetsByService> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(AuthorizedTargetsByService.getter(AuthorizedTargetsByService::serviceAsString)).setter(AuthorizedTargetsByService.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTargets").getter(AuthorizedTargetsByService.getter(AuthorizedTargetsByService::authorizedTargets)).setter(AuthorizedTargetsByService.setter(Builder::authorizedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, AUTHORIZED_TARGETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String service;
    private final List<String> authorizedTargets;

    private AuthorizedTargetsByService(BuilderImpl builder) {
        this.service = builder.service;
        this.authorizedTargets = builder.authorizedTargets;
    }

    public final ServiceType service() {
        return ServiceType.fromValue(this.service);
    }

    public final String serviceAsString() {
        return this.service;
    }

    public final boolean hasAuthorizedTargets() {
        return this.authorizedTargets != null && !(this.authorizedTargets instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedTargets() {
        return this.authorizedTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTargets() ? this.authorizedTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTargetsByService)) {
            return false;
        }
        AuthorizedTargetsByService other = (AuthorizedTargetsByService)obj;
        return Objects.equals(this.serviceAsString(), other.serviceAsString()) && this.hasAuthorizedTargets() == other.hasAuthorizedTargets() && Objects.equals(this.authorizedTargets(), other.authorizedTargets());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizedTargetsByService").add("Service", (Object)this.serviceAsString()).add("AuthorizedTargets", this.hasAuthorizedTargets() ? this.authorizedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.serviceAsString()));
            }
            case "AuthorizedTargets": {
                return Optional.ofNullable(clazz.cast(this.authorizedTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedTargetsByService, T> g) {
        return obj -> g.apply((AuthorizedTargetsByService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String service;
        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedTargetsByService model) {
            this.service(model.service);
            this.authorizedTargets(model.authorizedTargets);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(ServiceType service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (this.authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = AuthorizedTargetsListCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = AuthorizedTargetsListCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String ... authorizedTargets) {
            this.authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        public AuthorizedTargetsByService build() {
            return new AuthorizedTargetsByService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizedTargetsByService> {
        public Builder service(String var1);

        public Builder service(ServiceType var1);

        public Builder authorizedTargets(Collection<String> var1);

        public Builder authorizedTargets(String ... var1);
    }
}

