/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a grid layout. Also called a tiled layout.
 * </p>
 * <p>
 * Visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit
 * to screen or view at actual size.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GridLayoutConfiguration.Builder, GridLayoutConfiguration> {
    private static final SdkField<List<GridLayoutElement>> ELEMENTS_FIELD = SdkField
            .<List<GridLayoutElement>> builder(MarshallingType.LIST)
            .memberName("Elements")
            .getter(getter(GridLayoutConfiguration::elements))
            .setter(setter(Builder::elements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GridLayoutElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(GridLayoutElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GridLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField
            .<GridLayoutCanvasSizeOptions> builder(MarshallingType.SDK_POJO).memberName("CanvasSizeOptions")
            .getter(getter(GridLayoutConfiguration::canvasSizeOptions)).setter(setter(Builder::canvasSizeOptions))
            .constructor(GridLayoutCanvasSizeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENTS_FIELD,
            CANVAS_SIZE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GridLayoutElement> elements;

    private final GridLayoutCanvasSizeOptions canvasSizeOptions;

    private GridLayoutConfiguration(BuilderImpl builder) {
        this.elements = builder.elements;
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Elements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasElements() {
        return elements != null && !(elements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elements that are included in a grid layout.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElements} method.
     * </p>
     * 
     * @return The elements that are included in a grid layout.
     */
    public final List<GridLayoutElement> elements() {
        return elements;
    }

    /**
     * Returns the value of the CanvasSizeOptions property for this object.
     * 
     * @return The value of the CanvasSizeOptions property for this object.
     */
    public final GridLayoutCanvasSizeOptions canvasSizeOptions() {
        return canvasSizeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasElements() ? elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(canvasSizeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridLayoutConfiguration)) {
            return false;
        }
        GridLayoutConfiguration other = (GridLayoutConfiguration) obj;
        return hasElements() == other.hasElements() && Objects.equals(elements(), other.elements())
                && Objects.equals(canvasSizeOptions(), other.canvasSizeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridLayoutConfiguration").add("Elements", hasElements() ? elements() : null)
                .add("CanvasSizeOptions", canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Elements":
            return Optional.ofNullable(clazz.cast(elements()));
        case "CanvasSizeOptions":
            return Optional.ofNullable(clazz.cast(canvasSizeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GridLayoutConfiguration, T> g) {
        return obj -> g.apply((GridLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridLayoutConfiguration> {
        /**
         * <p>
         * The elements that are included in a grid layout.
         * </p>
         * 
         * @param elements
         *        The elements that are included in a grid layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(Collection<GridLayoutElement> elements);

        /**
         * <p>
         * The elements that are included in a grid layout.
         * </p>
         * 
         * @param elements
         *        The elements that are included in a grid layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(GridLayoutElement... elements);

        /**
         * <p>
         * The elements that are included in a grid layout.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.GridLayoutElement.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.GridLayoutElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.GridLayoutElement.Builder#build()} is called
         * immediately and its result is passed to {@link #elements(List<GridLayoutElement>)}.
         * 
         * @param elements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.GridLayoutElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elements(java.util.Collection<GridLayoutElement>)
         */
        Builder elements(Consumer<GridLayoutElement.Builder>... elements);

        /**
         * Sets the value of the CanvasSizeOptions property for this object.
         *
         * @param canvasSizeOptions
         *        The new value for the CanvasSizeOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canvasSizeOptions(GridLayoutCanvasSizeOptions canvasSizeOptions);

        /**
         * Sets the value of the CanvasSizeOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GridLayoutCanvasSizeOptions.Builder}
         * avoiding the need to create one manually via {@link GridLayoutCanvasSizeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GridLayoutCanvasSizeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #canvasSizeOptions(GridLayoutCanvasSizeOptions)}.
         * 
         * @param canvasSizeOptions
         *        a consumer that will call methods on {@link GridLayoutCanvasSizeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canvasSizeOptions(GridLayoutCanvasSizeOptions)
         */
        default Builder canvasSizeOptions(Consumer<GridLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return canvasSizeOptions(GridLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<GridLayoutElement> elements = DefaultSdkAutoConstructList.getInstance();

        private GridLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GridLayoutConfiguration model) {
            elements(model.elements);
            canvasSizeOptions(model.canvasSizeOptions);
        }

        public final List<GridLayoutElement.Builder> getElements() {
            List<GridLayoutElement.Builder> result = GridLayoutElementListCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<GridLayoutElement.BuilderImpl> elements) {
            this.elements = GridLayoutElementListCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<GridLayoutElement> elements) {
            this.elements = GridLayoutElementListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(GridLayoutElement... elements) {
            elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<GridLayoutElement.Builder>... elements) {
            elements(Stream.of(elements).map(c -> GridLayoutElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final GridLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return canvasSizeOptions != null ? canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(GridLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(GridLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        @Override
        public GridLayoutConfiguration build() {
            return new GridLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
