/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about the users that the dashboard snapshot is generated for. Sensitive user
 * information is excluded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotUserConfigurationRedacted implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotUserConfigurationRedacted.Builder, SnapshotUserConfigurationRedacted> {
    private static final SdkField<List<SnapshotAnonymousUserRedacted>> ANONYMOUS_USERS_FIELD = SdkField
            .<List<SnapshotAnonymousUserRedacted>> builder(MarshallingType.LIST)
            .memberName("AnonymousUsers")
            .getter(getter(SnapshotUserConfigurationRedacted::anonymousUsers))
            .setter(setter(Builder::anonymousUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotAnonymousUserRedacted> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotAnonymousUserRedacted::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMOUS_USERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SnapshotAnonymousUserRedacted> anonymousUsers;

    private SnapshotUserConfigurationRedacted(BuilderImpl builder) {
        this.anonymousUsers = builder.anonymousUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnonymousUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnonymousUsers() {
        return anonymousUsers != null && !(anonymousUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of records that describe anonymous users that the dashboard snapshot is generated for. Sensitive user
     * information is excluded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnonymousUsers} method.
     * </p>
     * 
     * @return An array of records that describe anonymous users that the dashboard snapshot is generated for. Sensitive
     *         user information is excluded.
     */
    public final List<SnapshotAnonymousUserRedacted> anonymousUsers() {
        return anonymousUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnonymousUsers() ? anonymousUsers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotUserConfigurationRedacted)) {
            return false;
        }
        SnapshotUserConfigurationRedacted other = (SnapshotUserConfigurationRedacted) obj;
        return hasAnonymousUsers() == other.hasAnonymousUsers() && Objects.equals(anonymousUsers(), other.anonymousUsers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotUserConfigurationRedacted")
                .add("AnonymousUsers", hasAnonymousUsers() ? anonymousUsers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnonymousUsers":
            return Optional.ofNullable(clazz.cast(anonymousUsers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotUserConfigurationRedacted, T> g) {
        return obj -> g.apply((SnapshotUserConfigurationRedacted) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotUserConfigurationRedacted> {
        /**
         * <p>
         * An array of records that describe anonymous users that the dashboard snapshot is generated for. Sensitive
         * user information is excluded.
         * </p>
         * 
         * @param anonymousUsers
         *        An array of records that describe anonymous users that the dashboard snapshot is generated for.
         *        Sensitive user information is excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousUsers(Collection<SnapshotAnonymousUserRedacted> anonymousUsers);

        /**
         * <p>
         * An array of records that describe anonymous users that the dashboard snapshot is generated for. Sensitive
         * user information is excluded.
         * </p>
         * 
         * @param anonymousUsers
         *        An array of records that describe anonymous users that the dashboard snapshot is generated for.
         *        Sensitive user information is excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousUsers(SnapshotAnonymousUserRedacted... anonymousUsers);

        /**
         * <p>
         * An array of records that describe anonymous users that the dashboard snapshot is generated for. Sensitive
         * user information is excluded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUserRedacted.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUserRedacted#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUserRedacted.Builder#build()} is
         * called immediately and its result is passed to {@link #anonymousUsers(List<SnapshotAnonymousUserRedacted>)}.
         * 
         * @param anonymousUsers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUserRedacted.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anonymousUsers(java.util.Collection<SnapshotAnonymousUserRedacted>)
         */
        Builder anonymousUsers(Consumer<SnapshotAnonymousUserRedacted.Builder>... anonymousUsers);
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotAnonymousUserRedacted> anonymousUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotUserConfigurationRedacted model) {
            anonymousUsers(model.anonymousUsers);
        }

        public final List<SnapshotAnonymousUserRedacted.Builder> getAnonymousUsers() {
            List<SnapshotAnonymousUserRedacted.Builder> result = SnapshotAnonymousUserRedactedListCopier
                    .copyToBuilder(this.anonymousUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnonymousUsers(Collection<SnapshotAnonymousUserRedacted.BuilderImpl> anonymousUsers) {
            this.anonymousUsers = SnapshotAnonymousUserRedactedListCopier.copyFromBuilder(anonymousUsers);
        }

        @Override
        public final Builder anonymousUsers(Collection<SnapshotAnonymousUserRedacted> anonymousUsers) {
            this.anonymousUsers = SnapshotAnonymousUserRedactedListCopier.copy(anonymousUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(SnapshotAnonymousUserRedacted... anonymousUsers) {
            anonymousUsers(Arrays.asList(anonymousUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(Consumer<SnapshotAnonymousUserRedacted.Builder>... anonymousUsers) {
            anonymousUsers(Stream.of(anonymousUsers).map(c -> SnapshotAnonymousUserRedacted.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotUserConfigurationRedacted build() {
            return new SnapshotUserConfigurationRedacted(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
