/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a scatter plot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScatterPlotConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScatterPlotConfiguration.Builder, ScatterPlotConfiguration> {
    private static final SdkField<ScatterPlotFieldWells> FIELD_WELLS_FIELD = SdkField
            .<ScatterPlotFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(ScatterPlotConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(ScatterPlotFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<ScatterPlotSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<ScatterPlotSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(ScatterPlotConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(ScatterPlotSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<ChartAxisLabelOptions> X_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("XAxisLabelOptions")
            .getter(getter(ScatterPlotConfiguration::xAxisLabelOptions)).setter(setter(Builder::xAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisLabelOptions").build()).build();

    private static final SdkField<AxisDisplayOptions> X_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("XAxisDisplayOptions")
            .getter(getter(ScatterPlotConfiguration::xAxisDisplayOptions)).setter(setter(Builder::xAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("YAxisLabelOptions")
            .getter(getter(ScatterPlotConfiguration::yAxisLabelOptions)).setter(setter(Builder::yAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxisLabelOptions").build()).build();

    private static final SdkField<AxisDisplayOptions> Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("YAxisDisplayOptions")
            .getter(getter(ScatterPlotConfiguration::yAxisDisplayOptions)).setter(setter(Builder::yAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxisDisplayOptions").build())
            .build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(ScatterPlotConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(ScatterPlotConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(ScatterPlotConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(ScatterPlotConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, X_AXIS_LABEL_OPTIONS_FIELD, X_AXIS_DISPLAY_OPTIONS_FIELD, Y_AXIS_LABEL_OPTIONS_FIELD,
            Y_AXIS_DISPLAY_OPTIONS_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD, VISUAL_PALETTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ScatterPlotFieldWells fieldWells;

    private final ScatterPlotSortConfiguration sortConfiguration;

    private final ChartAxisLabelOptions xAxisLabelOptions;

    private final AxisDisplayOptions xAxisDisplayOptions;

    private final ChartAxisLabelOptions yAxisLabelOptions;

    private final AxisDisplayOptions yAxisDisplayOptions;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltip;

    private final VisualPalette visualPalette;

    private ScatterPlotConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.xAxisLabelOptions = builder.xAxisLabelOptions;
        this.xAxisDisplayOptions = builder.xAxisDisplayOptions;
        this.yAxisLabelOptions = builder.yAxisLabelOptions;
        this.yAxisDisplayOptions = builder.yAxisDisplayOptions;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.visualPalette = builder.visualPalette;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final ScatterPlotFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a scatter plot.
     * </p>
     * 
     * @return The sort configuration of a scatter plot.
     */
    public final ScatterPlotSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's x-axis.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) of the scatter plot's x-axis.
     */
    public final ChartAxisLabelOptions xAxisLabelOptions() {
        return xAxisLabelOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, and axis step) of the scatter plot's x-axis.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, and axis step) of the scatter plot's x-axis.
     */
    public final AxisDisplayOptions xAxisDisplayOptions() {
        return xAxisDisplayOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's y-axis.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) of the scatter plot's y-axis.
     */
    public final ChartAxisLabelOptions yAxisLabelOptions() {
        return yAxisLabelOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, and axis step) of the scatter plot's y-axis.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, and axis step) of the scatter plot's y-axis.
     */
    public final AxisDisplayOptions yAxisDisplayOptions() {
        return yAxisDisplayOptions;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The palette (chart color) display setup of the visual.
     * </p>
     * 
     * @return The palette (chart color) display setup of the visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(yAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(yAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScatterPlotConfiguration)) {
            return false;
        }
        ScatterPlotConfiguration other = (ScatterPlotConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(xAxisLabelOptions(), other.xAxisLabelOptions())
                && Objects.equals(xAxisDisplayOptions(), other.xAxisDisplayOptions())
                && Objects.equals(yAxisLabelOptions(), other.yAxisLabelOptions())
                && Objects.equals(yAxisDisplayOptions(), other.yAxisDisplayOptions()) && Objects.equals(legend(), other.legend())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(visualPalette(), other.visualPalette());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScatterPlotConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("XAxisLabelOptions", xAxisLabelOptions())
                .add("XAxisDisplayOptions", xAxisDisplayOptions()).add("YAxisLabelOptions", yAxisLabelOptions())
                .add("YAxisDisplayOptions", yAxisDisplayOptions()).add("Legend", legend()).add("DataLabels", dataLabels())
                .add("Tooltip", tooltip()).add("VisualPalette", visualPalette()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "XAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(xAxisLabelOptions()));
        case "XAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(xAxisDisplayOptions()));
        case "YAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(yAxisLabelOptions()));
        case "YAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(yAxisDisplayOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScatterPlotConfiguration, T> g) {
        return obj -> g.apply((ScatterPlotConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScatterPlotConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(ScatterPlotFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScatterPlotFieldWells.Builder} avoiding
         * the need to create one manually via {@link ScatterPlotFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScatterPlotFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(ScatterPlotFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link ScatterPlotFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(ScatterPlotFieldWells)
         */
        default Builder fieldWells(Consumer<ScatterPlotFieldWells.Builder> fieldWells) {
            return fieldWells(ScatterPlotFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a scatter plot.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(ScatterPlotSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScatterPlotSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link ScatterPlotSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScatterPlotSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(ScatterPlotSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link ScatterPlotSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(ScatterPlotSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<ScatterPlotSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(ScatterPlotSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's x-axis.
         * </p>
         * 
         * @param xAxisLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) of the scatter plot's
         *        x-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's x-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #xAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param xAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder xAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> xAxisLabelOptions) {
            return xAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(xAxisLabelOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, and axis step) of the scatter plot's x-axis.
         * </p>
         * 
         * @param xAxisDisplayOptions
         *        The label display options (grid line, range, scale, and axis step) of the scatter plot's x-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions);

        /**
         * <p>
         * The label display options (grid line, range, scale, and axis step) of the scatter plot's x-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #xAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param xAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder xAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> xAxisDisplayOptions) {
            return xAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(xAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's y-axis.
         * </p>
         * 
         * @param yAxisLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) of the scatter plot's
         *        y-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxisLabelOptions(ChartAxisLabelOptions yAxisLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's y-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #yAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param yAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder yAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> yAxisLabelOptions) {
            return yAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(yAxisLabelOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, and axis step) of the scatter plot's y-axis.
         * </p>
         * 
         * @param yAxisDisplayOptions
         *        The label display options (grid line, range, scale, and axis step) of the scatter plot's y-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxisDisplayOptions(AxisDisplayOptions yAxisDisplayOptions);

        /**
         * <p>
         * The label display options (grid line, range, scale, and axis step) of the scatter plot's y-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #yAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param yAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder yAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> yAxisDisplayOptions) {
            return yAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(yAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * 
         * @param dataLabels
         *        The options that determine if visual data labels are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * 
         * @param visualPalette
         *        The palette (chart color) display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScatterPlotFieldWells fieldWells;

        private ScatterPlotSortConfiguration sortConfiguration;

        private ChartAxisLabelOptions xAxisLabelOptions;

        private AxisDisplayOptions xAxisDisplayOptions;

        private ChartAxisLabelOptions yAxisLabelOptions;

        private AxisDisplayOptions yAxisDisplayOptions;

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltip;

        private VisualPalette visualPalette;

        private BuilderImpl() {
        }

        private BuilderImpl(ScatterPlotConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            xAxisLabelOptions(model.xAxisLabelOptions);
            xAxisDisplayOptions(model.xAxisDisplayOptions);
            yAxisLabelOptions(model.yAxisLabelOptions);
            yAxisDisplayOptions(model.yAxisDisplayOptions);
            legend(model.legend);
            dataLabels(model.dataLabels);
            tooltip(model.tooltip);
            visualPalette(model.visualPalette);
        }

        public final ScatterPlotFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(ScatterPlotFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(ScatterPlotFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final ScatterPlotSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(ScatterPlotSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(ScatterPlotSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getXAxisLabelOptions() {
            return xAxisLabelOptions != null ? xAxisLabelOptions.toBuilder() : null;
        }

        public final void setXAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions != null ? xAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getXAxisDisplayOptions() {
            return xAxisDisplayOptions != null ? xAxisDisplayOptions.toBuilder() : null;
        }

        public final void setXAxisDisplayOptions(AxisDisplayOptions.BuilderImpl xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions != null ? xAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getYAxisLabelOptions() {
            return yAxisLabelOptions != null ? yAxisLabelOptions.toBuilder() : null;
        }

        public final void setYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl yAxisLabelOptions) {
            this.yAxisLabelOptions = yAxisLabelOptions != null ? yAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder yAxisLabelOptions(ChartAxisLabelOptions yAxisLabelOptions) {
            this.yAxisLabelOptions = yAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getYAxisDisplayOptions() {
            return yAxisDisplayOptions != null ? yAxisDisplayOptions.toBuilder() : null;
        }

        public final void setYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl yAxisDisplayOptions) {
            this.yAxisDisplayOptions = yAxisDisplayOptions != null ? yAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder yAxisDisplayOptions(AxisDisplayOptions yAxisDisplayOptions) {
            this.yAxisDisplayOptions = yAxisDisplayOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        @Override
        public ScatterPlotConfiguration build() {
            return new ScatterPlotConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
