/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The navigation configuration for <code>CustomActionNavigationOperation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalNavigationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalNavigationConfiguration.Builder, LocalNavigationConfiguration> {
    private static final SdkField<String> TARGET_SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetSheetId").getter(getter(LocalNavigationConfiguration::targetSheetId))
            .setter(setter(Builder::targetSheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSheetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_SHEET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetSheetId;

    private LocalNavigationConfiguration(BuilderImpl builder) {
        this.targetSheetId = builder.targetSheetId;
    }

    /**
     * <p>
     * The sheet that is targeted for navigation in the same analysis.
     * </p>
     * 
     * @return The sheet that is targeted for navigation in the same analysis.
     */
    public final String targetSheetId() {
        return targetSheetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetSheetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalNavigationConfiguration)) {
            return false;
        }
        LocalNavigationConfiguration other = (LocalNavigationConfiguration) obj;
        return Objects.equals(targetSheetId(), other.targetSheetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocalNavigationConfiguration").add("TargetSheetId", targetSheetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetSheetId":
            return Optional.ofNullable(clazz.cast(targetSheetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalNavigationConfiguration, T> g) {
        return obj -> g.apply((LocalNavigationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalNavigationConfiguration> {
        /**
         * <p>
         * The sheet that is targeted for navigation in the same analysis.
         * </p>
         * 
         * @param targetSheetId
         *        The sheet that is targeted for navigation in the same analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSheetId(String targetSheetId);
    }

    static final class BuilderImpl implements Builder {
        private String targetSheetId;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalNavigationConfiguration model) {
            targetSheetId(model.targetSheetId);
        }

        public final String getTargetSheetId() {
            return targetSheetId;
        }

        public final void setTargetSheetId(String targetSheetId) {
            this.targetSheetId = targetSheetId;
        }

        @Override
        public final Builder targetSheetId(String targetSheetId) {
            this.targetSheetId = targetSheetId;
            return this;
        }

        @Override
        public LocalNavigationConfiguration build() {
            return new LocalNavigationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
