/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GaugeChartPrimaryValueConditionalFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<GaugeChartPrimaryValueConditionalFormatting.Builder, GaugeChartPrimaryValueConditionalFormatting> {
    private static final SdkField<ConditionalFormattingColor> TEXT_COLOR_FIELD = SdkField
            .<ConditionalFormattingColor> builder(MarshallingType.SDK_POJO).memberName("TextColor")
            .getter(getter(GaugeChartPrimaryValueConditionalFormatting::textColor)).setter(setter(Builder::textColor))
            .constructor(ConditionalFormattingColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()).build();

    private static final SdkField<ConditionalFormattingIcon> ICON_FIELD = SdkField
            .<ConditionalFormattingIcon> builder(MarshallingType.SDK_POJO).memberName("Icon")
            .getter(getter(GaugeChartPrimaryValueConditionalFormatting::icon)).setter(setter(Builder::icon))
            .constructor(ConditionalFormattingIcon::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_COLOR_FIELD, ICON_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConditionalFormattingColor textColor;

    private final ConditionalFormattingIcon icon;

    private GaugeChartPrimaryValueConditionalFormatting(BuilderImpl builder) {
        this.textColor = builder.textColor;
        this.icon = builder.icon;
    }

    /**
     * <p>
     * The conditional formatting of the primary value text color.
     * </p>
     * 
     * @return The conditional formatting of the primary value text color.
     */
    public final ConditionalFormattingColor textColor() {
        return textColor;
    }

    /**
     * <p>
     * The conditional formatting of the primary value icon.
     * </p>
     * 
     * @return The conditional formatting of the primary value icon.
     */
    public final ConditionalFormattingIcon icon() {
        return icon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textColor());
        hashCode = 31 * hashCode + Objects.hashCode(icon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartPrimaryValueConditionalFormatting)) {
            return false;
        }
        GaugeChartPrimaryValueConditionalFormatting other = (GaugeChartPrimaryValueConditionalFormatting) obj;
        return Objects.equals(textColor(), other.textColor()) && Objects.equals(icon(), other.icon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GaugeChartPrimaryValueConditionalFormatting").add("TextColor", textColor()).add("Icon", icon())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextColor":
            return Optional.ofNullable(clazz.cast(textColor()));
        case "Icon":
            return Optional.ofNullable(clazz.cast(icon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartPrimaryValueConditionalFormatting, T> g) {
        return obj -> g.apply((GaugeChartPrimaryValueConditionalFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GaugeChartPrimaryValueConditionalFormatting> {
        /**
         * <p>
         * The conditional formatting of the primary value text color.
         * </p>
         * 
         * @param textColor
         *        The conditional formatting of the primary value text color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textColor(ConditionalFormattingColor textColor);

        /**
         * <p>
         * The conditional formatting of the primary value text color.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingColor.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingColor.Builder#build()} is called immediately
         * and its result is passed to {@link #textColor(ConditionalFormattingColor)}.
         * 
         * @param textColor
         *        a consumer that will call methods on {@link ConditionalFormattingColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textColor(ConditionalFormattingColor)
         */
        default Builder textColor(Consumer<ConditionalFormattingColor.Builder> textColor) {
            return textColor(ConditionalFormattingColor.builder().applyMutation(textColor).build());
        }

        /**
         * <p>
         * The conditional formatting of the primary value icon.
         * </p>
         * 
         * @param icon
         *        The conditional formatting of the primary value icon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icon(ConditionalFormattingIcon icon);

        /**
         * <p>
         * The conditional formatting of the primary value icon.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingIcon.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingIcon#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingIcon.Builder#build()} is called immediately
         * and its result is passed to {@link #icon(ConditionalFormattingIcon)}.
         * 
         * @param icon
         *        a consumer that will call methods on {@link ConditionalFormattingIcon.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icon(ConditionalFormattingIcon)
         */
        default Builder icon(Consumer<ConditionalFormattingIcon.Builder> icon) {
            return icon(ConditionalFormattingIcon.builder().applyMutation(icon).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionalFormattingColor textColor;

        private ConditionalFormattingIcon icon;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartPrimaryValueConditionalFormatting model) {
            textColor(model.textColor);
            icon(model.icon);
        }

        public final ConditionalFormattingColor.Builder getTextColor() {
            return textColor != null ? textColor.toBuilder() : null;
        }

        public final void setTextColor(ConditionalFormattingColor.BuilderImpl textColor) {
            this.textColor = textColor != null ? textColor.build() : null;
        }

        @Override
        public final Builder textColor(ConditionalFormattingColor textColor) {
            this.textColor = textColor;
            return this;
        }

        public final ConditionalFormattingIcon.Builder getIcon() {
            return icon != null ? icon.toBuilder() : null;
        }

        public final void setIcon(ConditionalFormattingIcon.BuilderImpl icon) {
            this.icon = icon != null ? icon.build() : null;
        }

        @Override
        public final Builder icon(ConditionalFormattingIcon icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public GaugeChartPrimaryValueConditionalFormatting build() {
            return new GaugeChartPrimaryValueConditionalFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
