/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SheetElementConfigurationOverrides;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetElementRenderingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetElementRenderingRule> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(SheetElementRenderingRule.getter(SheetElementRenderingRule::expression)).setter(SheetElementRenderingRule.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<SheetElementConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationOverrides").getter(SheetElementRenderingRule.getter(SheetElementRenderingRule::configurationOverrides)).setter(SheetElementRenderingRule.setter(Builder::configurationOverrides)).constructor(SheetElementConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationOverrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, CONFIGURATION_OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final SheetElementConfigurationOverrides configurationOverrides;

    private SheetElementRenderingRule(BuilderImpl builder) {
        this.expression = builder.expression;
        this.configurationOverrides = builder.configurationOverrides;
    }

    public final String expression() {
        return this.expression;
    }

    public final SheetElementConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetElementRenderingRule)) {
            return false;
        }
        SheetElementRenderingRule other = (SheetElementRenderingRule)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"SheetElementRenderingRule").add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("ConfigurationOverrides", (Object)this.configurationOverrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "ConfigurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SheetElementRenderingRule, T> g) {
        return obj -> g.apply((SheetElementRenderingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private SheetElementConfigurationOverrides configurationOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetElementRenderingRule model) {
            this.expression(model.expression);
            this.configurationOverrides(model.configurationOverrides);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final SheetElementConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(SheetElementConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(SheetElementConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public SheetElementRenderingRule build() {
            return new SheetElementRenderingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetElementRenderingRule> {
        public Builder expression(String var1);

        public Builder configurationOverrides(SheetElementConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<SheetElementConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((SheetElementConfigurationOverrides)((SheetElementConfigurationOverrides.Builder)SheetElementConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }
    }
}

