/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field sort options for a pivot table sort configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotFieldSortOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotFieldSortOptions.Builder, PivotFieldSortOptions> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(PivotFieldSortOptions::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<PivotTableSortBy> SORT_BY_FIELD = SdkField.<PivotTableSortBy> builder(MarshallingType.SDK_POJO)
            .memberName("SortBy").getter(getter(PivotFieldSortOptions::sortBy)).setter(setter(Builder::sortBy))
            .constructor(PivotTableSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FIELD_ID_FIELD, SORT_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final PivotTableSortBy sortBy;

    private PivotFieldSortOptions(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The field ID for the field sort options.
     * </p>
     * 
     * @return The field ID for the field sort options.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The sort by field for the field sort options.
     * </p>
     * 
     * @return The sort by field for the field sort options.
     */
    public final PivotTableSortBy sortBy() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotFieldSortOptions)) {
            return false;
        }
        PivotFieldSortOptions other = (PivotFieldSortOptions) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(sortBy(), other.sortBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotFieldSortOptions").add("FieldId", fieldId()).add("SortBy", sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotFieldSortOptions, T> g) {
        return obj -> g.apply((PivotFieldSortOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotFieldSortOptions> {
        /**
         * <p>
         * The field ID for the field sort options.
         * </p>
         * 
         * @param fieldId
         *        The field ID for the field sort options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The sort by field for the field sort options.
         * </p>
         * 
         * @param sortBy
         *        The sort by field for the field sort options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(PivotTableSortBy sortBy);

        /**
         * <p>
         * The sort by field for the field sort options.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableSortBy.Builder} avoiding the
         * need to create one manually via {@link PivotTableSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableSortBy.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(PivotTableSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link PivotTableSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(PivotTableSortBy)
         */
        default Builder sortBy(Consumer<PivotTableSortBy.Builder> sortBy) {
            return sortBy(PivotTableSortBy.builder().applyMutation(sortBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private PivotTableSortBy sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotFieldSortOptions model) {
            fieldId(model.fieldId);
            sortBy(model.sortBy);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final PivotTableSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(PivotTableSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(PivotTableSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public PivotFieldSortOptions build() {
            return new PivotFieldSortOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
