/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for a paper canvas of a section-based layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionBasedLayoutPaperCanvasSizeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SectionBasedLayoutPaperCanvasSizeOptions.Builder, SectionBasedLayoutPaperCanvasSizeOptions> {
    private static final SdkField<String> PAPER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaperSize").getter(getter(SectionBasedLayoutPaperCanvasSizeOptions::paperSizeAsString))
            .setter(setter(Builder::paperSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperSize").build()).build();

    private static final SdkField<String> PAPER_ORIENTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaperOrientation").getter(getter(SectionBasedLayoutPaperCanvasSizeOptions::paperOrientationAsString))
            .setter(setter(Builder::paperOrientation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperOrientation").build()).build();

    private static final SdkField<Spacing> PAPER_MARGIN_FIELD = SdkField.<Spacing> builder(MarshallingType.SDK_POJO)
            .memberName("PaperMargin").getter(getter(SectionBasedLayoutPaperCanvasSizeOptions::paperMargin))
            .setter(setter(Builder::paperMargin)).constructor(Spacing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperMargin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAPER_SIZE_FIELD,
            PAPER_ORIENTATION_FIELD, PAPER_MARGIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String paperSize;

    private final String paperOrientation;

    private final Spacing paperMargin;

    private SectionBasedLayoutPaperCanvasSizeOptions(BuilderImpl builder) {
        this.paperSize = builder.paperSize;
        this.paperOrientation = builder.paperOrientation;
        this.paperMargin = builder.paperMargin;
    }

    /**
     * <p>
     * The paper size that is used to define canvas dimensions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paperSize} will
     * return {@link PaperSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paperSizeAsString}.
     * </p>
     * 
     * @return The paper size that is used to define canvas dimensions.
     * @see PaperSize
     */
    public final PaperSize paperSize() {
        return PaperSize.fromValue(paperSize);
    }

    /**
     * <p>
     * The paper size that is used to define canvas dimensions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paperSize} will
     * return {@link PaperSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paperSizeAsString}.
     * </p>
     * 
     * @return The paper size that is used to define canvas dimensions.
     * @see PaperSize
     */
    public final String paperSizeAsString() {
        return paperSize;
    }

    /**
     * <p>
     * The paper orientation that is used to define canvas dimensions. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PORTRAIT
     * </p>
     * </li>
     * <li>
     * <p>
     * LANDSCAPE
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paperOrientation}
     * will return {@link PaperOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #paperOrientationAsString}.
     * </p>
     * 
     * @return The paper orientation that is used to define canvas dimensions. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PORTRAIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LANDSCAPE
     *         </p>
     *         </li>
     * @see PaperOrientation
     */
    public final PaperOrientation paperOrientation() {
        return PaperOrientation.fromValue(paperOrientation);
    }

    /**
     * <p>
     * The paper orientation that is used to define canvas dimensions. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PORTRAIT
     * </p>
     * </li>
     * <li>
     * <p>
     * LANDSCAPE
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paperOrientation}
     * will return {@link PaperOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #paperOrientationAsString}.
     * </p>
     * 
     * @return The paper orientation that is used to define canvas dimensions. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PORTRAIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LANDSCAPE
     *         </p>
     *         </li>
     * @see PaperOrientation
     */
    public final String paperOrientationAsString() {
        return paperOrientation;
    }

    /**
     * <p>
     * Defines the spacing between the canvas content and the top, bottom, left, and right edges.
     * </p>
     * 
     * @return Defines the spacing between the canvas content and the top, bottom, left, and right edges.
     */
    public final Spacing paperMargin() {
        return paperMargin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(paperSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paperOrientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paperMargin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionBasedLayoutPaperCanvasSizeOptions)) {
            return false;
        }
        SectionBasedLayoutPaperCanvasSizeOptions other = (SectionBasedLayoutPaperCanvasSizeOptions) obj;
        return Objects.equals(paperSizeAsString(), other.paperSizeAsString())
                && Objects.equals(paperOrientationAsString(), other.paperOrientationAsString())
                && Objects.equals(paperMargin(), other.paperMargin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionBasedLayoutPaperCanvasSizeOptions").add("PaperSize", paperSizeAsString())
                .add("PaperOrientation", paperOrientationAsString()).add("PaperMargin", paperMargin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PaperSize":
            return Optional.ofNullable(clazz.cast(paperSizeAsString()));
        case "PaperOrientation":
            return Optional.ofNullable(clazz.cast(paperOrientationAsString()));
        case "PaperMargin":
            return Optional.ofNullable(clazz.cast(paperMargin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SectionBasedLayoutPaperCanvasSizeOptions, T> g) {
        return obj -> g.apply((SectionBasedLayoutPaperCanvasSizeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionBasedLayoutPaperCanvasSizeOptions> {
        /**
         * <p>
         * The paper size that is used to define canvas dimensions.
         * </p>
         * 
         * @param paperSize
         *        The paper size that is used to define canvas dimensions.
         * @see PaperSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaperSize
         */
        Builder paperSize(String paperSize);

        /**
         * <p>
         * The paper size that is used to define canvas dimensions.
         * </p>
         * 
         * @param paperSize
         *        The paper size that is used to define canvas dimensions.
         * @see PaperSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaperSize
         */
        Builder paperSize(PaperSize paperSize);

        /**
         * <p>
         * The paper orientation that is used to define canvas dimensions. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PORTRAIT
         * </p>
         * </li>
         * <li>
         * <p>
         * LANDSCAPE
         * </p>
         * </li>
         * </ul>
         * 
         * @param paperOrientation
         *        The paper orientation that is used to define canvas dimensions. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PORTRAIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LANDSCAPE
         *        </p>
         *        </li>
         * @see PaperOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaperOrientation
         */
        Builder paperOrientation(String paperOrientation);

        /**
         * <p>
         * The paper orientation that is used to define canvas dimensions. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PORTRAIT
         * </p>
         * </li>
         * <li>
         * <p>
         * LANDSCAPE
         * </p>
         * </li>
         * </ul>
         * 
         * @param paperOrientation
         *        The paper orientation that is used to define canvas dimensions. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PORTRAIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LANDSCAPE
         *        </p>
         *        </li>
         * @see PaperOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaperOrientation
         */
        Builder paperOrientation(PaperOrientation paperOrientation);

        /**
         * <p>
         * Defines the spacing between the canvas content and the top, bottom, left, and right edges.
         * </p>
         * 
         * @param paperMargin
         *        Defines the spacing between the canvas content and the top, bottom, left, and right edges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paperMargin(Spacing paperMargin);

        /**
         * <p>
         * Defines the spacing between the canvas content and the top, bottom, left, and right edges.
         * </p>
         * This is a convenience method that creates an instance of the {@link Spacing.Builder} avoiding the need to
         * create one manually via {@link Spacing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Spacing.Builder#build()} is called immediately and its result is
         * passed to {@link #paperMargin(Spacing)}.
         * 
         * @param paperMargin
         *        a consumer that will call methods on {@link Spacing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paperMargin(Spacing)
         */
        default Builder paperMargin(Consumer<Spacing.Builder> paperMargin) {
            return paperMargin(Spacing.builder().applyMutation(paperMargin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String paperSize;

        private String paperOrientation;

        private Spacing paperMargin;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionBasedLayoutPaperCanvasSizeOptions model) {
            paperSize(model.paperSize);
            paperOrientation(model.paperOrientation);
            paperMargin(model.paperMargin);
        }

        public final String getPaperSize() {
            return paperSize;
        }

        public final void setPaperSize(String paperSize) {
            this.paperSize = paperSize;
        }

        @Override
        public final Builder paperSize(String paperSize) {
            this.paperSize = paperSize;
            return this;
        }

        @Override
        public final Builder paperSize(PaperSize paperSize) {
            this.paperSize(paperSize == null ? null : paperSize.toString());
            return this;
        }

        public final String getPaperOrientation() {
            return paperOrientation;
        }

        public final void setPaperOrientation(String paperOrientation) {
            this.paperOrientation = paperOrientation;
        }

        @Override
        public final Builder paperOrientation(String paperOrientation) {
            this.paperOrientation = paperOrientation;
            return this;
        }

        @Override
        public final Builder paperOrientation(PaperOrientation paperOrientation) {
            this.paperOrientation(paperOrientation == null ? null : paperOrientation.toString());
            return this;
        }

        public final Spacing.Builder getPaperMargin() {
            return paperMargin != null ? paperMargin.toBuilder() : null;
        }

        public final void setPaperMargin(Spacing.BuilderImpl paperMargin) {
            this.paperMargin = paperMargin != null ? paperMargin.build() : null;
        }

        @Override
        public final Builder paperMargin(Spacing paperMargin) {
            this.paperMargin = paperMargin;
            return this;
        }

        @Override
        public SectionBasedLayoutPaperCanvasSizeOptions build() {
            return new SectionBasedLayoutPaperCanvasSizeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
