/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTemplateDefinitionResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeTemplateDefinitionResponse.Builder, DescribeTemplateDefinitionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeTemplateDefinitionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(DescribeTemplateDefinitionResponse::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<List<TemplateError>> ERRORS_FIELD = SdkField
            .<List<TemplateError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DescribeTemplateDefinitionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateError> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(DescribeTemplateDefinitionResponse::resourceStatusAsString))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(DescribeTemplateDefinitionResponse::themeArn))
            .setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final SdkField<TemplateVersionDefinition> DEFINITION_FIELD = SdkField
            .<TemplateVersionDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(DescribeTemplateDefinitionResponse::definition)).setter(setter(Builder::definition))
            .constructor(TemplateVersionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeTemplateDefinitionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeTemplateDefinitionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TEMPLATE_ID_FIELD,
            ERRORS_FIELD, RESOURCE_STATUS_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final String name;

    private final String templateId;

    private final List<TemplateError> errors;

    private final String resourceStatus;

    private final String themeArn;

    private final TemplateVersionDefinition definition;

    private final Integer status;

    private final String requestId;

    private DescribeTemplateDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.templateId = builder.templateId;
        this.errors = builder.errors;
        this.resourceStatus = builder.resourceStatus;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The descriptive name of the template.
     * </p>
     * 
     * @return The descriptive name of the template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the template described.
     * </p>
     * 
     * @return The ID of the template described.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with the template version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Errors associated with the template version.
     */
    public final List<TemplateError> errors() {
        return errors;
    }

    /**
     * <p>
     * Status associated with the template.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Status associated with the template.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     * @see ResourceStatus
     */
    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Status associated with the template.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Status associated with the template.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code>
     *         </p>
     *         </li>
     * @see ResourceStatus
     */
    public final String resourceStatusAsString() {
        return resourceStatus;
    }

    /**
     * <p>
     * The ARN of the theme of the template.
     * </p>
     * 
     * @return The ARN of the theme of the template.
     */
    public final String themeArn() {
        return themeArn;
    }

    /**
     * <p>
     * The definition of the template.
     * </p>
     * <p>
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     * </p>
     * 
     * @return The definition of the template.</p>
     *         <p>
     *         A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public final TemplateVersionDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTemplateDefinitionResponse)) {
            return false;
        }
        DescribeTemplateDefinitionResponse other = (DescribeTemplateDefinitionResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(templateId(), other.templateId())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(resourceStatusAsString(), other.resourceStatusAsString())
                && Objects.equals(themeArn(), other.themeArn()) && Objects.equals(definition(), other.definition())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTemplateDefinitionResponse").add("Name", name()).add("TemplateId", templateId())
                .add("Errors", hasErrors() ? errors() : null).add("ResourceStatus", resourceStatusAsString())
                .add("ThemeArn", themeArn()).add("Definition", definition()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatusAsString()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTemplateDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeTemplateDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTemplateDefinitionResponse> {
        /**
         * <p>
         * The descriptive name of the template.
         * </p>
         * 
         * @param name
         *        The descriptive name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the template described.
         * </p>
         * 
         * @param templateId
         *        The ID of the template described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * Errors associated with the template version.
         * </p>
         * 
         * @param errors
         *        Errors associated with the template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<TemplateError> errors);

        /**
         * <p>
         * Errors associated with the template version.
         * </p>
         * 
         * @param errors
         *        Errors associated with the template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(TemplateError... errors);

        /**
         * <p>
         * Errors associated with the template version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TemplateError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TemplateError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TemplateError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<TemplateError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TemplateError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<TemplateError>)
         */
        Builder errors(Consumer<TemplateError.Builder>... errors);

        /**
         * <p>
         * Status associated with the template.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceStatus
         *        Status associated with the template.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Status associated with the template.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceStatus
         *        Status associated with the template.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code>
         *        </p>
         *        </li>
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * The ARN of the theme of the template.
         * </p>
         * 
         * @param themeArn
         *        The ARN of the theme of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        /**
         * <p>
         * The definition of the template.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * 
         * @param definition
         *        The definition of the template.</p>
         *        <p>
         *        A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(TemplateVersionDefinition definition);

        /**
         * <p>
         * The definition of the template.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateVersionDefinition.Builder}
         * avoiding the need to create one manually via {@link TemplateVersionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateVersionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(TemplateVersionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link TemplateVersionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(TemplateVersionDefinition)
         */
        default Builder definition(Consumer<TemplateVersionDefinition.Builder> definition) {
            return definition(TemplateVersionDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String name;

        private String templateId;

        private List<TemplateError> errors = DefaultSdkAutoConstructList.getInstance();

        private String resourceStatus;

        private String themeArn;

        private TemplateVersionDefinition definition;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTemplateDefinitionResponse model) {
            super(model);
            name(model.name);
            templateId(model.templateId);
            errors(model.errors);
            resourceStatus(model.resourceStatus);
            themeArn(model.themeArn);
            definition(model.definition);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final List<TemplateError.Builder> getErrors() {
            List<TemplateError.Builder> result = TemplateErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<TemplateError.BuilderImpl> errors) {
            this.errors = TemplateErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<TemplateError> errors) {
            this.errors = TemplateErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(TemplateError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<TemplateError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> TemplateError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final TemplateVersionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeTemplateDefinitionResponse build() {
            return new DescribeTemplateDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
