/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobSummary;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsResponse;

public class ListAssetBundleImportJobsIterable
implements SdkIterable<ListAssetBundleImportJobsResponse> {
    private final QuickSightClient client;
    private final ListAssetBundleImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetBundleImportJobsIterable(QuickSightClient client, ListAssetBundleImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetBundleImportJobsResponseFetcher();
    }

    public Iterator<ListAssetBundleImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetBundleImportJobSummary> assetBundleImportJobSummaryList() {
        Function<ListAssetBundleImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetBundleImportJobSummaryList() != null) {
                return response.assetBundleImportJobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetBundleImportJobsResponseFetcher
    implements SyncPageFetcher<ListAssetBundleImportJobsResponse> {
        private ListAssetBundleImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetBundleImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetBundleImportJobsResponse nextPage(ListAssetBundleImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetBundleImportJobsIterable.this.client.listAssetBundleImportJobs(ListAssetBundleImportJobsIterable.this.firstRequest);
            }
            return ListAssetBundleImportJobsIterable.this.client.listAssetBundleImportJobs((ListAssetBundleImportJobsRequest)((Object)ListAssetBundleImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

