/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AuthorSpecifiedAggregation;
import software.amazon.awssdk.services.quicksight.model.AuthorSpecifiedAggregationsCopier;
import software.amazon.awssdk.services.quicksight.model.CellValueSynonym;
import software.amazon.awssdk.services.quicksight.model.CellValueSynonymsCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnDataRole;
import software.amazon.awssdk.services.quicksight.model.ComparativeOrder;
import software.amazon.awssdk.services.quicksight.model.DefaultAggregation;
import software.amazon.awssdk.services.quicksight.model.DefaultFormatting;
import software.amazon.awssdk.services.quicksight.model.SemanticType;
import software.amazon.awssdk.services.quicksight.model.SynonymsCopier;
import software.amazon.awssdk.services.quicksight.model.TopicTimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicCalculatedField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicCalculatedField> {
    private static final SdkField<String> CALCULATED_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedFieldName").getter(TopicCalculatedField.getter(TopicCalculatedField::calculatedFieldName)).setter(TopicCalculatedField.setter(Builder::calculatedFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldName").build()}).build();
    private static final SdkField<String> CALCULATED_FIELD_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedFieldDescription").getter(TopicCalculatedField.getter(TopicCalculatedField::calculatedFieldDescription)).setter(TopicCalculatedField.setter(Builder::calculatedFieldDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldDescription").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(TopicCalculatedField.getter(TopicCalculatedField::expression)).setter(TopicCalculatedField.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<List<String>> CALCULATED_FIELD_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalculatedFieldSynonyms").getter(TopicCalculatedField.getter(TopicCalculatedField::calculatedFieldSynonyms)).setter(TopicCalculatedField.setter(Builder::calculatedFieldSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_INCLUDED_IN_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsIncludedInTopic").getter(TopicCalculatedField.getter(TopicCalculatedField::isIncludedInTopic)).setter(TopicCalculatedField.setter(Builder::isIncludedInTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIncludedInTopic").build()}).build();
    private static final SdkField<Boolean> DISABLE_INDEXING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableIndexing").getter(TopicCalculatedField.getter(TopicCalculatedField::disableIndexing)).setter(TopicCalculatedField.setter(Builder::disableIndexing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableIndexing").build()}).build();
    private static final SdkField<String> COLUMN_DATA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnDataRole").getter(TopicCalculatedField.getter(TopicCalculatedField::columnDataRoleAsString)).setter(TopicCalculatedField.setter(Builder::columnDataRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDataRole").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TopicCalculatedField.getter(TopicCalculatedField::timeGranularityAsString)).setter(TopicCalculatedField.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<DefaultFormatting> DEFAULT_FORMATTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultFormatting").getter(TopicCalculatedField.getter(TopicCalculatedField::defaultFormatting)).setter(TopicCalculatedField.setter(Builder::defaultFormatting)).constructor(DefaultFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFormatting").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(TopicCalculatedField.getter(TopicCalculatedField::aggregationAsString)).setter(TopicCalculatedField.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final SdkField<ComparativeOrder> COMPARATIVE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComparativeOrder").getter(TopicCalculatedField.getter(TopicCalculatedField::comparativeOrder)).setter(TopicCalculatedField.setter(Builder::comparativeOrder)).constructor(ComparativeOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparativeOrder").build()}).build();
    private static final SdkField<SemanticType> SEMANTIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SemanticType").getter(TopicCalculatedField.getter(TopicCalculatedField::semanticType)).setter(TopicCalculatedField.setter(Builder::semanticType)).constructor(SemanticType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticType").build()}).build();
    private static final SdkField<List<String>> ALLOWED_AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedAggregations").getter(TopicCalculatedField.getter(TopicCalculatedField::allowedAggregationsAsStrings)).setter(TopicCalculatedField.setter(Builder::allowedAggregationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_ALLOWED_AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotAllowedAggregations").getter(TopicCalculatedField.getter(TopicCalculatedField::notAllowedAggregationsAsStrings)).setter(TopicCalculatedField.setter(Builder::notAllowedAggregationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAllowedAggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEVER_AGGREGATE_IN_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NeverAggregateInFilter").getter(TopicCalculatedField.getter(TopicCalculatedField::neverAggregateInFilter)).setter(TopicCalculatedField.setter(Builder::neverAggregateInFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverAggregateInFilter").build()}).build();
    private static final SdkField<List<CellValueSynonym>> CELL_VALUE_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CellValueSynonyms").getter(TopicCalculatedField.getter(TopicCalculatedField::cellValueSynonyms)).setter(TopicCalculatedField.setter(Builder::cellValueSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellValueSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CellValueSynonym::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NON_ADDITIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NonAdditive").getter(TopicCalculatedField.getter(TopicCalculatedField::nonAdditive)).setter(TopicCalculatedField.setter(Builder::nonAdditive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAdditive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATED_FIELD_NAME_FIELD, CALCULATED_FIELD_DESCRIPTION_FIELD, EXPRESSION_FIELD, CALCULATED_FIELD_SYNONYMS_FIELD, IS_INCLUDED_IN_TOPIC_FIELD, DISABLE_INDEXING_FIELD, COLUMN_DATA_ROLE_FIELD, TIME_GRANULARITY_FIELD, DEFAULT_FORMATTING_FIELD, AGGREGATION_FIELD, COMPARATIVE_ORDER_FIELD, SEMANTIC_TYPE_FIELD, ALLOWED_AGGREGATIONS_FIELD, NOT_ALLOWED_AGGREGATIONS_FIELD, NEVER_AGGREGATE_IN_FILTER_FIELD, CELL_VALUE_SYNONYMS_FIELD, NON_ADDITIVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String calculatedFieldName;
    private final String calculatedFieldDescription;
    private final String expression;
    private final List<String> calculatedFieldSynonyms;
    private final Boolean isIncludedInTopic;
    private final Boolean disableIndexing;
    private final String columnDataRole;
    private final String timeGranularity;
    private final DefaultFormatting defaultFormatting;
    private final String aggregation;
    private final ComparativeOrder comparativeOrder;
    private final SemanticType semanticType;
    private final List<String> allowedAggregations;
    private final List<String> notAllowedAggregations;
    private final Boolean neverAggregateInFilter;
    private final List<CellValueSynonym> cellValueSynonyms;
    private final Boolean nonAdditive;

    private TopicCalculatedField(BuilderImpl builder) {
        this.calculatedFieldName = builder.calculatedFieldName;
        this.calculatedFieldDescription = builder.calculatedFieldDescription;
        this.expression = builder.expression;
        this.calculatedFieldSynonyms = builder.calculatedFieldSynonyms;
        this.isIncludedInTopic = builder.isIncludedInTopic;
        this.disableIndexing = builder.disableIndexing;
        this.columnDataRole = builder.columnDataRole;
        this.timeGranularity = builder.timeGranularity;
        this.defaultFormatting = builder.defaultFormatting;
        this.aggregation = builder.aggregation;
        this.comparativeOrder = builder.comparativeOrder;
        this.semanticType = builder.semanticType;
        this.allowedAggregations = builder.allowedAggregations;
        this.notAllowedAggregations = builder.notAllowedAggregations;
        this.neverAggregateInFilter = builder.neverAggregateInFilter;
        this.cellValueSynonyms = builder.cellValueSynonyms;
        this.nonAdditive = builder.nonAdditive;
    }

    public final String calculatedFieldName() {
        return this.calculatedFieldName;
    }

    public final String calculatedFieldDescription() {
        return this.calculatedFieldDescription;
    }

    public final String expression() {
        return this.expression;
    }

    public final boolean hasCalculatedFieldSynonyms() {
        return this.calculatedFieldSynonyms != null && !(this.calculatedFieldSynonyms instanceof SdkAutoConstructList);
    }

    public final List<String> calculatedFieldSynonyms() {
        return this.calculatedFieldSynonyms;
    }

    public final Boolean isIncludedInTopic() {
        return this.isIncludedInTopic;
    }

    public final Boolean disableIndexing() {
        return this.disableIndexing;
    }

    public final ColumnDataRole columnDataRole() {
        return ColumnDataRole.fromValue(this.columnDataRole);
    }

    public final String columnDataRoleAsString() {
        return this.columnDataRole;
    }

    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final DefaultFormatting defaultFormatting() {
        return this.defaultFormatting;
    }

    public final DefaultAggregation aggregation() {
        return DefaultAggregation.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final ComparativeOrder comparativeOrder() {
        return this.comparativeOrder;
    }

    public final SemanticType semanticType() {
        return this.semanticType;
    }

    public final List<AuthorSpecifiedAggregation> allowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(this.allowedAggregations);
    }

    public final boolean hasAllowedAggregations() {
        return this.allowedAggregations != null && !(this.allowedAggregations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAggregationsAsStrings() {
        return this.allowedAggregations;
    }

    public final List<AuthorSpecifiedAggregation> notAllowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(this.notAllowedAggregations);
    }

    public final boolean hasNotAllowedAggregations() {
        return this.notAllowedAggregations != null && !(this.notAllowedAggregations instanceof SdkAutoConstructList);
    }

    public final List<String> notAllowedAggregationsAsStrings() {
        return this.notAllowedAggregations;
    }

    public final Boolean neverAggregateInFilter() {
        return this.neverAggregateInFilter;
    }

    public final boolean hasCellValueSynonyms() {
        return this.cellValueSynonyms != null && !(this.cellValueSynonyms instanceof SdkAutoConstructList);
    }

    public final List<CellValueSynonym> cellValueSynonyms() {
        return this.cellValueSynonyms;
    }

    public final Boolean nonAdditive() {
        return this.nonAdditive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedFieldDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedFieldSynonyms() ? this.calculatedFieldSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isIncludedInTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableIndexing());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnDataRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFormatting());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparativeOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAggregations() ? this.allowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotAllowedAggregations() ? this.notAllowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.neverAggregateInFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellValueSynonyms() ? this.cellValueSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nonAdditive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicCalculatedField)) {
            return false;
        }
        TopicCalculatedField other = (TopicCalculatedField)obj;
        return Objects.equals(this.calculatedFieldName(), other.calculatedFieldName()) && Objects.equals(this.calculatedFieldDescription(), other.calculatedFieldDescription()) && Objects.equals(this.expression(), other.expression()) && this.hasCalculatedFieldSynonyms() == other.hasCalculatedFieldSynonyms() && Objects.equals(this.calculatedFieldSynonyms(), other.calculatedFieldSynonyms()) && Objects.equals(this.isIncludedInTopic(), other.isIncludedInTopic()) && Objects.equals(this.disableIndexing(), other.disableIndexing()) && Objects.equals(this.columnDataRoleAsString(), other.columnDataRoleAsString()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.defaultFormatting(), other.defaultFormatting()) && Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && Objects.equals(this.comparativeOrder(), other.comparativeOrder()) && Objects.equals(this.semanticType(), other.semanticType()) && this.hasAllowedAggregations() == other.hasAllowedAggregations() && Objects.equals(this.allowedAggregationsAsStrings(), other.allowedAggregationsAsStrings()) && this.hasNotAllowedAggregations() == other.hasNotAllowedAggregations() && Objects.equals(this.notAllowedAggregationsAsStrings(), other.notAllowedAggregationsAsStrings()) && Objects.equals(this.neverAggregateInFilter(), other.neverAggregateInFilter()) && this.hasCellValueSynonyms() == other.hasCellValueSynonyms() && Objects.equals(this.cellValueSynonyms(), other.cellValueSynonyms()) && Objects.equals(this.nonAdditive(), other.nonAdditive());
    }

    public final String toString() {
        return ToString.builder((String)"TopicCalculatedField").add("CalculatedFieldName", (Object)this.calculatedFieldName()).add("CalculatedFieldDescription", (Object)this.calculatedFieldDescription()).add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("CalculatedFieldSynonyms", this.hasCalculatedFieldSynonyms() ? this.calculatedFieldSynonyms() : null).add("IsIncludedInTopic", (Object)this.isIncludedInTopic()).add("DisableIndexing", (Object)this.disableIndexing()).add("ColumnDataRole", (Object)this.columnDataRoleAsString()).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("DefaultFormatting", (Object)this.defaultFormatting()).add("Aggregation", (Object)this.aggregationAsString()).add("ComparativeOrder", (Object)this.comparativeOrder()).add("SemanticType", (Object)this.semanticType()).add("AllowedAggregations", this.hasAllowedAggregations() ? this.allowedAggregationsAsStrings() : null).add("NotAllowedAggregations", this.hasNotAllowedAggregations() ? this.notAllowedAggregationsAsStrings() : null).add("NeverAggregateInFilter", (Object)this.neverAggregateInFilter()).add("CellValueSynonyms", this.hasCellValueSynonyms() ? this.cellValueSynonyms() : null).add("NonAdditive", (Object)this.nonAdditive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatedFieldName": {
                return Optional.ofNullable(clazz.cast(this.calculatedFieldName()));
            }
            case "CalculatedFieldDescription": {
                return Optional.ofNullable(clazz.cast(this.calculatedFieldDescription()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "CalculatedFieldSynonyms": {
                return Optional.ofNullable(clazz.cast(this.calculatedFieldSynonyms()));
            }
            case "IsIncludedInTopic": {
                return Optional.ofNullable(clazz.cast(this.isIncludedInTopic()));
            }
            case "DisableIndexing": {
                return Optional.ofNullable(clazz.cast(this.disableIndexing()));
            }
            case "ColumnDataRole": {
                return Optional.ofNullable(clazz.cast(this.columnDataRoleAsString()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "DefaultFormatting": {
                return Optional.ofNullable(clazz.cast(this.defaultFormatting()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "ComparativeOrder": {
                return Optional.ofNullable(clazz.cast(this.comparativeOrder()));
            }
            case "SemanticType": {
                return Optional.ofNullable(clazz.cast(this.semanticType()));
            }
            case "AllowedAggregations": {
                return Optional.ofNullable(clazz.cast(this.allowedAggregationsAsStrings()));
            }
            case "NotAllowedAggregations": {
                return Optional.ofNullable(clazz.cast(this.notAllowedAggregationsAsStrings()));
            }
            case "NeverAggregateInFilter": {
                return Optional.ofNullable(clazz.cast(this.neverAggregateInFilter()));
            }
            case "CellValueSynonyms": {
                return Optional.ofNullable(clazz.cast(this.cellValueSynonyms()));
            }
            case "NonAdditive": {
                return Optional.ofNullable(clazz.cast(this.nonAdditive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicCalculatedField, T> g) {
        return obj -> g.apply((TopicCalculatedField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String calculatedFieldName;
        private String calculatedFieldDescription;
        private String expression;
        private List<String> calculatedFieldSynonyms = DefaultSdkAutoConstructList.getInstance();
        private Boolean isIncludedInTopic;
        private Boolean disableIndexing;
        private String columnDataRole;
        private String timeGranularity;
        private DefaultFormatting defaultFormatting;
        private String aggregation;
        private ComparativeOrder comparativeOrder;
        private SemanticType semanticType;
        private List<String> allowedAggregations = DefaultSdkAutoConstructList.getInstance();
        private List<String> notAllowedAggregations = DefaultSdkAutoConstructList.getInstance();
        private Boolean neverAggregateInFilter;
        private List<CellValueSynonym> cellValueSynonyms = DefaultSdkAutoConstructList.getInstance();
        private Boolean nonAdditive;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicCalculatedField model) {
            this.calculatedFieldName(model.calculatedFieldName);
            this.calculatedFieldDescription(model.calculatedFieldDescription);
            this.expression(model.expression);
            this.calculatedFieldSynonyms(model.calculatedFieldSynonyms);
            this.isIncludedInTopic(model.isIncludedInTopic);
            this.disableIndexing(model.disableIndexing);
            this.columnDataRole(model.columnDataRole);
            this.timeGranularity(model.timeGranularity);
            this.defaultFormatting(model.defaultFormatting);
            this.aggregation(model.aggregation);
            this.comparativeOrder(model.comparativeOrder);
            this.semanticType(model.semanticType);
            this.allowedAggregationsWithStrings(model.allowedAggregations);
            this.notAllowedAggregationsWithStrings(model.notAllowedAggregations);
            this.neverAggregateInFilter(model.neverAggregateInFilter);
            this.cellValueSynonyms(model.cellValueSynonyms);
            this.nonAdditive(model.nonAdditive);
        }

        public final String getCalculatedFieldName() {
            return this.calculatedFieldName;
        }

        public final void setCalculatedFieldName(String calculatedFieldName) {
            this.calculatedFieldName = calculatedFieldName;
        }

        @Override
        public final Builder calculatedFieldName(String calculatedFieldName) {
            this.calculatedFieldName = calculatedFieldName;
            return this;
        }

        public final String getCalculatedFieldDescription() {
            return this.calculatedFieldDescription;
        }

        public final void setCalculatedFieldDescription(String calculatedFieldDescription) {
            this.calculatedFieldDescription = calculatedFieldDescription;
        }

        @Override
        public final Builder calculatedFieldDescription(String calculatedFieldDescription) {
            this.calculatedFieldDescription = calculatedFieldDescription;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Collection<String> getCalculatedFieldSynonyms() {
            if (this.calculatedFieldSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.calculatedFieldSynonyms;
        }

        public final void setCalculatedFieldSynonyms(Collection<String> calculatedFieldSynonyms) {
            this.calculatedFieldSynonyms = SynonymsCopier.copy(calculatedFieldSynonyms);
        }

        @Override
        public final Builder calculatedFieldSynonyms(Collection<String> calculatedFieldSynonyms) {
            this.calculatedFieldSynonyms = SynonymsCopier.copy(calculatedFieldSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFieldSynonyms(String ... calculatedFieldSynonyms) {
            this.calculatedFieldSynonyms(Arrays.asList(calculatedFieldSynonyms));
            return this;
        }

        public final Boolean getIsIncludedInTopic() {
            return this.isIncludedInTopic;
        }

        public final void setIsIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
        }

        @Override
        public final Builder isIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
            return this;
        }

        public final Boolean getDisableIndexing() {
            return this.disableIndexing;
        }

        public final void setDisableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
        }

        @Override
        public final Builder disableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
            return this;
        }

        public final String getColumnDataRole() {
            return this.columnDataRole;
        }

        public final void setColumnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
        }

        @Override
        public final Builder columnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
            return this;
        }

        @Override
        public final Builder columnDataRole(ColumnDataRole columnDataRole) {
            this.columnDataRole(columnDataRole == null ? null : columnDataRole.toString());
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final DefaultFormatting.Builder getDefaultFormatting() {
            return this.defaultFormatting != null ? this.defaultFormatting.toBuilder() : null;
        }

        public final void setDefaultFormatting(DefaultFormatting.BuilderImpl defaultFormatting) {
            this.defaultFormatting = defaultFormatting != null ? defaultFormatting.build() : null;
        }

        @Override
        public final Builder defaultFormatting(DefaultFormatting defaultFormatting) {
            this.defaultFormatting = defaultFormatting;
            return this;
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(DefaultAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final ComparativeOrder.Builder getComparativeOrder() {
            return this.comparativeOrder != null ? this.comparativeOrder.toBuilder() : null;
        }

        public final void setComparativeOrder(ComparativeOrder.BuilderImpl comparativeOrder) {
            this.comparativeOrder = comparativeOrder != null ? comparativeOrder.build() : null;
        }

        @Override
        public final Builder comparativeOrder(ComparativeOrder comparativeOrder) {
            this.comparativeOrder = comparativeOrder;
            return this;
        }

        public final SemanticType.Builder getSemanticType() {
            return this.semanticType != null ? this.semanticType.toBuilder() : null;
        }

        public final void setSemanticType(SemanticType.BuilderImpl semanticType) {
            this.semanticType = semanticType != null ? semanticType.build() : null;
        }

        @Override
        public final Builder semanticType(SemanticType semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        public final Collection<String> getAllowedAggregations() {
            if (this.allowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAggregations;
        }

        public final void setAllowedAggregations(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
        }

        @Override
        public final Builder allowedAggregationsWithStrings(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregationsWithStrings(String ... allowedAggregations) {
            this.allowedAggregationsWithStrings(Arrays.asList(allowedAggregations));
            return this;
        }

        @Override
        public final Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregations(AuthorSpecifiedAggregation ... allowedAggregations) {
            this.allowedAggregations(Arrays.asList(allowedAggregations));
            return this;
        }

        public final Collection<String> getNotAllowedAggregations() {
            if (this.notAllowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notAllowedAggregations;
        }

        public final void setNotAllowedAggregations(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
        }

        @Override
        public final Builder notAllowedAggregationsWithStrings(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregationsWithStrings(String ... notAllowedAggregations) {
            this.notAllowedAggregationsWithStrings(Arrays.asList(notAllowedAggregations));
            return this;
        }

        @Override
        public final Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregations(AuthorSpecifiedAggregation ... notAllowedAggregations) {
            this.notAllowedAggregations(Arrays.asList(notAllowedAggregations));
            return this;
        }

        public final Boolean getNeverAggregateInFilter() {
            return this.neverAggregateInFilter;
        }

        public final void setNeverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
        }

        @Override
        public final Builder neverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
            return this;
        }

        public final List<CellValueSynonym.Builder> getCellValueSynonyms() {
            List<CellValueSynonym.Builder> result = CellValueSynonymsCopier.copyToBuilder(this.cellValueSynonyms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellValueSynonyms(Collection<CellValueSynonym.BuilderImpl> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copyFromBuilder(cellValueSynonyms);
        }

        @Override
        public final Builder cellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copy(cellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(CellValueSynonym ... cellValueSynonyms) {
            this.cellValueSynonyms(Arrays.asList(cellValueSynonyms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder> ... cellValueSynonyms) {
            this.cellValueSynonyms(Stream.of(cellValueSynonyms).map(c -> (CellValueSynonym)((CellValueSynonym.Builder)CellValueSynonym.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getNonAdditive() {
            return this.nonAdditive;
        }

        public final void setNonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
        }

        @Override
        public final Builder nonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
            return this;
        }

        public TopicCalculatedField build() {
            return new TopicCalculatedField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicCalculatedField> {
        public Builder calculatedFieldName(String var1);

        public Builder calculatedFieldDescription(String var1);

        public Builder expression(String var1);

        public Builder calculatedFieldSynonyms(Collection<String> var1);

        public Builder calculatedFieldSynonyms(String ... var1);

        public Builder isIncludedInTopic(Boolean var1);

        public Builder disableIndexing(Boolean var1);

        public Builder columnDataRole(String var1);

        public Builder columnDataRole(ColumnDataRole var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TopicTimeGranularity var1);

        public Builder defaultFormatting(DefaultFormatting var1);

        default public Builder defaultFormatting(Consumer<DefaultFormatting.Builder> defaultFormatting) {
            return this.defaultFormatting((DefaultFormatting)((DefaultFormatting.Builder)DefaultFormatting.builder().applyMutation(defaultFormatting)).build());
        }

        public Builder aggregation(String var1);

        public Builder aggregation(DefaultAggregation var1);

        public Builder comparativeOrder(ComparativeOrder var1);

        default public Builder comparativeOrder(Consumer<ComparativeOrder.Builder> comparativeOrder) {
            return this.comparativeOrder((ComparativeOrder)((ComparativeOrder.Builder)ComparativeOrder.builder().applyMutation(comparativeOrder)).build());
        }

        public Builder semanticType(SemanticType var1);

        default public Builder semanticType(Consumer<SemanticType.Builder> semanticType) {
            return this.semanticType((SemanticType)((SemanticType.Builder)SemanticType.builder().applyMutation(semanticType)).build());
        }

        public Builder allowedAggregationsWithStrings(Collection<String> var1);

        public Builder allowedAggregationsWithStrings(String ... var1);

        public Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> var1);

        public Builder allowedAggregations(AuthorSpecifiedAggregation ... var1);

        public Builder notAllowedAggregationsWithStrings(Collection<String> var1);

        public Builder notAllowedAggregationsWithStrings(String ... var1);

        public Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> var1);

        public Builder notAllowedAggregations(AuthorSpecifiedAggregation ... var1);

        public Builder neverAggregateInFilter(Boolean var1);

        public Builder cellValueSynonyms(Collection<CellValueSynonym> var1);

        public Builder cellValueSynonyms(CellValueSynonym ... var1);

        public Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder> ... var1);

        public Builder nonAdditive(Boolean var1);
    }
}

