/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an insight visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightConfiguration.Builder, InsightConfiguration> {
    private static final SdkField<List<Computation>> COMPUTATIONS_FIELD = SdkField
            .<List<Computation>> builder(MarshallingType.LIST)
            .memberName("Computations")
            .getter(getter(InsightConfiguration::computations))
            .setter(setter(Builder::computations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Computations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Computation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Computation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomNarrativeOptions> CUSTOM_NARRATIVE_FIELD = SdkField
            .<CustomNarrativeOptions> builder(MarshallingType.SDK_POJO).memberName("CustomNarrative")
            .getter(getter(InsightConfiguration::customNarrative)).setter(setter(Builder::customNarrative))
            .constructor(CustomNarrativeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomNarrative").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(InsightConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATIONS_FIELD,
            CUSTOM_NARRATIVE_FIELD, INTERACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Computation> computations;

    private final CustomNarrativeOptions customNarrative;

    private final VisualInteractionOptions interactions;

    private InsightConfiguration(BuilderImpl builder) {
        this.computations = builder.computations;
        this.customNarrative = builder.customNarrative;
        this.interactions = builder.interactions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Computations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputations() {
        return computations != null && !(computations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The computations configurations of the insight visual
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputations} method.
     * </p>
     * 
     * @return The computations configurations of the insight visual
     */
    public final List<Computation> computations() {
        return computations;
    }

    /**
     * <p>
     * The custom narrative of the insight visual.
     * </p>
     * 
     * @return The custom narrative of the insight visual.
     */
    public final CustomNarrativeOptions customNarrative() {
        return customNarrative;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComputations() ? computations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customNarrative());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightConfiguration)) {
            return false;
        }
        InsightConfiguration other = (InsightConfiguration) obj;
        return hasComputations() == other.hasComputations() && Objects.equals(computations(), other.computations())
                && Objects.equals(customNarrative(), other.customNarrative())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightConfiguration").add("Computations", hasComputations() ? computations() : null)
                .add("CustomNarrative", customNarrative()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Computations":
            return Optional.ofNullable(clazz.cast(computations()));
        case "CustomNarrative":
            return Optional.ofNullable(clazz.cast(customNarrative()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightConfiguration, T> g) {
        return obj -> g.apply((InsightConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightConfiguration> {
        /**
         * <p>
         * The computations configurations of the insight visual
         * </p>
         * 
         * @param computations
         *        The computations configurations of the insight visual
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computations(Collection<Computation> computations);

        /**
         * <p>
         * The computations configurations of the insight visual
         * </p>
         * 
         * @param computations
         *        The computations configurations of the insight visual
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computations(Computation... computations);

        /**
         * <p>
         * The computations configurations of the insight visual
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Computation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Computation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Computation.Builder#build()} is called immediately
         * and its result is passed to {@link #computations(List<Computation>)}.
         * 
         * @param computations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Computation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computations(java.util.Collection<Computation>)
         */
        Builder computations(Consumer<Computation.Builder>... computations);

        /**
         * <p>
         * The custom narrative of the insight visual.
         * </p>
         * 
         * @param customNarrative
         *        The custom narrative of the insight visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customNarrative(CustomNarrativeOptions customNarrative);

        /**
         * <p>
         * The custom narrative of the insight visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomNarrativeOptions.Builder} avoiding
         * the need to create one manually via {@link CustomNarrativeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomNarrativeOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #customNarrative(CustomNarrativeOptions)}.
         * 
         * @param customNarrative
         *        a consumer that will call methods on {@link CustomNarrativeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customNarrative(CustomNarrativeOptions)
         */
        default Builder customNarrative(Consumer<CustomNarrativeOptions.Builder> customNarrative) {
            return customNarrative(CustomNarrativeOptions.builder().applyMutation(customNarrative).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Computation> computations = DefaultSdkAutoConstructList.getInstance();

        private CustomNarrativeOptions customNarrative;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightConfiguration model) {
            computations(model.computations);
            customNarrative(model.customNarrative);
            interactions(model.interactions);
        }

        public final List<Computation.Builder> getComputations() {
            List<Computation.Builder> result = ComputationListCopier.copyToBuilder(this.computations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputations(Collection<Computation.BuilderImpl> computations) {
            this.computations = ComputationListCopier.copyFromBuilder(computations);
        }

        @Override
        public final Builder computations(Collection<Computation> computations) {
            this.computations = ComputationListCopier.copy(computations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computations(Computation... computations) {
            computations(Arrays.asList(computations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computations(Consumer<Computation.Builder>... computations) {
            computations(Stream.of(computations).map(c -> Computation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CustomNarrativeOptions.Builder getCustomNarrative() {
            return customNarrative != null ? customNarrative.toBuilder() : null;
        }

        public final void setCustomNarrative(CustomNarrativeOptions.BuilderImpl customNarrative) {
            this.customNarrative = customNarrative != null ? customNarrative.build() : null;
        }

        @Override
        public final Builder customNarrative(CustomNarrativeOptions customNarrative) {
            this.customNarrative = customNarrative;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public InsightConfiguration build() {
            return new InsightConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
