/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default values of the <code>DateTimeParameterDeclaration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimeDefaultValues implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimeDefaultValues.Builder, DateTimeDefaultValues> {
    private static final SdkField<DynamicDefaultValue> DYNAMIC_VALUE_FIELD = SdkField
            .<DynamicDefaultValue> builder(MarshallingType.SDK_POJO).memberName("DynamicValue")
            .getter(getter(DateTimeDefaultValues::dynamicValue)).setter(setter(Builder::dynamicValue))
            .constructor(DynamicDefaultValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicValue").build()).build();

    private static final SdkField<List<Instant>> STATIC_VALUES_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("StaticValues")
            .getter(getter(DateTimeDefaultValues::staticValues))
            .setter(setter(Builder::staticValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RollingDateConfiguration> ROLLING_DATE_FIELD = SdkField
            .<RollingDateConfiguration> builder(MarshallingType.SDK_POJO).memberName("RollingDate")
            .getter(getter(DateTimeDefaultValues::rollingDate)).setter(setter(Builder::rollingDate))
            .constructor(RollingDateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_VALUE_FIELD,
            STATIC_VALUES_FIELD, ROLLING_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DynamicDefaultValue dynamicValue;

    private final List<Instant> staticValues;

    private final RollingDateConfiguration rollingDate;

    private DateTimeDefaultValues(BuilderImpl builder) {
        this.dynamicValue = builder.dynamicValue;
        this.staticValues = builder.staticValues;
        this.rollingDate = builder.rollingDate;
    }

    /**
     * <p>
     * The dynamic value of the <code>DataTimeDefaultValues</code>. Different defaults are displayed according to users,
     * groups, and values mapping.
     * </p>
     * 
     * @return The dynamic value of the <code>DataTimeDefaultValues</code>. Different defaults are displayed according
     *         to users, groups, and values mapping.
     */
    public final DynamicDefaultValue dynamicValue() {
        return dynamicValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaticValues() {
        return staticValues != null && !(staticValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The static values of the <code>DataTimeDefaultValues</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticValues} method.
     * </p>
     * 
     * @return The static values of the <code>DataTimeDefaultValues</code>.
     */
    public final List<Instant> staticValues() {
        return staticValues;
    }

    /**
     * <p>
     * The rolling date of the <code>DataTimeDefaultValues</code>. The date is determined from the dataset based on
     * input expression.
     * </p>
     * 
     * @return The rolling date of the <code>DataTimeDefaultValues</code>. The date is determined from the dataset based
     *         on input expression.
     */
    public final RollingDateConfiguration rollingDate() {
        return rollingDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamicValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticValues() ? staticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rollingDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeDefaultValues)) {
            return false;
        }
        DateTimeDefaultValues other = (DateTimeDefaultValues) obj;
        return Objects.equals(dynamicValue(), other.dynamicValue()) && hasStaticValues() == other.hasStaticValues()
                && Objects.equals(staticValues(), other.staticValues()) && Objects.equals(rollingDate(), other.rollingDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimeDefaultValues").add("DynamicValue", dynamicValue())
                .add("StaticValues", staticValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RollingDate", rollingDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamicValue":
            return Optional.ofNullable(clazz.cast(dynamicValue()));
        case "StaticValues":
            return Optional.ofNullable(clazz.cast(staticValues()));
        case "RollingDate":
            return Optional.ofNullable(clazz.cast(rollingDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeDefaultValues, T> g) {
        return obj -> g.apply((DateTimeDefaultValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimeDefaultValues> {
        /**
         * <p>
         * The dynamic value of the <code>DataTimeDefaultValues</code>. Different defaults are displayed according to
         * users, groups, and values mapping.
         * </p>
         * 
         * @param dynamicValue
         *        The dynamic value of the <code>DataTimeDefaultValues</code>. Different defaults are displayed
         *        according to users, groups, and values mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicValue(DynamicDefaultValue dynamicValue);

        /**
         * <p>
         * The dynamic value of the <code>DataTimeDefaultValues</code>. Different defaults are displayed according to
         * users, groups, and values mapping.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamicDefaultValue.Builder} avoiding the
         * need to create one manually via {@link DynamicDefaultValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamicDefaultValue.Builder#build()} is called immediately and
         * its result is passed to {@link #dynamicValue(DynamicDefaultValue)}.
         * 
         * @param dynamicValue
         *        a consumer that will call methods on {@link DynamicDefaultValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicValue(DynamicDefaultValue)
         */
        default Builder dynamicValue(Consumer<DynamicDefaultValue.Builder> dynamicValue) {
            return dynamicValue(DynamicDefaultValue.builder().applyMutation(dynamicValue).build());
        }

        /**
         * <p>
         * The static values of the <code>DataTimeDefaultValues</code>.
         * </p>
         * 
         * @param staticValues
         *        The static values of the <code>DataTimeDefaultValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValues(Collection<Instant> staticValues);

        /**
         * <p>
         * The static values of the <code>DataTimeDefaultValues</code>.
         * </p>
         * 
         * @param staticValues
         *        The static values of the <code>DataTimeDefaultValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValues(Instant... staticValues);

        /**
         * <p>
         * The rolling date of the <code>DataTimeDefaultValues</code>. The date is determined from the dataset based on
         * input expression.
         * </p>
         * 
         * @param rollingDate
         *        The rolling date of the <code>DataTimeDefaultValues</code>. The date is determined from the dataset
         *        based on input expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingDate(RollingDateConfiguration rollingDate);

        /**
         * <p>
         * The rolling date of the <code>DataTimeDefaultValues</code>. The date is determined from the dataset based on
         * input expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollingDateConfiguration.Builder}
         * avoiding the need to create one manually via {@link RollingDateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollingDateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #rollingDate(RollingDateConfiguration)}.
         * 
         * @param rollingDate
         *        a consumer that will call methods on {@link RollingDateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollingDate(RollingDateConfiguration)
         */
        default Builder rollingDate(Consumer<RollingDateConfiguration.Builder> rollingDate) {
            return rollingDate(RollingDateConfiguration.builder().applyMutation(rollingDate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DynamicDefaultValue dynamicValue;

        private List<Instant> staticValues = DefaultSdkAutoConstructList.getInstance();

        private RollingDateConfiguration rollingDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeDefaultValues model) {
            dynamicValue(model.dynamicValue);
            staticValues(model.staticValues);
            rollingDate(model.rollingDate);
        }

        public final DynamicDefaultValue.Builder getDynamicValue() {
            return dynamicValue != null ? dynamicValue.toBuilder() : null;
        }

        public final void setDynamicValue(DynamicDefaultValue.BuilderImpl dynamicValue) {
            this.dynamicValue = dynamicValue != null ? dynamicValue.build() : null;
        }

        @Override
        public final Builder dynamicValue(DynamicDefaultValue dynamicValue) {
            this.dynamicValue = dynamicValue;
            return this;
        }

        public final Collection<Instant> getStaticValues() {
            if (staticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return staticValues;
        }

        public final void setStaticValues(Collection<Instant> staticValues) {
            this.staticValues = DateTimeDefaultValueListCopier.copy(staticValues);
        }

        @Override
        public final Builder staticValues(Collection<Instant> staticValues) {
            this.staticValues = DateTimeDefaultValueListCopier.copy(staticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticValues(Instant... staticValues) {
            staticValues(Arrays.asList(staticValues));
            return this;
        }

        public final RollingDateConfiguration.Builder getRollingDate() {
            return rollingDate != null ? rollingDate.toBuilder() : null;
        }

        public final void setRollingDate(RollingDateConfiguration.BuilderImpl rollingDate) {
            this.rollingDate = rollingDate != null ? rollingDate.build() : null;
        }

        @Override
        public final Builder rollingDate(RollingDateConfiguration rollingDate) {
            this.rollingDate = rollingDate;
            return this;
        }

        @Override
        public DateTimeDefaultValues build() {
            return new DateTimeDefaultValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
