/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default options that correspond to the <code>Slider</code> filter control type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultSliderControlOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultSliderControlOptions.Builder, DefaultSliderControlOptions> {
    private static final SdkField<SliderControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<SliderControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(DefaultSliderControlOptions::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(SliderControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DefaultSliderControlOptions::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> MAXIMUM_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaximumValue").getter(getter(DefaultSliderControlOptions::maximumValue))
            .setter(setter(Builder::maximumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()).build();

    private static final SdkField<Double> MINIMUM_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinimumValue").getter(getter(DefaultSliderControlOptions::minimumValue))
            .setter(setter(Builder::minimumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()).build();

    private static final SdkField<Double> STEP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StepSize").getter(getter(DefaultSliderControlOptions::stepSize)).setter(setter(Builder::stepSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD,
            TYPE_FIELD, MAXIMUM_VALUE_FIELD, MINIMUM_VALUE_FIELD, STEP_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SliderControlDisplayOptions displayOptions;

    private final String type;

    private final Double maximumValue;

    private final Double minimumValue;

    private final Double stepSize;

    private DefaultSliderControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.maximumValue = builder.maximumValue;
        this.minimumValue = builder.minimumValue;
        this.stepSize = builder.stepSize;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final SliderControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANGE</code>: Filter data that is in a specified range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlSliderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANGE</code>: Filter data that is in a specified range.
     *         </p>
     *         </li>
     * @see SheetControlSliderType
     */
    public final SheetControlSliderType type() {
        return SheetControlSliderType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANGE</code>: Filter data that is in a specified range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlSliderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANGE</code>: Filter data that is in a specified range.
     *         </p>
     *         </li>
     * @see SheetControlSliderType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The larger value that is displayed at the right of the slider.
     * </p>
     * 
     * @return The larger value that is displayed at the right of the slider.
     */
    public final Double maximumValue() {
        return maximumValue;
    }

    /**
     * <p>
     * The smaller value that is displayed at the left of the slider.
     * </p>
     * 
     * @return The smaller value that is displayed at the left of the slider.
     */
    public final Double minimumValue() {
        return minimumValue;
    }

    /**
     * <p>
     * The number of increments that the slider bar is divided into.
     * </p>
     * 
     * @return The number of increments that the slider bar is divided into.
     */
    public final Double stepSize() {
        return stepSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(stepSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSliderControlOptions)) {
            return false;
        }
        DefaultSliderControlOptions other = (DefaultSliderControlOptions) obj;
        return Objects.equals(displayOptions(), other.displayOptions()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(maximumValue(), other.maximumValue()) && Objects.equals(minimumValue(), other.minimumValue())
                && Objects.equals(stepSize(), other.stepSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultSliderControlOptions").add("DisplayOptions", displayOptions())
                .add("Type", typeAsString()).add("MaximumValue", maximumValue()).add("MinimumValue", minimumValue())
                .add("StepSize", stepSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MaximumValue":
            return Optional.ofNullable(clazz.cast(maximumValue()));
        case "MinimumValue":
            return Optional.ofNullable(clazz.cast(minimumValue()));
        case "StepSize":
            return Optional.ofNullable(clazz.cast(stepSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultSliderControlOptions, T> g) {
        return obj -> g.apply((DefaultSliderControlOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultSliderControlOptions> {
        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(SliderControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link SliderControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link SliderControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SliderControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(SliderControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link SliderControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(SliderControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<SliderControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(SliderControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code>: Filter data that is in a specified range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code>: Filter data that is in a specified range.
         *        </p>
         *        </li>
         * @see SheetControlSliderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlSliderType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code>: Filter data that is in a specified range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE_POINT</code>: Filter against(equals) a single data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code>: Filter data that is in a specified range.
         *        </p>
         *        </li>
         * @see SheetControlSliderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlSliderType
         */
        Builder type(SheetControlSliderType type);

        /**
         * <p>
         * The larger value that is displayed at the right of the slider.
         * </p>
         * 
         * @param maximumValue
         *        The larger value that is displayed at the right of the slider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumValue(Double maximumValue);

        /**
         * <p>
         * The smaller value that is displayed at the left of the slider.
         * </p>
         * 
         * @param minimumValue
         *        The smaller value that is displayed at the left of the slider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumValue(Double minimumValue);

        /**
         * <p>
         * The number of increments that the slider bar is divided into.
         * </p>
         * 
         * @param stepSize
         *        The number of increments that the slider bar is divided into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepSize(Double stepSize);
    }

    static final class BuilderImpl implements Builder {
        private SliderControlDisplayOptions displayOptions;

        private String type;

        private Double maximumValue;

        private Double minimumValue;

        private Double stepSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultSliderControlOptions model) {
            displayOptions(model.displayOptions);
            type(model.type);
            maximumValue(model.maximumValue);
            minimumValue(model.minimumValue);
            stepSize(model.stepSize);
        }

        public final SliderControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(SliderControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(SliderControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlSliderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getMaximumValue() {
            return maximumValue;
        }

        public final void setMaximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        public final Builder maximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Double getMinimumValue() {
            return minimumValue;
        }

        public final void setMinimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        public final Builder minimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Double getStepSize() {
            return stepSize;
        }

        public final void setStepSize(Double stepSize) {
            this.stepSize = stepSize;
        }

        @Override
        public final Builder stepSize(Double stepSize) {
            this.stepSize = stepSize;
            return this;
        }

        @Override
        public DefaultSliderControlOptions build() {
            return new DefaultSliderControlOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
