/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeyRegistrationResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateKeyRegistrationResponse.Builder, UpdateKeyRegistrationResponse> {
    private static final SdkField<List<FailedKeyRegistrationEntry>> FAILED_KEY_REGISTRATION_FIELD = SdkField
            .<List<FailedKeyRegistrationEntry>> builder(MarshallingType.LIST)
            .memberName("FailedKeyRegistration")
            .getter(getter(UpdateKeyRegistrationResponse::failedKeyRegistration))
            .setter(setter(Builder::failedKeyRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedKeyRegistration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedKeyRegistrationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedKeyRegistrationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SuccessfulKeyRegistrationEntry>> SUCCESSFUL_KEY_REGISTRATION_FIELD = SdkField
            .<List<SuccessfulKeyRegistrationEntry>> builder(MarshallingType.LIST)
            .memberName("SuccessfulKeyRegistration")
            .getter(getter(UpdateKeyRegistrationResponse::successfulKeyRegistration))
            .setter(setter(Builder::successfulKeyRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulKeyRegistration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuccessfulKeyRegistrationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulKeyRegistrationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateKeyRegistrationResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_KEY_REGISTRATION_FIELD,
            SUCCESSFUL_KEY_REGISTRATION_FIELD, REQUEST_ID_FIELD));

    private final List<FailedKeyRegistrationEntry> failedKeyRegistration;

    private final List<SuccessfulKeyRegistrationEntry> successfulKeyRegistration;

    private final String requestId;

    private UpdateKeyRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.failedKeyRegistration = builder.failedKeyRegistration;
        this.successfulKeyRegistration = builder.successfulKeyRegistration;
        this.requestId = builder.requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedKeyRegistration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedKeyRegistration() {
        return failedKeyRegistration != null && !(failedKeyRegistration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all customer managed key registrations that failed to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedKeyRegistration} method.
     * </p>
     * 
     * @return A list of all customer managed key registrations that failed to update.
     */
    public final List<FailedKeyRegistrationEntry> failedKeyRegistration() {
        return failedKeyRegistration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulKeyRegistration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSuccessfulKeyRegistration() {
        return successfulKeyRegistration != null && !(successfulKeyRegistration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all customer managed key registrations that were successfully updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulKeyRegistration} method.
     * </p>
     * 
     * @return A list of all customer managed key registrations that were successfully updated.
     */
    public final List<SuccessfulKeyRegistrationEntry> successfulKeyRegistration() {
        return successfulKeyRegistration;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedKeyRegistration() ? failedKeyRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulKeyRegistration() ? successfulKeyRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyRegistrationResponse)) {
            return false;
        }
        UpdateKeyRegistrationResponse other = (UpdateKeyRegistrationResponse) obj;
        return hasFailedKeyRegistration() == other.hasFailedKeyRegistration()
                && Objects.equals(failedKeyRegistration(), other.failedKeyRegistration())
                && hasSuccessfulKeyRegistration() == other.hasSuccessfulKeyRegistration()
                && Objects.equals(successfulKeyRegistration(), other.successfulKeyRegistration())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeyRegistrationResponse")
                .add("FailedKeyRegistration", hasFailedKeyRegistration() ? failedKeyRegistration() : null)
                .add("SuccessfulKeyRegistration", hasSuccessfulKeyRegistration() ? successfulKeyRegistration() : null)
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedKeyRegistration":
            return Optional.ofNullable(clazz.cast(failedKeyRegistration()));
        case "SuccessfulKeyRegistration":
            return Optional.ofNullable(clazz.cast(successfulKeyRegistration()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyRegistrationResponse, T> g) {
        return obj -> g.apply((UpdateKeyRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKeyRegistrationResponse> {
        /**
         * <p>
         * A list of all customer managed key registrations that failed to update.
         * </p>
         * 
         * @param failedKeyRegistration
         *        A list of all customer managed key registrations that failed to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedKeyRegistration(Collection<FailedKeyRegistrationEntry> failedKeyRegistration);

        /**
         * <p>
         * A list of all customer managed key registrations that failed to update.
         * </p>
         * 
         * @param failedKeyRegistration
         *        A list of all customer managed key registrations that failed to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedKeyRegistration(FailedKeyRegistrationEntry... failedKeyRegistration);

        /**
         * <p>
         * A list of all customer managed key registrations that failed to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FailedKeyRegistrationEntry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.FailedKeyRegistrationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FailedKeyRegistrationEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #failedKeyRegistration(List<FailedKeyRegistrationEntry>)}.
         * 
         * @param failedKeyRegistration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FailedKeyRegistrationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedKeyRegistration(java.util.Collection<FailedKeyRegistrationEntry>)
         */
        Builder failedKeyRegistration(Consumer<FailedKeyRegistrationEntry.Builder>... failedKeyRegistration);

        /**
         * <p>
         * A list of all customer managed key registrations that were successfully updated.
         * </p>
         * 
         * @param successfulKeyRegistration
         *        A list of all customer managed key registrations that were successfully updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulKeyRegistration(Collection<SuccessfulKeyRegistrationEntry> successfulKeyRegistration);

        /**
         * <p>
         * A list of all customer managed key registrations that were successfully updated.
         * </p>
         * 
         * @param successfulKeyRegistration
         *        A list of all customer managed key registrations that were successfully updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulKeyRegistration(SuccessfulKeyRegistrationEntry... successfulKeyRegistration);

        /**
         * <p>
         * A list of all customer managed key registrations that were successfully updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SuccessfulKeyRegistrationEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SuccessfulKeyRegistrationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SuccessfulKeyRegistrationEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successfulKeyRegistration(List<SuccessfulKeyRegistrationEntry>)}.
         * 
         * @param successfulKeyRegistration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SuccessfulKeyRegistrationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulKeyRegistration(java.util.Collection<SuccessfulKeyRegistrationEntry>)
         */
        Builder successfulKeyRegistration(Consumer<SuccessfulKeyRegistrationEntry.Builder>... successfulKeyRegistration);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<FailedKeyRegistrationEntry> failedKeyRegistration = DefaultSdkAutoConstructList.getInstance();

        private List<SuccessfulKeyRegistrationEntry> successfulKeyRegistration = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyRegistrationResponse model) {
            super(model);
            failedKeyRegistration(model.failedKeyRegistration);
            successfulKeyRegistration(model.successfulKeyRegistration);
            requestId(model.requestId);
        }

        public final List<FailedKeyRegistrationEntry.Builder> getFailedKeyRegistration() {
            List<FailedKeyRegistrationEntry.Builder> result = FailedKeyRegistrationEntriesCopier
                    .copyToBuilder(this.failedKeyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedKeyRegistration(Collection<FailedKeyRegistrationEntry.BuilderImpl> failedKeyRegistration) {
            this.failedKeyRegistration = FailedKeyRegistrationEntriesCopier.copyFromBuilder(failedKeyRegistration);
        }

        @Override
        public final Builder failedKeyRegistration(Collection<FailedKeyRegistrationEntry> failedKeyRegistration) {
            this.failedKeyRegistration = FailedKeyRegistrationEntriesCopier.copy(failedKeyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedKeyRegistration(FailedKeyRegistrationEntry... failedKeyRegistration) {
            failedKeyRegistration(Arrays.asList(failedKeyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedKeyRegistration(Consumer<FailedKeyRegistrationEntry.Builder>... failedKeyRegistration) {
            failedKeyRegistration(Stream.of(failedKeyRegistration)
                    .map(c -> FailedKeyRegistrationEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SuccessfulKeyRegistrationEntry.Builder> getSuccessfulKeyRegistration() {
            List<SuccessfulKeyRegistrationEntry.Builder> result = SuccessfulKeyRegistrationEntriesCopier
                    .copyToBuilder(this.successfulKeyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulKeyRegistration(
                Collection<SuccessfulKeyRegistrationEntry.BuilderImpl> successfulKeyRegistration) {
            this.successfulKeyRegistration = SuccessfulKeyRegistrationEntriesCopier.copyFromBuilder(successfulKeyRegistration);
        }

        @Override
        public final Builder successfulKeyRegistration(Collection<SuccessfulKeyRegistrationEntry> successfulKeyRegistration) {
            this.successfulKeyRegistration = SuccessfulKeyRegistrationEntriesCopier.copy(successfulKeyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulKeyRegistration(SuccessfulKeyRegistrationEntry... successfulKeyRegistration) {
            successfulKeyRegistration(Arrays.asList(successfulKeyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulKeyRegistration(
                Consumer<SuccessfulKeyRegistrationEntry.Builder>... successfulKeyRegistration) {
            successfulKeyRegistration(Stream.of(successfulKeyRegistration)
                    .map(c -> SuccessfulKeyRegistrationEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public UpdateKeyRegistrationResponse build() {
            return new UpdateKeyRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
