/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The category drill down filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CategoryDrillDownFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CategoryDrillDownFilter.Builder, CategoryDrillDownFilter> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(CategoryDrillDownFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<List<String>> CATEGORY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CategoryValues")
            .getter(getter(CategoryDrillDownFilter::categoryValues))
            .setter(setter(Builder::categoryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD,
            CATEGORY_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final List<String> categoryValues;

    private CategoryDrillDownFilter(BuilderImpl builder) {
        this.column = builder.column;
        this.categoryValues = builder.categoryValues;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCategoryValues() {
        return categoryValues != null && !(categoryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the string inputs that are the values of the category drill down filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoryValues} method.
     * </p>
     * 
     * @return A list of the string inputs that are the values of the category drill down filter.
     */
    public final List<String> categoryValues() {
        return categoryValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoryValues() ? categoryValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryDrillDownFilter)) {
            return false;
        }
        CategoryDrillDownFilter other = (CategoryDrillDownFilter) obj;
        return Objects.equals(column(), other.column()) && hasCategoryValues() == other.hasCategoryValues()
                && Objects.equals(categoryValues(), other.categoryValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoryDrillDownFilter").add("Column", column())
                .add("CategoryValues", hasCategoryValues() ? categoryValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "CategoryValues":
            return Optional.ofNullable(clazz.cast(categoryValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryDrillDownFilter, T> g) {
        return obj -> g.apply((CategoryDrillDownFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoryDrillDownFilter> {
        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * A list of the string inputs that are the values of the category drill down filter.
         * </p>
         * 
         * @param categoryValues
         *        A list of the string inputs that are the values of the category drill down filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryValues(Collection<String> categoryValues);

        /**
         * <p>
         * A list of the string inputs that are the values of the category drill down filter.
         * </p>
         * 
         * @param categoryValues
         *        A list of the string inputs that are the values of the category drill down filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryValues(String... categoryValues);
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private List<String> categoryValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryDrillDownFilter model) {
            column(model.column);
            categoryValues(model.categoryValues);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Collection<String> getCategoryValues() {
            if (categoryValues instanceof SdkAutoConstructList) {
                return null;
            }
            return categoryValues;
        }

        public final void setCategoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
        }

        @Override
        public final Builder categoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryValues(String... categoryValues) {
            categoryValues(Arrays.asList(categoryValues));
            return this;
        }

        @Override
        public CategoryDrillDownFilter build() {
            return new CategoryDrillDownFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
