/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a singular filter constant, used in filters to specify a single value to match against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicSingularFilterConstant implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicSingularFilterConstant.Builder, TopicSingularFilterConstant> {
    private static final SdkField<String> CONSTANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstantType").getter(getter(TopicSingularFilterConstant::constantTypeAsString))
            .setter(setter(Builder::constantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantType").build()).build();

    private static final SdkField<String> SINGULAR_CONSTANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SingularConstant").getter(getter(TopicSingularFilterConstant::singularConstant))
            .setter(setter(Builder::singularConstant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingularConstant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_TYPE_FIELD,
            SINGULAR_CONSTANT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantType;

    private final String singularConstant;

    private TopicSingularFilterConstant(BuilderImpl builder) {
        this.constantType = builder.constantType;
        this.singularConstant = builder.singularConstant;
    }

    /**
     * <p>
     * The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
     * @see ConstantType
     */
    public final ConstantType constantType() {
        return ConstantType.fromValue(constantType);
    }

    /**
     * <p>
     * The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
     * @see ConstantType
     */
    public final String constantTypeAsString() {
        return constantType;
    }

    /**
     * <p>
     * The value of the singular filter constant.
     * </p>
     * 
     * @return The value of the singular filter constant.
     */
    public final String singularConstant() {
        return singularConstant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singularConstant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicSingularFilterConstant)) {
            return false;
        }
        TopicSingularFilterConstant other = (TopicSingularFilterConstant) obj;
        return Objects.equals(constantTypeAsString(), other.constantTypeAsString())
                && Objects.equals(singularConstant(), other.singularConstant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicSingularFilterConstant").add("ConstantType", constantTypeAsString())
                .add("SingularConstant", singularConstant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantType":
            return Optional.ofNullable(clazz.cast(constantTypeAsString()));
        case "SingularConstant":
            return Optional.ofNullable(clazz.cast(singularConstant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicSingularFilterConstant, T> g) {
        return obj -> g.apply((TopicSingularFilterConstant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicSingularFilterConstant> {
        /**
         * <p>
         * The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
         * </p>
         * 
         * @param constantType
         *        The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(String constantType);

        /**
         * <p>
         * The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
         * </p>
         * 
         * @param constantType
         *        The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(ConstantType constantType);

        /**
         * <p>
         * The value of the singular filter constant.
         * </p>
         * 
         * @param singularConstant
         *        The value of the singular filter constant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singularConstant(String singularConstant);
    }

    static final class BuilderImpl implements Builder {
        private String constantType;

        private String singularConstant;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicSingularFilterConstant model) {
            constantType(model.constantType);
            singularConstant(model.singularConstant);
        }

        public final String getConstantType() {
            return constantType;
        }

        public final void setConstantType(String constantType) {
            this.constantType = constantType;
        }

        @Override
        public final Builder constantType(String constantType) {
            this.constantType = constantType;
            return this;
        }

        @Override
        public final Builder constantType(ConstantType constantType) {
            this.constantType(constantType == null ? null : constantType.toString());
            return this;
        }

        public final String getSingularConstant() {
            return singularConstant;
        }

        public final void setSingularConstant(String singularConstant) {
            this.singularConstant = singularConstant;
        }

        @Override
        public final Builder singularConstant(String singularConstant) {
            this.singularConstant = singularConstant;
            return this;
        }

        @Override
        public TopicSingularFilterConstant build() {
            return new TopicSingularFilterConstant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
