/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A dataset parameter that is mapped to an analysis parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MappedDataSetParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<MappedDataSetParameter.Builder, MappedDataSetParameter> {
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetIdentifier").getter(getter(MappedDataSetParameter::dataSetIdentifier))
            .setter(setter(Builder::dataSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()).build();

    private static final SdkField<String> DATA_SET_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetParameterName").getter(getter(MappedDataSetParameter::dataSetParameterName))
            .setter(setter(Builder::dataSetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetParameterName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDENTIFIER_FIELD,
            DATA_SET_PARAMETER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSetIdentifier;

    private final String dataSetParameterName;

    private MappedDataSetParameter(BuilderImpl builder) {
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.dataSetParameterName = builder.dataSetParameterName;
    }

    /**
     * <p>
     * A unique name that identifies a dataset within the analysis or dashboard.
     * </p>
     * 
     * @return A unique name that identifies a dataset within the analysis or dashboard.
     */
    public final String dataSetIdentifier() {
        return dataSetIdentifier;
    }

    /**
     * <p>
     * The name of the dataset parameter.
     * </p>
     * 
     * @return The name of the dataset parameter.
     */
    public final String dataSetParameterName() {
        return dataSetParameterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetParameterName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappedDataSetParameter)) {
            return false;
        }
        MappedDataSetParameter other = (MappedDataSetParameter) obj;
        return Objects.equals(dataSetIdentifier(), other.dataSetIdentifier())
                && Objects.equals(dataSetParameterName(), other.dataSetParameterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MappedDataSetParameter").add("DataSetIdentifier", dataSetIdentifier())
                .add("DataSetParameterName", dataSetParameterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetIdentifier":
            return Optional.ofNullable(clazz.cast(dataSetIdentifier()));
        case "DataSetParameterName":
            return Optional.ofNullable(clazz.cast(dataSetParameterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MappedDataSetParameter, T> g) {
        return obj -> g.apply((MappedDataSetParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MappedDataSetParameter> {
        /**
         * <p>
         * A unique name that identifies a dataset within the analysis or dashboard.
         * </p>
         * 
         * @param dataSetIdentifier
         *        A unique name that identifies a dataset within the analysis or dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifier(String dataSetIdentifier);

        /**
         * <p>
         * The name of the dataset parameter.
         * </p>
         * 
         * @param dataSetParameterName
         *        The name of the dataset parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetParameterName(String dataSetParameterName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetIdentifier;

        private String dataSetParameterName;

        private BuilderImpl() {
        }

        private BuilderImpl(MappedDataSetParameter model) {
            dataSetIdentifier(model.dataSetIdentifier);
            dataSetParameterName(model.dataSetParameterName);
        }

        public final String getDataSetIdentifier() {
            return dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final String getDataSetParameterName() {
            return dataSetParameterName;
        }

        public final void setDataSetParameterName(String dataSetParameterName) {
            this.dataSetParameterName = dataSetParameterName;
        }

        @Override
        public final Builder dataSetParameterName(String dataSetParameterName) {
            this.dataSetParameterName = dataSetParameterName;
            return this;
        }

        @Override
        public MappedDataSetParameter build() {
            return new MappedDataSetParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
