/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeyRegistrationResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeKeyRegistrationResponse.Builder, DescribeKeyRegistrationResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeKeyRegistrationResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<List<RegisteredCustomerManagedKey>> KEY_REGISTRATION_FIELD = SdkField
            .<List<RegisteredCustomerManagedKey>> builder(MarshallingType.LIST)
            .memberName("KeyRegistration")
            .getter(getter(DescribeKeyRegistrationResponse::keyRegistration))
            .setter(setter(Builder::keyRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRegistration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegisteredCustomerManagedKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegisteredCustomerManagedKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeKeyRegistrationResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeKeyRegistrationResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            KEY_REGISTRATION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String awsAccountId;

    private final List<RegisteredCustomerManagedKey> keyRegistration;

    private final String requestId;

    private final Integer status;

    private DescribeKeyRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.keyRegistration = builder.keyRegistration;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the customer managed key registration specified in the
     * request.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the customer managed key registration specified
     *         in the request.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyRegistration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyRegistration() {
        return keyRegistration != null && !(keyRegistration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyRegistration} method.
     * </p>
     * 
     * @return A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
     */
    public final List<RegisteredCustomerManagedKey> keyRegistration() {
        return keyRegistration;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyRegistration() ? keyRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyRegistrationResponse)) {
            return false;
        }
        DescribeKeyRegistrationResponse other = (DescribeKeyRegistrationResponse) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && hasKeyRegistration() == other.hasKeyRegistration()
                && Objects.equals(keyRegistration(), other.keyRegistration()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeKeyRegistrationResponse").add("AwsAccountId", awsAccountId())
                .add("KeyRegistration", hasKeyRegistration() ? keyRegistration() : null).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "KeyRegistration":
            return Optional.ofNullable(clazz.cast(keyRegistration()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyRegistrationResponse, T> g) {
        return obj -> g.apply((DescribeKeyRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeKeyRegistrationResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the customer managed key registration specified in
         * the request.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the customer managed key registration
         *        specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
         * </p>
         * 
         * @param keyRegistration
         *        A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRegistration(Collection<RegisteredCustomerManagedKey> keyRegistration);

        /**
         * <p>
         * A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
         * </p>
         * 
         * @param keyRegistration
         *        A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRegistration(RegisteredCustomerManagedKey... keyRegistration);

        /**
         * <p>
         * A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey.Builder#build()} is
         * called immediately and its result is passed to {@link #keyRegistration(List<RegisteredCustomerManagedKey>)}.
         * 
         * @param keyRegistration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyRegistration(java.util.Collection<RegisteredCustomerManagedKey>)
         */
        Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder>... keyRegistration);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String awsAccountId;

        private List<RegisteredCustomerManagedKey> keyRegistration = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyRegistrationResponse model) {
            super(model);
            awsAccountId(model.awsAccountId);
            keyRegistration(model.keyRegistration);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final List<RegisteredCustomerManagedKey.Builder> getKeyRegistration() {
            List<RegisteredCustomerManagedKey.Builder> result = KeyRegistrationCopier.copyToBuilder(this.keyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyRegistration(Collection<RegisteredCustomerManagedKey.BuilderImpl> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copyFromBuilder(keyRegistration);
        }

        @Override
        public final Builder keyRegistration(Collection<RegisteredCustomerManagedKey> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copy(keyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(RegisteredCustomerManagedKey... keyRegistration) {
            keyRegistration(Arrays.asList(keyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder>... keyRegistration) {
            keyRegistration(Stream.of(keyRegistration).map(c -> RegisteredCustomerManagedKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeKeyRegistrationResponse build() {
            return new DescribeKeyRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
