/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FailedKeyRegistrationEntriesCopier {
    static List<FailedKeyRegistrationEntry> copy(
            Collection<? extends FailedKeyRegistrationEntry> failedKeyRegistrationEntriesParam) {
        List<FailedKeyRegistrationEntry> list;
        if (failedKeyRegistrationEntriesParam == null || failedKeyRegistrationEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FailedKeyRegistrationEntry> modifiableList = new ArrayList<>();
            failedKeyRegistrationEntriesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FailedKeyRegistrationEntry> copyFromBuilder(
            Collection<? extends FailedKeyRegistrationEntry.Builder> failedKeyRegistrationEntriesParam) {
        List<FailedKeyRegistrationEntry> list;
        if (failedKeyRegistrationEntriesParam == null || failedKeyRegistrationEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FailedKeyRegistrationEntry> modifiableList = new ArrayList<>();
            failedKeyRegistrationEntriesParam.forEach(entry -> {
                FailedKeyRegistrationEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FailedKeyRegistrationEntry.Builder> copyToBuilder(
            Collection<? extends FailedKeyRegistrationEntry> failedKeyRegistrationEntriesParam) {
        List<FailedKeyRegistrationEntry.Builder> list;
        if (failedKeyRegistrationEntriesParam == null || failedKeyRegistrationEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FailedKeyRegistrationEntry.Builder> modifiableList = new ArrayList<>();
            failedKeyRegistrationEntriesParam.forEach(entry -> {
                FailedKeyRegistrationEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
