/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the dataset column and constraints for the dynamic values used to repeat the contents of a section. The
 * dataset column is either <b>Category</b> or <b>Numeric</b> column configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BodySectionRepeatDimensionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BodySectionRepeatDimensionConfiguration.Builder, BodySectionRepeatDimensionConfiguration> {
    private static final SdkField<BodySectionDynamicCategoryDimensionConfiguration> DYNAMIC_CATEGORY_DIMENSION_CONFIGURATION_FIELD = SdkField
            .<BodySectionDynamicCategoryDimensionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DynamicCategoryDimensionConfiguration")
            .getter(getter(BodySectionRepeatDimensionConfiguration::dynamicCategoryDimensionConfiguration))
            .setter(setter(Builder::dynamicCategoryDimensionConfiguration))
            .constructor(BodySectionDynamicCategoryDimensionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DynamicCategoryDimensionConfiguration").build()).build();

    private static final SdkField<BodySectionDynamicNumericDimensionConfiguration> DYNAMIC_NUMERIC_DIMENSION_CONFIGURATION_FIELD = SdkField
            .<BodySectionDynamicNumericDimensionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DynamicNumericDimensionConfiguration")
            .getter(getter(BodySectionRepeatDimensionConfiguration::dynamicNumericDimensionConfiguration))
            .setter(setter(Builder::dynamicNumericDimensionConfiguration))
            .constructor(BodySectionDynamicNumericDimensionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DynamicNumericDimensionConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DYNAMIC_CATEGORY_DIMENSION_CONFIGURATION_FIELD, DYNAMIC_NUMERIC_DIMENSION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final BodySectionDynamicCategoryDimensionConfiguration dynamicCategoryDimensionConfiguration;

    private final BodySectionDynamicNumericDimensionConfiguration dynamicNumericDimensionConfiguration;

    private BodySectionRepeatDimensionConfiguration(BuilderImpl builder) {
        this.dynamicCategoryDimensionConfiguration = builder.dynamicCategoryDimensionConfiguration;
        this.dynamicNumericDimensionConfiguration = builder.dynamicNumericDimensionConfiguration;
    }

    /**
     * <p>
     * Describes the <b>Category</b> dataset column and constraints around the dynamic values that will be used in
     * repeating the section contents.
     * </p>
     * 
     * @return Describes the <b>Category</b> dataset column and constraints around the dynamic values that will be used
     *         in repeating the section contents.
     */
    public final BodySectionDynamicCategoryDimensionConfiguration dynamicCategoryDimensionConfiguration() {
        return dynamicCategoryDimensionConfiguration;
    }

    /**
     * <p>
     * Describes the <b>Numeric</b> dataset column and constraints around the dynamic values used to repeat the contents
     * of a section.
     * </p>
     * 
     * @return Describes the <b>Numeric</b> dataset column and constraints around the dynamic values used to repeat the
     *         contents of a section.
     */
    public final BodySectionDynamicNumericDimensionConfiguration dynamicNumericDimensionConfiguration() {
        return dynamicNumericDimensionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamicCategoryDimensionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicNumericDimensionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionRepeatDimensionConfiguration)) {
            return false;
        }
        BodySectionRepeatDimensionConfiguration other = (BodySectionRepeatDimensionConfiguration) obj;
        return Objects.equals(dynamicCategoryDimensionConfiguration(), other.dynamicCategoryDimensionConfiguration())
                && Objects.equals(dynamicNumericDimensionConfiguration(), other.dynamicNumericDimensionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BodySectionRepeatDimensionConfiguration")
                .add("DynamicCategoryDimensionConfiguration", dynamicCategoryDimensionConfiguration())
                .add("DynamicNumericDimensionConfiguration", dynamicNumericDimensionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamicCategoryDimensionConfiguration":
            return Optional.ofNullable(clazz.cast(dynamicCategoryDimensionConfiguration()));
        case "DynamicNumericDimensionConfiguration":
            return Optional.ofNullable(clazz.cast(dynamicNumericDimensionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BodySectionRepeatDimensionConfiguration, T> g) {
        return obj -> g.apply((BodySectionRepeatDimensionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BodySectionRepeatDimensionConfiguration> {
        /**
         * <p>
         * Describes the <b>Category</b> dataset column and constraints around the dynamic values that will be used in
         * repeating the section contents.
         * </p>
         * 
         * @param dynamicCategoryDimensionConfiguration
         *        Describes the <b>Category</b> dataset column and constraints around the dynamic values that will be
         *        used in repeating the section contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicCategoryDimensionConfiguration(
                BodySectionDynamicCategoryDimensionConfiguration dynamicCategoryDimensionConfiguration);

        /**
         * <p>
         * Describes the <b>Category</b> dataset column and constraints around the dynamic values that will be used in
         * repeating the section contents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BodySectionDynamicCategoryDimensionConfiguration.Builder} avoiding the need to create one manually via
         * {@link BodySectionDynamicCategoryDimensionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BodySectionDynamicCategoryDimensionConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #dynamicCategoryDimensionConfiguration(BodySectionDynamicCategoryDimensionConfiguration)}.
         * 
         * @param dynamicCategoryDimensionConfiguration
         *        a consumer that will call methods on {@link BodySectionDynamicCategoryDimensionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicCategoryDimensionConfiguration(BodySectionDynamicCategoryDimensionConfiguration)
         */
        default Builder dynamicCategoryDimensionConfiguration(
                Consumer<BodySectionDynamicCategoryDimensionConfiguration.Builder> dynamicCategoryDimensionConfiguration) {
            return dynamicCategoryDimensionConfiguration(BodySectionDynamicCategoryDimensionConfiguration.builder()
                    .applyMutation(dynamicCategoryDimensionConfiguration).build());
        }

        /**
         * <p>
         * Describes the <b>Numeric</b> dataset column and constraints around the dynamic values used to repeat the
         * contents of a section.
         * </p>
         * 
         * @param dynamicNumericDimensionConfiguration
         *        Describes the <b>Numeric</b> dataset column and constraints around the dynamic values used to repeat
         *        the contents of a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicNumericDimensionConfiguration(
                BodySectionDynamicNumericDimensionConfiguration dynamicNumericDimensionConfiguration);

        /**
         * <p>
         * Describes the <b>Numeric</b> dataset column and constraints around the dynamic values used to repeat the
         * contents of a section.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BodySectionDynamicNumericDimensionConfiguration.Builder} avoiding the need to create one manually via
         * {@link BodySectionDynamicNumericDimensionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BodySectionDynamicNumericDimensionConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #dynamicNumericDimensionConfiguration(BodySectionDynamicNumericDimensionConfiguration)}.
         * 
         * @param dynamicNumericDimensionConfiguration
         *        a consumer that will call methods on {@link BodySectionDynamicNumericDimensionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicNumericDimensionConfiguration(BodySectionDynamicNumericDimensionConfiguration)
         */
        default Builder dynamicNumericDimensionConfiguration(
                Consumer<BodySectionDynamicNumericDimensionConfiguration.Builder> dynamicNumericDimensionConfiguration) {
            return dynamicNumericDimensionConfiguration(BodySectionDynamicNumericDimensionConfiguration.builder()
                    .applyMutation(dynamicNumericDimensionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BodySectionDynamicCategoryDimensionConfiguration dynamicCategoryDimensionConfiguration;

        private BodySectionDynamicNumericDimensionConfiguration dynamicNumericDimensionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionRepeatDimensionConfiguration model) {
            dynamicCategoryDimensionConfiguration(model.dynamicCategoryDimensionConfiguration);
            dynamicNumericDimensionConfiguration(model.dynamicNumericDimensionConfiguration);
        }

        public final BodySectionDynamicCategoryDimensionConfiguration.Builder getDynamicCategoryDimensionConfiguration() {
            return dynamicCategoryDimensionConfiguration != null ? dynamicCategoryDimensionConfiguration.toBuilder() : null;
        }

        public final void setDynamicCategoryDimensionConfiguration(
                BodySectionDynamicCategoryDimensionConfiguration.BuilderImpl dynamicCategoryDimensionConfiguration) {
            this.dynamicCategoryDimensionConfiguration = dynamicCategoryDimensionConfiguration != null ? dynamicCategoryDimensionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder dynamicCategoryDimensionConfiguration(
                BodySectionDynamicCategoryDimensionConfiguration dynamicCategoryDimensionConfiguration) {
            this.dynamicCategoryDimensionConfiguration = dynamicCategoryDimensionConfiguration;
            return this;
        }

        public final BodySectionDynamicNumericDimensionConfiguration.Builder getDynamicNumericDimensionConfiguration() {
            return dynamicNumericDimensionConfiguration != null ? dynamicNumericDimensionConfiguration.toBuilder() : null;
        }

        public final void setDynamicNumericDimensionConfiguration(
                BodySectionDynamicNumericDimensionConfiguration.BuilderImpl dynamicNumericDimensionConfiguration) {
            this.dynamicNumericDimensionConfiguration = dynamicNumericDimensionConfiguration != null ? dynamicNumericDimensionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder dynamicNumericDimensionConfiguration(
                BodySectionDynamicNumericDimensionConfiguration dynamicNumericDimensionConfiguration) {
            this.dynamicNumericDimensionConfiguration = dynamicNumericDimensionConfiguration;
            return this;
        }

        @Override
        public BodySectionRepeatDimensionConfiguration build() {
            return new BodySectionRepeatDimensionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
