/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicConstantValue</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicConstantValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicConstantValue.Builder, TopicConstantValue> {
    private static final SdkField<String> CONSTANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstantType").getter(getter(TopicConstantValue::constantTypeAsString))
            .setter(setter(Builder::constantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(TopicConstantValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> MINIMUM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Minimum")
            .getter(getter(TopicConstantValue::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<String> MAXIMUM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Maximum")
            .getter(getter(TopicConstantValue::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final SdkField<List<CollectiveConstantEntry>> VALUE_LIST_FIELD = SdkField
            .<List<CollectiveConstantEntry>> builder(MarshallingType.LIST)
            .memberName("ValueList")
            .getter(getter(TopicConstantValue::valueList))
            .setter(setter(Builder::valueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollectiveConstantEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollectiveConstantEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_TYPE_FIELD,
            VALUE_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD, VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantType;

    private final String value;

    private final String minimum;

    private final String maximum;

    private final List<CollectiveConstantEntry> valueList;

    private TopicConstantValue(BuilderImpl builder) {
        this.constantType = builder.constantType;
        this.value = builder.value;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.valueList = builder.valueList;
    }

    /**
     * <p>
     * The constant type of a <code>TopicConstantValue</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The constant type of a <code>TopicConstantValue</code>.
     * @see ConstantType
     */
    public final ConstantType constantType() {
        return ConstantType.fromValue(constantType);
    }

    /**
     * <p>
     * The constant type of a <code>TopicConstantValue</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The constant type of a <code>TopicConstantValue</code>.
     * @see ConstantType
     */
    public final String constantTypeAsString() {
        return constantType;
    }

    /**
     * <p>
     * The value of the <code>TopicConstantValue</code>.
     * </p>
     * 
     * @return The value of the <code>TopicConstantValue</code>.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The minimum for the <code>TopicConstantValue</code>.
     * </p>
     * 
     * @return The minimum for the <code>TopicConstantValue</code>.
     */
    public final String minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum for the <code>TopicConstantValue</code>.
     * </p>
     * 
     * @return The maximum for the <code>TopicConstantValue</code>.
     */
    public final String maximum() {
        return maximum;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueList() {
        return valueList != null && !(valueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value list of the <code>TopicConstantValue</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueList} method.
     * </p>
     * 
     * @return The value list of the <code>TopicConstantValue</code>.
     */
    public final List<CollectiveConstantEntry> valueList() {
        return valueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueList() ? valueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConstantValue)) {
            return false;
        }
        TopicConstantValue other = (TopicConstantValue) obj;
        return Objects.equals(constantTypeAsString(), other.constantTypeAsString()) && Objects.equals(value(), other.value())
                && Objects.equals(minimum(), other.minimum()) && Objects.equals(maximum(), other.maximum())
                && hasValueList() == other.hasValueList() && Objects.equals(valueList(), other.valueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicConstantValue").add("ConstantType", constantTypeAsString()).add("Value", value())
                .add("Minimum", minimum()).add("Maximum", maximum()).add("ValueList", hasValueList() ? valueList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantType":
            return Optional.ofNullable(clazz.cast(constantTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "ValueList":
            return Optional.ofNullable(clazz.cast(valueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicConstantValue, T> g) {
        return obj -> g.apply((TopicConstantValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicConstantValue> {
        /**
         * <p>
         * The constant type of a <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param constantType
         *        The constant type of a <code>TopicConstantValue</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(String constantType);

        /**
         * <p>
         * The constant type of a <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param constantType
         *        The constant type of a <code>TopicConstantValue</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(ConstantType constantType);

        /**
         * <p>
         * The value of the <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param value
         *        The value of the <code>TopicConstantValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The minimum for the <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param minimum
         *        The minimum for the <code>TopicConstantValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(String minimum);

        /**
         * <p>
         * The maximum for the <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param maximum
         *        The maximum for the <code>TopicConstantValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(String maximum);

        /**
         * <p>
         * The value list of the <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param valueList
         *        The value list of the <code>TopicConstantValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(Collection<CollectiveConstantEntry> valueList);

        /**
         * <p>
         * The value list of the <code>TopicConstantValue</code>.
         * </p>
         * 
         * @param valueList
         *        The value list of the <code>TopicConstantValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(CollectiveConstantEntry... valueList);

        /**
         * <p>
         * The value list of the <code>TopicConstantValue</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.CollectiveConstantEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.CollectiveConstantEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.CollectiveConstantEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #valueList(List<CollectiveConstantEntry>)}.
         * 
         * @param valueList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.CollectiveConstantEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueList(java.util.Collection<CollectiveConstantEntry>)
         */
        Builder valueList(Consumer<CollectiveConstantEntry.Builder>... valueList);
    }

    static final class BuilderImpl implements Builder {
        private String constantType;

        private String value;

        private String minimum;

        private String maximum;

        private List<CollectiveConstantEntry> valueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConstantValue model) {
            constantType(model.constantType);
            value(model.value);
            minimum(model.minimum);
            maximum(model.maximum);
            valueList(model.valueList);
        }

        public final String getConstantType() {
            return constantType;
        }

        public final void setConstantType(String constantType) {
            this.constantType = constantType;
        }

        @Override
        public final Builder constantType(String constantType) {
            this.constantType = constantType;
            return this;
        }

        @Override
        public final Builder constantType(ConstantType constantType) {
            this.constantType(constantType == null ? null : constantType.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getMinimum() {
            return minimum;
        }

        public final void setMinimum(String minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(String minimum) {
            this.minimum = minimum;
            return this;
        }

        public final String getMaximum() {
            return maximum;
        }

        public final void setMaximum(String maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(String maximum) {
            this.maximum = maximum;
            return this;
        }

        public final List<CollectiveConstantEntry.Builder> getValueList() {
            List<CollectiveConstantEntry.Builder> result = CollectiveConstantEntryListCopier.copyToBuilder(this.valueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValueList(Collection<CollectiveConstantEntry.BuilderImpl> valueList) {
            this.valueList = CollectiveConstantEntryListCopier.copyFromBuilder(valueList);
        }

        @Override
        public final Builder valueList(Collection<CollectiveConstantEntry> valueList) {
            this.valueList = CollectiveConstantEntryListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(CollectiveConstantEntry... valueList) {
            valueList(Arrays.asList(valueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(Consumer<CollectiveConstantEntry.Builder>... valueList) {
            valueList(Stream.of(valueList).map(c -> CollectiveConstantEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TopicConstantValue build() {
            return new TopicConstantValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
