/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the layout a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIVisualLayoutOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<KPIVisualLayoutOptions.Builder, KPIVisualLayoutOptions> {
    private static final SdkField<KPIVisualStandardLayout> STANDARD_LAYOUT_FIELD = SdkField
            .<KPIVisualStandardLayout> builder(MarshallingType.SDK_POJO).memberName("StandardLayout")
            .getter(getter(KPIVisualLayoutOptions::standardLayout)).setter(setter(Builder::standardLayout))
            .constructor(KPIVisualStandardLayout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardLayout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_LAYOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final KPIVisualStandardLayout standardLayout;

    private KPIVisualLayoutOptions(BuilderImpl builder) {
        this.standardLayout = builder.standardLayout;
    }

    /**
     * <p>
     * The standard layout of the KPI visual.
     * </p>
     * 
     * @return The standard layout of the KPI visual.
     */
    public final KPIVisualStandardLayout standardLayout() {
        return standardLayout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardLayout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIVisualLayoutOptions)) {
            return false;
        }
        KPIVisualLayoutOptions other = (KPIVisualLayoutOptions) obj;
        return Objects.equals(standardLayout(), other.standardLayout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIVisualLayoutOptions").add("StandardLayout", standardLayout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardLayout":
            return Optional.ofNullable(clazz.cast(standardLayout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KPIVisualLayoutOptions, T> g) {
        return obj -> g.apply((KPIVisualLayoutOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIVisualLayoutOptions> {
        /**
         * <p>
         * The standard layout of the KPI visual.
         * </p>
         * 
         * @param standardLayout
         *        The standard layout of the KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardLayout(KPIVisualStandardLayout standardLayout);

        /**
         * <p>
         * The standard layout of the KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPIVisualStandardLayout.Builder} avoiding
         * the need to create one manually via {@link KPIVisualStandardLayout#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIVisualStandardLayout.Builder#build()} is called immediately
         * and its result is passed to {@link #standardLayout(KPIVisualStandardLayout)}.
         * 
         * @param standardLayout
         *        a consumer that will call methods on {@link KPIVisualStandardLayout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardLayout(KPIVisualStandardLayout)
         */
        default Builder standardLayout(Consumer<KPIVisualStandardLayout.Builder> standardLayout) {
            return standardLayout(KPIVisualStandardLayout.builder().applyMutation(standardLayout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KPIVisualStandardLayout standardLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIVisualLayoutOptions model) {
            standardLayout(model.standardLayout);
        }

        public final KPIVisualStandardLayout.Builder getStandardLayout() {
            return standardLayout != null ? standardLayout.toBuilder() : null;
        }

        public final void setStandardLayout(KPIVisualStandardLayout.BuilderImpl standardLayout) {
            this.standardLayout = standardLayout != null ? standardLayout.build() : null;
        }

        @Override
        public final Builder standardLayout(KPIVisualStandardLayout standardLayout) {
            this.standardLayout = standardLayout;
            return this;
        }

        @Override
        public KPIVisualLayoutOptions build() {
            return new KPIVisualLayoutOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
