/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.LabelOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AxisTickLabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AxisTickLabelOptions> {
    private static final SdkField<LabelOptions> LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelOptions").getter(AxisTickLabelOptions.getter(AxisTickLabelOptions::labelOptions)).setter(AxisTickLabelOptions.setter(Builder::labelOptions)).constructor(LabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelOptions").build()}).build();
    private static final SdkField<Double> ROTATION_ANGLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("RotationAngle").getter(AxisTickLabelOptions.getter(AxisTickLabelOptions::rotationAngle)).setter(AxisTickLabelOptions.setter(Builder::rotationAngle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationAngle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_OPTIONS_FIELD, ROTATION_ANGLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final LabelOptions labelOptions;
    private final Double rotationAngle;

    private AxisTickLabelOptions(BuilderImpl builder) {
        this.labelOptions = builder.labelOptions;
        this.rotationAngle = builder.rotationAngle;
    }

    public final LabelOptions labelOptions() {
        return this.labelOptions;
    }

    public final Double rotationAngle() {
        return this.rotationAngle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationAngle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisTickLabelOptions)) {
            return false;
        }
        AxisTickLabelOptions other = (AxisTickLabelOptions)obj;
        return Objects.equals(this.labelOptions(), other.labelOptions()) && Objects.equals(this.rotationAngle(), other.rotationAngle());
    }

    public final String toString() {
        return ToString.builder((String)"AxisTickLabelOptions").add("LabelOptions", (Object)this.labelOptions()).add("RotationAngle", (Object)this.rotationAngle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelOptions": {
                return Optional.ofNullable(clazz.cast(this.labelOptions()));
            }
            case "RotationAngle": {
                return Optional.ofNullable(clazz.cast(this.rotationAngle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AxisTickLabelOptions, T> g) {
        return obj -> g.apply((AxisTickLabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LabelOptions labelOptions;
        private Double rotationAngle;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisTickLabelOptions model) {
            this.labelOptions(model.labelOptions);
            this.rotationAngle(model.rotationAngle);
        }

        public final LabelOptions.Builder getLabelOptions() {
            return this.labelOptions != null ? this.labelOptions.toBuilder() : null;
        }

        public final void setLabelOptions(LabelOptions.BuilderImpl labelOptions) {
            this.labelOptions = labelOptions != null ? labelOptions.build() : null;
        }

        @Override
        public final Builder labelOptions(LabelOptions labelOptions) {
            this.labelOptions = labelOptions;
            return this;
        }

        public final Double getRotationAngle() {
            return this.rotationAngle;
        }

        public final void setRotationAngle(Double rotationAngle) {
            this.rotationAngle = rotationAngle;
        }

        @Override
        public final Builder rotationAngle(Double rotationAngle) {
            this.rotationAngle = rotationAngle;
            return this;
        }

        public AxisTickLabelOptions build() {
            return new AxisTickLabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AxisTickLabelOptions> {
        public Builder labelOptions(LabelOptions var1);

        default public Builder labelOptions(Consumer<LabelOptions.Builder> labelOptions) {
            return this.labelOptions((LabelOptions)((LabelOptions.Builder)LabelOptions.builder().applyMutation(labelOptions)).build());
        }

        public Builder rotationAngle(Double var1);
    }
}

