/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the dashboard that you want to embed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserDashboardEmbeddingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnonymousUserDashboardEmbeddingConfiguration.Builder, AnonymousUserDashboardEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialDashboardId").getter(getter(AnonymousUserDashboardEmbeddingConfiguration::initialDashboardId))
            .setter(setter(Builder::initialDashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialDashboardId").build())
            .build();

    private static final SdkField<List<String>> ENABLED_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledFeatures")
            .getter(getter(AnonymousUserDashboardEmbeddingConfiguration::enabledFeaturesAsStrings))
            .setter(setter(Builder::enabledFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISABLED_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DisabledFeatures")
            .getter(getter(AnonymousUserDashboardEmbeddingConfiguration::disabledFeaturesAsStrings))
            .setter(setter(Builder::disabledFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AnonymousUserDashboardFeatureConfigurations> FEATURE_CONFIGURATIONS_FIELD = SdkField
            .<AnonymousUserDashboardFeatureConfigurations> builder(MarshallingType.SDK_POJO).memberName("FeatureConfigurations")
            .getter(getter(AnonymousUserDashboardEmbeddingConfiguration::featureConfigurations))
            .setter(setter(Builder::featureConfigurations)).constructor(AnonymousUserDashboardFeatureConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_DASHBOARD_ID_FIELD,
            ENABLED_FEATURES_FIELD, DISABLED_FEATURES_FIELD, FEATURE_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String initialDashboardId;

    private final List<String> enabledFeatures;

    private final List<String> disabledFeatures;

    private final AnonymousUserDashboardFeatureConfigurations featureConfigurations;

    private AnonymousUserDashboardEmbeddingConfiguration(BuilderImpl builder) {
        this.initialDashboardId = builder.initialDashboardId;
        this.enabledFeatures = builder.enabledFeatures;
        this.disabledFeatures = builder.disabledFeatures;
        this.featureConfigurations = builder.featureConfigurations;
    }

    /**
     * <p>
     * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL.
     * When the URL in response is accessed, Amazon QuickSight renders this dashboard.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code>
     * parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.
     * </p>
     * 
     * @return The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output
     *         URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p>
     *         <p>
     *         The Amazon Resource Name (ARN) of this dashboard must be included in the
     *         <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     *         <code>InvalidParameterValueException</code>.
     */
    public final String initialDashboardId() {
        return initialDashboardId;
    }

    /**
     * <p>
     * A list of all enabled features of a specified anonymous dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledFeatures} method.
     * </p>
     * 
     * @return A list of all enabled features of a specified anonymous dashboard.
     */
    public final List<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature> enabledFeatures() {
        return AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copyStringToEnum(enabledFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledFeatures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledFeatures() {
        return enabledFeatures != null && !(enabledFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all enabled features of a specified anonymous dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledFeatures} method.
     * </p>
     * 
     * @return A list of all enabled features of a specified anonymous dashboard.
     */
    public final List<String> enabledFeaturesAsStrings() {
        return enabledFeatures;
    }

    /**
     * <p>
     * A list of all disabled features of a specified anonymous dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisabledFeatures} method.
     * </p>
     * 
     * @return A list of all disabled features of a specified anonymous dashboard.
     */
    public final List<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature> disabledFeatures() {
        return AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copyStringToEnum(disabledFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the DisabledFeatures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisabledFeatures() {
        return disabledFeatures != null && !(disabledFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all disabled features of a specified anonymous dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisabledFeatures} method.
     * </p>
     * 
     * @return A list of all disabled features of a specified anonymous dashboard.
     */
    public final List<String> disabledFeaturesAsStrings() {
        return disabledFeatures;
    }

    /**
     * <p>
     * The feature configuration for an embedded dashboard.
     * </p>
     * 
     * @return The feature configuration for an embedded dashboard.
     */
    public final AnonymousUserDashboardFeatureConfigurations featureConfigurations() {
        return featureConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialDashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledFeatures() ? enabledFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisabledFeatures() ? disabledFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(featureConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserDashboardEmbeddingConfiguration)) {
            return false;
        }
        AnonymousUserDashboardEmbeddingConfiguration other = (AnonymousUserDashboardEmbeddingConfiguration) obj;
        return Objects.equals(initialDashboardId(), other.initialDashboardId())
                && hasEnabledFeatures() == other.hasEnabledFeatures()
                && Objects.equals(enabledFeaturesAsStrings(), other.enabledFeaturesAsStrings())
                && hasDisabledFeatures() == other.hasDisabledFeatures()
                && Objects.equals(disabledFeaturesAsStrings(), other.disabledFeaturesAsStrings())
                && Objects.equals(featureConfigurations(), other.featureConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserDashboardEmbeddingConfiguration").add("InitialDashboardId", initialDashboardId())
                .add("EnabledFeatures", hasEnabledFeatures() ? enabledFeaturesAsStrings() : null)
                .add("DisabledFeatures", hasDisabledFeatures() ? disabledFeaturesAsStrings() : null)
                .add("FeatureConfigurations", featureConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialDashboardId":
            return Optional.ofNullable(clazz.cast(initialDashboardId()));
        case "EnabledFeatures":
            return Optional.ofNullable(clazz.cast(enabledFeaturesAsStrings()));
        case "DisabledFeatures":
            return Optional.ofNullable(clazz.cast(disabledFeaturesAsStrings()));
        case "FeatureConfigurations":
            return Optional.ofNullable(clazz.cast(featureConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserDashboardEmbeddingConfiguration, T> g) {
        return obj -> g.apply((AnonymousUserDashboardEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserDashboardEmbeddingConfiguration> {
        /**
         * <p>
         * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output
         * URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.
         * </p>
         * <p>
         * The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code>
         * parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.
         * </p>
         * 
         * @param initialDashboardId
         *        The dashboard ID for the dashboard that you want the user to see first. This ID is included in the
         *        output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p>
         *        <p>
         *        The Amazon Resource Name (ARN) of this dashboard must be included in the
         *        <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
         *        <code>InvalidParameterValueException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialDashboardId(String initialDashboardId);

        /**
         * <p>
         * A list of all enabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param enabledFeatures
         *        A list of all enabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeaturesWithStrings(Collection<String> enabledFeatures);

        /**
         * <p>
         * A list of all enabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param enabledFeatures
         *        A list of all enabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeaturesWithStrings(String... enabledFeatures);

        /**
         * <p>
         * A list of all enabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param enabledFeatures
         *        A list of all enabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeatures(Collection<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature> enabledFeatures);

        /**
         * <p>
         * A list of all enabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param enabledFeatures
         *        A list of all enabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledFeatures(AnonymousUserDashboardEmbeddingConfigurationEnabledFeature... enabledFeatures);

        /**
         * <p>
         * A list of all disabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param disabledFeatures
         *        A list of all disabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledFeaturesWithStrings(Collection<String> disabledFeatures);

        /**
         * <p>
         * A list of all disabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param disabledFeatures
         *        A list of all disabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledFeaturesWithStrings(String... disabledFeatures);

        /**
         * <p>
         * A list of all disabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param disabledFeatures
         *        A list of all disabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledFeatures(Collection<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature> disabledFeatures);

        /**
         * <p>
         * A list of all disabled features of a specified anonymous dashboard.
         * </p>
         * 
         * @param disabledFeatures
         *        A list of all disabled features of a specified anonymous dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledFeatures(AnonymousUserDashboardEmbeddingConfigurationDisabledFeature... disabledFeatures);

        /**
         * <p>
         * The feature configuration for an embedded dashboard.
         * </p>
         * 
         * @param featureConfigurations
         *        The feature configuration for an embedded dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureConfigurations(AnonymousUserDashboardFeatureConfigurations featureConfigurations);

        /**
         * <p>
         * The feature configuration for an embedded dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnonymousUserDashboardFeatureConfigurations.Builder} avoiding the need to create one manually via
         * {@link AnonymousUserDashboardFeatureConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnonymousUserDashboardFeatureConfigurations.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #featureConfigurations(AnonymousUserDashboardFeatureConfigurations)}.
         * 
         * @param featureConfigurations
         *        a consumer that will call methods on {@link AnonymousUserDashboardFeatureConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureConfigurations(AnonymousUserDashboardFeatureConfigurations)
         */
        default Builder featureConfigurations(Consumer<AnonymousUserDashboardFeatureConfigurations.Builder> featureConfigurations) {
            return featureConfigurations(AnonymousUserDashboardFeatureConfigurations.builder()
                    .applyMutation(featureConfigurations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String initialDashboardId;

        private List<String> enabledFeatures = DefaultSdkAutoConstructList.getInstance();

        private List<String> disabledFeatures = DefaultSdkAutoConstructList.getInstance();

        private AnonymousUserDashboardFeatureConfigurations featureConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserDashboardEmbeddingConfiguration model) {
            initialDashboardId(model.initialDashboardId);
            enabledFeaturesWithStrings(model.enabledFeatures);
            disabledFeaturesWithStrings(model.disabledFeatures);
            featureConfigurations(model.featureConfigurations);
        }

        public final String getInitialDashboardId() {
            return initialDashboardId;
        }

        public final void setInitialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
        }

        @Override
        public final Builder initialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
            return this;
        }

        public final Collection<String> getEnabledFeatures() {
            if (enabledFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledFeatures;
        }

        public final void setEnabledFeatures(Collection<String> enabledFeatures) {
            this.enabledFeatures = AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copy(enabledFeatures);
        }

        @Override
        public final Builder enabledFeaturesWithStrings(Collection<String> enabledFeatures) {
            this.enabledFeatures = AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copy(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeaturesWithStrings(String... enabledFeatures) {
            enabledFeaturesWithStrings(Arrays.asList(enabledFeatures));
            return this;
        }

        @Override
        public final Builder enabledFeatures(
                Collection<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature> enabledFeatures) {
            this.enabledFeatures = AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier
                    .copyEnumToString(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeatures(AnonymousUserDashboardEmbeddingConfigurationEnabledFeature... enabledFeatures) {
            enabledFeatures(Arrays.asList(enabledFeatures));
            return this;
        }

        public final Collection<String> getDisabledFeatures() {
            if (disabledFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return disabledFeatures;
        }

        public final void setDisabledFeatures(Collection<String> disabledFeatures) {
            this.disabledFeatures = AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copy(disabledFeatures);
        }

        @Override
        public final Builder disabledFeaturesWithStrings(Collection<String> disabledFeatures) {
            this.disabledFeatures = AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copy(disabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disabledFeaturesWithStrings(String... disabledFeatures) {
            disabledFeaturesWithStrings(Arrays.asList(disabledFeatures));
            return this;
        }

        @Override
        public final Builder disabledFeatures(
                Collection<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature> disabledFeatures) {
            this.disabledFeatures = AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier
                    .copyEnumToString(disabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disabledFeatures(AnonymousUserDashboardEmbeddingConfigurationDisabledFeature... disabledFeatures) {
            disabledFeatures(Arrays.asList(disabledFeatures));
            return this;
        }

        public final AnonymousUserDashboardFeatureConfigurations.Builder getFeatureConfigurations() {
            return featureConfigurations != null ? featureConfigurations.toBuilder() : null;
        }

        public final void setFeatureConfigurations(AnonymousUserDashboardFeatureConfigurations.BuilderImpl featureConfigurations) {
            this.featureConfigurations = featureConfigurations != null ? featureConfigurations.build() : null;
        }

        @Override
        public final Builder featureConfigurations(AnonymousUserDashboardFeatureConfigurations featureConfigurations) {
            this.featureConfigurations = featureConfigurations;
            return this;
        }

        @Override
        public AnonymousUserDashboardEmbeddingConfiguration build() {
            return new AnonymousUserDashboardEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
