/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTopicRefreshScheduleResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeTopicRefreshScheduleResponse.Builder, DescribeTopicRefreshScheduleResponse> {
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(DescribeTopicRefreshScheduleResponse::topicId)).setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(DescribeTopicRefreshScheduleResponse::topicArn))
            .setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeTopicRefreshScheduleResponse::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<TopicRefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<TopicRefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(DescribeTopicRefreshScheduleResponse::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(TopicRefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeTopicRefreshScheduleResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeTopicRefreshScheduleResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ID_FIELD,
            TOPIC_ARN_FIELD, DATASET_ARN_FIELD, REFRESH_SCHEDULE_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final String topicId;

    private final String topicArn;

    private final String datasetArn;

    private final TopicRefreshSchedule refreshSchedule;

    private final Integer status;

    private final String requestId;

    private DescribeTopicRefreshScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.topicId = builder.topicId;
        this.topicArn = builder.topicArn;
        this.datasetArn = builder.datasetArn;
        this.refreshSchedule = builder.refreshSchedule;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID of the topic that contains the refresh schedule that you want to describe. This ID is unique per Amazon
     * Web Services Region for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the topic that contains the refresh schedule that you want to describe. This ID is unique per
     *         Amazon Web Services Region for each Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the topic.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The definition of a refresh schedule.
     * </p>
     * 
     * @return The definition of a refresh schedule.
     */
    public final TopicRefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTopicRefreshScheduleResponse)) {
            return false;
        }
        DescribeTopicRefreshScheduleResponse other = (DescribeTopicRefreshScheduleResponse) obj;
        return Objects.equals(topicId(), other.topicId()) && Objects.equals(topicArn(), other.topicArn())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(refreshSchedule(), other.refreshSchedule())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTopicRefreshScheduleResponse").add("TopicId", topicId()).add("TopicArn", topicArn())
                .add("DatasetArn", datasetArn()).add("RefreshSchedule", refreshSchedule()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTopicRefreshScheduleResponse, T> g) {
        return obj -> g.apply((DescribeTopicRefreshScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTopicRefreshScheduleResponse> {
        /**
         * <p>
         * The ID of the topic that contains the refresh schedule that you want to describe. This ID is unique per
         * Amazon Web Services Region for each Amazon Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID of the topic that contains the refresh schedule that you want to describe. This ID is unique
         *        per Amazon Web Services Region for each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the topic.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The definition of a refresh schedule.
         * </p>
         * 
         * @param refreshSchedule
         *        The definition of a refresh schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(TopicRefreshSchedule refreshSchedule);

        /**
         * <p>
         * The definition of a refresh schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRefreshSchedule.Builder} avoiding
         * the need to create one manually via {@link TopicRefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRefreshSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #refreshSchedule(TopicRefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link TopicRefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(TopicRefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<TopicRefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(TopicRefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String topicId;

        private String topicArn;

        private String datasetArn;

        private TopicRefreshSchedule refreshSchedule;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTopicRefreshScheduleResponse model) {
            super(model);
            topicId(model.topicId);
            topicArn(model.topicArn);
            datasetArn(model.datasetArn);
            refreshSchedule(model.refreshSchedule);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final TopicRefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(TopicRefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(TopicRefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeTopicRefreshScheduleResponse build() {
            return new DescribeTopicRefreshScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
