/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the query execution options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryExecutionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryExecutionOptions.Builder, QueryExecutionOptions> {
    private static final SdkField<String> QUERY_EXECUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryExecutionMode").getter(getter(QueryExecutionOptions::queryExecutionModeAsString))
            .setter(setter(Builder::queryExecutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queryExecutionMode;

    private QueryExecutionOptions(BuilderImpl builder) {
        this.queryExecutionMode = builder.queryExecutionMode;
    }

    /**
     * <p>
     * A structure that describes the query execution mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryExecutionMode} will return {@link QueryExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #queryExecutionModeAsString}.
     * </p>
     * 
     * @return A structure that describes the query execution mode.
     * @see QueryExecutionMode
     */
    public final QueryExecutionMode queryExecutionMode() {
        return QueryExecutionMode.fromValue(queryExecutionMode);
    }

    /**
     * <p>
     * A structure that describes the query execution mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryExecutionMode} will return {@link QueryExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #queryExecutionModeAsString}.
     * </p>
     * 
     * @return A structure that describes the query execution mode.
     * @see QueryExecutionMode
     */
    public final String queryExecutionModeAsString() {
        return queryExecutionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryExecutionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionOptions)) {
            return false;
        }
        QueryExecutionOptions other = (QueryExecutionOptions) obj;
        return Objects.equals(queryExecutionModeAsString(), other.queryExecutionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryExecutionOptions").add("QueryExecutionMode", queryExecutionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryExecutionMode":
            return Optional.ofNullable(clazz.cast(queryExecutionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionOptions, T> g) {
        return obj -> g.apply((QueryExecutionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryExecutionOptions> {
        /**
         * <p>
         * A structure that describes the query execution mode.
         * </p>
         * 
         * @param queryExecutionMode
         *        A structure that describes the query execution mode.
         * @see QueryExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryExecutionMode
         */
        Builder queryExecutionMode(String queryExecutionMode);

        /**
         * <p>
         * A structure that describes the query execution mode.
         * </p>
         * 
         * @param queryExecutionMode
         *        A structure that describes the query execution mode.
         * @see QueryExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryExecutionMode
         */
        Builder queryExecutionMode(QueryExecutionMode queryExecutionMode);
    }

    static final class BuilderImpl implements Builder {
        private String queryExecutionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionOptions model) {
            queryExecutionMode(model.queryExecutionMode);
        }

        public final String getQueryExecutionMode() {
            return queryExecutionMode;
        }

        public final void setQueryExecutionMode(String queryExecutionMode) {
            this.queryExecutionMode = queryExecutionMode;
        }

        @Override
        public final Builder queryExecutionMode(String queryExecutionMode) {
            this.queryExecutionMode = queryExecutionMode;
            return this;
        }

        @Override
        public final Builder queryExecutionMode(QueryExecutionMode queryExecutionMode) {
            this.queryExecutionMode(queryExecutionMode == null ? null : queryExecutionMode.toString());
            return this;
        }

        @Override
        public QueryExecutionOptions build() {
            return new QueryExecutionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
