/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for the slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Slot implements SdkPojo, Serializable, ToCopyableBuilder<Slot.Builder, Slot> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SlotId")
            .getter(getter(Slot::slotId)).setter(setter(Builder::slotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotId").build()).build();

    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(Slot::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SLOT_ID_FIELD, VISUAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String slotId;

    private final String visualId;

    private Slot(BuilderImpl builder) {
        this.slotId = builder.slotId;
        this.visualId = builder.visualId;
    }

    /**
     * <p>
     * The slot ID of the slot.
     * </p>
     * 
     * @return The slot ID of the slot.
     */
    public final String slotId() {
        return slotId;
    }

    /**
     * <p>
     * The visual ID for the slot.
     * </p>
     * 
     * @return The visual ID for the slot.
     */
    public final String visualId() {
        return visualId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotId());
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot) obj;
        return Objects.equals(slotId(), other.slotId()) && Objects.equals(visualId(), other.visualId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Slot").add("SlotId", slotId()).add("VisualId", visualId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlotId":
            return Optional.ofNullable(clazz.cast(slotId()));
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Slot, T> g) {
        return obj -> g.apply((Slot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Slot> {
        /**
         * <p>
         * The slot ID of the slot.
         * </p>
         * 
         * @param slotId
         *        The slot ID of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotId(String slotId);

        /**
         * <p>
         * The visual ID for the slot.
         * </p>
         * 
         * @param visualId
         *        The visual ID for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);
    }

    static final class BuilderImpl implements Builder {
        private String slotId;

        private String visualId;

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            slotId(model.slotId);
            visualId(model.visualId);
        }

        public final String getSlotId() {
            return slotId;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        @Override
        public Slot build() {
            return new Slot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
