/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicSortClause</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicSortClause implements SdkPojo, Serializable, ToCopyableBuilder<TopicSortClause.Builder, TopicSortClause> {
    private static final SdkField<Identifier> OPERAND_FIELD = SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
            .memberName("Operand").getter(getter(TopicSortClause::operand)).setter(setter(Builder::operand))
            .constructor(Identifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operand").build()).build();

    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortDirection").getter(getter(TopicSortClause::sortDirectionAsString))
            .setter(setter(Builder::sortDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERAND_FIELD,
            SORT_DIRECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identifier operand;

    private final String sortDirection;

    private TopicSortClause(BuilderImpl builder) {
        this.operand = builder.operand;
        this.sortDirection = builder.sortDirection;
    }

    /**
     * <p>
     * The operand for a <code>TopicSortClause</code>.
     * </p>
     * 
     * @return The operand for a <code>TopicSortClause</code>.
     */
    public final Identifier operand() {
        return operand;
    }

    /**
     * <p>
     * The sort direction for the <code>TopicSortClause</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link TopicSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction for the <code>TopicSortClause</code>.
     * @see TopicSortDirection
     */
    public final TopicSortDirection sortDirection() {
        return TopicSortDirection.fromValue(sortDirection);
    }

    /**
     * <p>
     * The sort direction for the <code>TopicSortClause</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link TopicSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction for the <code>TopicSortClause</code>.
     * @see TopicSortDirection
     */
    public final String sortDirectionAsString() {
        return sortDirection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operand());
        hashCode = 31 * hashCode + Objects.hashCode(sortDirectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicSortClause)) {
            return false;
        }
        TopicSortClause other = (TopicSortClause) obj;
        return Objects.equals(operand(), other.operand())
                && Objects.equals(sortDirectionAsString(), other.sortDirectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicSortClause").add("Operand", operand()).add("SortDirection", sortDirectionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operand":
            return Optional.ofNullable(clazz.cast(operand()));
        case "SortDirection":
            return Optional.ofNullable(clazz.cast(sortDirectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicSortClause, T> g) {
        return obj -> g.apply((TopicSortClause) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicSortClause> {
        /**
         * <p>
         * The operand for a <code>TopicSortClause</code>.
         * </p>
         * 
         * @param operand
         *        The operand for a <code>TopicSortClause</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operand(Identifier operand);

        /**
         * <p>
         * The operand for a <code>TopicSortClause</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identifier.Builder} avoiding the need to
         * create one manually via {@link Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identifier.Builder#build()} is called immediately and its result
         * is passed to {@link #operand(Identifier)}.
         * 
         * @param operand
         *        a consumer that will call methods on {@link Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operand(Identifier)
         */
        default Builder operand(Consumer<Identifier.Builder> operand) {
            return operand(Identifier.builder().applyMutation(operand).build());
        }

        /**
         * <p>
         * The sort direction for the <code>TopicSortClause</code>.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction for the <code>TopicSortClause</code>.
         * @see TopicSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicSortDirection
         */
        Builder sortDirection(String sortDirection);

        /**
         * <p>
         * The sort direction for the <code>TopicSortClause</code>.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction for the <code>TopicSortClause</code>.
         * @see TopicSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicSortDirection
         */
        Builder sortDirection(TopicSortDirection sortDirection);
    }

    static final class BuilderImpl implements Builder {
        private Identifier operand;

        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicSortClause model) {
            operand(model.operand);
            sortDirection(model.sortDirection);
        }

        public final Identifier.Builder getOperand() {
            return operand != null ? operand.toBuilder() : null;
        }

        public final void setOperand(Identifier.BuilderImpl operand) {
            this.operand = operand != null ? operand.build() : null;
        }

        @Override
        public final Builder operand(Identifier operand) {
            this.operand = operand;
            return this;
        }

        public final String getSortDirection() {
            return sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(TopicSortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        @Override
        public TopicSortClause build() {
            return new TopicSortClause(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
