/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumericRangeFilterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NumericRangeFilterValue> {
    private static final SdkField<Double> STATIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StaticValue").getter(NumericRangeFilterValue.getter(NumericRangeFilterValue::staticValue)).setter(NumericRangeFilterValue.setter(Builder::staticValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValue").build()}).build();
    private static final SdkField<String> PARAMETER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Parameter").getter(NumericRangeFilterValue.getter(NumericRangeFilterValue::parameter)).setter(NumericRangeFilterValue.setter(Builder::parameter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUE_FIELD, PARAMETER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double staticValue;
    private final String parameter;

    private NumericRangeFilterValue(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.parameter = builder.parameter;
    }

    public final Double staticValue() {
        return this.staticValue;
    }

    public final String parameter() {
        return this.parameter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericRangeFilterValue)) {
            return false;
        }
        NumericRangeFilterValue other = (NumericRangeFilterValue)obj;
        return Objects.equals(this.staticValue(), other.staticValue()) && Objects.equals(this.parameter(), other.parameter());
    }

    public final String toString() {
        return ToString.builder((String)"NumericRangeFilterValue").add("StaticValue", (Object)this.staticValue()).add("Parameter", (Object)this.parameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticValue": {
                return Optional.ofNullable(clazz.cast(this.staticValue()));
            }
            case "Parameter": {
                return Optional.ofNullable(clazz.cast(this.parameter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericRangeFilterValue, T> g) {
        return obj -> g.apply((NumericRangeFilterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double staticValue;
        private String parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericRangeFilterValue model) {
            this.staticValue(model.staticValue);
            this.parameter(model.parameter);
        }

        public final Double getStaticValue() {
            return this.staticValue;
        }

        public final void setStaticValue(Double staticValue) {
            this.staticValue = staticValue;
        }

        @Override
        public final Builder staticValue(Double staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        public final String getParameter() {
            return this.parameter;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public NumericRangeFilterValue build() {
            return new NumericRangeFilterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NumericRangeFilterValue> {
        public Builder staticValue(Double var1);

        public Builder parameter(String var1);
    }
}

