/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterConfiguration;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DefaultFilterControlConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CategoryInnerFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CategoryInnerFilter> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(CategoryInnerFilter.getter(CategoryInnerFilter::column)).setter(CategoryInnerFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<CategoryFilterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(CategoryInnerFilter.getter(CategoryInnerFilter::configuration)).setter(CategoryInnerFilter.setter(Builder::configuration)).constructor(CategoryFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultFilterControlConfiguration").getter(CategoryInnerFilter.getter(CategoryInnerFilter::defaultFilterControlConfiguration)).setter(CategoryInnerFilter.setter(Builder::defaultFilterControlConfiguration)).constructor(DefaultFilterControlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, CONFIGURATION_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final CategoryFilterConfiguration configuration;
    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private CategoryInnerFilter(BuilderImpl builder) {
        this.column = builder.column;
        this.configuration = builder.configuration;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final CategoryFilterConfiguration configuration() {
        return this.configuration;
    }

    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return this.defaultFilterControlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFilterControlConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryInnerFilter)) {
            return false;
        }
        CategoryInnerFilter other = (CategoryInnerFilter)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CategoryInnerFilter").add("Column", (Object)this.column()).add("Configuration", (Object)this.configuration()).add("DefaultFilterControlConfiguration", (Object)this.defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "DefaultFilterControlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultFilterControlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryInnerFilter, T> g) {
        return obj -> g.apply((CategoryInnerFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private CategoryFilterConfiguration configuration;
        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryInnerFilter model) {
            this.column(model.column);
            this.configuration(model.configuration);
            this.defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final CategoryFilterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CategoryFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CategoryFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return this.defaultFilterControlConfiguration != null ? this.defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        public CategoryInnerFilter build() {
            return new CategoryInnerFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CategoryInnerFilter> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder configuration(CategoryFilterConfiguration var1);

        default public Builder configuration(Consumer<CategoryFilterConfiguration.Builder> configuration) {
            return this.configuration((CategoryFilterConfiguration)((CategoryFilterConfiguration.Builder)CategoryFilterConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration var1);

        default public Builder defaultFilterControlConfiguration(Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return this.defaultFilterControlConfiguration((DefaultFilterControlConfiguration)((DefaultFilterControlConfiguration.Builder)DefaultFilterControlConfiguration.builder().applyMutation(defaultFilterControlConfiguration)).build());
        }
    }
}

