/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the override tag configuration that modify the tags that are assigned to specified
 * resources before the resource is imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobOverrideTags implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobOverrideTags.Builder, AssetBundleImportJobOverrideTags> {
    private static final SdkField<List<AssetBundleImportJobVPCConnectionOverrideTags>> VPC_CONNECTIONS_FIELD = SdkField
            .<List<AssetBundleImportJobVPCConnectionOverrideTags>> builder(MarshallingType.LIST)
            .memberName("VPCConnections")
            .getter(getter(AssetBundleImportJobOverrideTags::vpcConnections))
            .setter(setter(Builder::vpcConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobVPCConnectionOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobVPCConnectionOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDataSourceOverrideTags>> DATA_SOURCES_FIELD = SdkField
            .<List<AssetBundleImportJobDataSourceOverrideTags>> builder(MarshallingType.LIST)
            .memberName("DataSources")
            .getter(getter(AssetBundleImportJobOverrideTags::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDataSourceOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDataSourceOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDataSetOverrideTags>> DATA_SETS_FIELD = SdkField
            .<List<AssetBundleImportJobDataSetOverrideTags>> builder(MarshallingType.LIST)
            .memberName("DataSets")
            .getter(getter(AssetBundleImportJobOverrideTags::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDataSetOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDataSetOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobThemeOverrideTags>> THEMES_FIELD = SdkField
            .<List<AssetBundleImportJobThemeOverrideTags>> builder(MarshallingType.LIST)
            .memberName("Themes")
            .getter(getter(AssetBundleImportJobOverrideTags::themes))
            .setter(setter(Builder::themes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Themes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobThemeOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobThemeOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobAnalysisOverrideTags>> ANALYSES_FIELD = SdkField
            .<List<AssetBundleImportJobAnalysisOverrideTags>> builder(MarshallingType.LIST)
            .memberName("Analyses")
            .getter(getter(AssetBundleImportJobOverrideTags::analyses))
            .setter(setter(Builder::analyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobAnalysisOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobAnalysisOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDashboardOverrideTags>> DASHBOARDS_FIELD = SdkField
            .<List<AssetBundleImportJobDashboardOverrideTags>> builder(MarshallingType.LIST)
            .memberName("Dashboards")
            .getter(getter(AssetBundleImportJobOverrideTags::dashboards))
            .setter(setter(Builder::dashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDashboardOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDashboardOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobFolderOverrideTags>> FOLDERS_FIELD = SdkField
            .<List<AssetBundleImportJobFolderOverrideTags>> builder(MarshallingType.LIST)
            .memberName("Folders")
            .getter(getter(AssetBundleImportJobOverrideTags::folders))
            .setter(setter(Builder::folders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobFolderOverrideTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobFolderOverrideTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTIONS_FIELD,
            DATA_SOURCES_FIELD, DATA_SETS_FIELD, THEMES_FIELD, ANALYSES_FIELD, DASHBOARDS_FIELD, FOLDERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AssetBundleImportJobVPCConnectionOverrideTags> vpcConnections;

    private final List<AssetBundleImportJobDataSourceOverrideTags> dataSources;

    private final List<AssetBundleImportJobDataSetOverrideTags> dataSets;

    private final List<AssetBundleImportJobThemeOverrideTags> themes;

    private final List<AssetBundleImportJobAnalysisOverrideTags> analyses;

    private final List<AssetBundleImportJobDashboardOverrideTags> dashboards;

    private final List<AssetBundleImportJobFolderOverrideTags> folders;

    private AssetBundleImportJobOverrideTags(BuilderImpl builder) {
        this.vpcConnections = builder.vpcConnections;
        this.dataSources = builder.dataSources;
        this.dataSets = builder.dataSets;
        this.themes = builder.themes;
        this.analyses = builder.analyses;
        this.dashboards = builder.dashboards;
        this.folders = builder.folders;
    }

    /**
     * For responses, this returns true if the service returned a value for the VPCConnections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcConnections() {
        return vpcConnections != null && !(vpcConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcConnections} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
     *         that is imported.
     */
    public final List<AssetBundleImportJobVPCConnectionOverrideTags> vpcConnections() {
        return vpcConnections;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle
     *         that is imported.
     */
    public final List<AssetBundleImportJobDataSourceOverrideTags> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle that
     *         is imported.
     */
    public final List<AssetBundleImportJobDataSetOverrideTags> dataSets() {
        return dataSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Themes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThemes() {
        return themes != null && !(themes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThemes} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that is
     *         imported.
     */
    public final List<AssetBundleImportJobThemeOverrideTags> themes() {
        return themes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Analyses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnalyses() {
        return analyses != null && !(analyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalyses} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle that
     *         is imported.
     */
    public final List<AssetBundleImportJobAnalysisOverrideTags> analyses() {
        return analyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dashboards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDashboards() {
        return dashboards != null && !(dashboards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboards} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle
     *         that is imported.
     */
    public final List<AssetBundleImportJobDashboardOverrideTags> dashboards() {
        return dashboards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Folders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolders() {
        return folders != null && !(folders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolders} method.
     * </p>
     * 
     * @return A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle that
     *         is imported.
     */
    public final List<AssetBundleImportJobFolderOverrideTags> folders() {
        return folders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConnections() ? vpcConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThemes() ? themes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalyses() ? analyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboards() ? dashboards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFolders() ? folders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobOverrideTags)) {
            return false;
        }
        AssetBundleImportJobOverrideTags other = (AssetBundleImportJobOverrideTags) obj;
        return hasVpcConnections() == other.hasVpcConnections() && Objects.equals(vpcConnections(), other.vpcConnections())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && hasDataSets() == other.hasDataSets() && Objects.equals(dataSets(), other.dataSets())
                && hasThemes() == other.hasThemes() && Objects.equals(themes(), other.themes())
                && hasAnalyses() == other.hasAnalyses() && Objects.equals(analyses(), other.analyses())
                && hasDashboards() == other.hasDashboards() && Objects.equals(dashboards(), other.dashboards())
                && hasFolders() == other.hasFolders() && Objects.equals(folders(), other.folders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobOverrideTags")
                .add("VPCConnections", hasVpcConnections() ? vpcConnections() : null)
                .add("DataSources", hasDataSources() ? dataSources() : null).add("DataSets", hasDataSets() ? dataSets() : null)
                .add("Themes", hasThemes() ? themes() : null).add("Analyses", hasAnalyses() ? analyses() : null)
                .add("Dashboards", hasDashboards() ? dashboards() : null).add("Folders", hasFolders() ? folders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VPCConnections":
            return Optional.ofNullable(clazz.cast(vpcConnections()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "DataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "Themes":
            return Optional.ofNullable(clazz.cast(themes()));
        case "Analyses":
            return Optional.ofNullable(clazz.cast(analyses()));
        case "Dashboards":
            return Optional.ofNullable(clazz.cast(dashboards()));
        case "Folders":
            return Optional.ofNullable(clazz.cast(folders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobOverrideTags, T> g) {
        return obj -> g.apply((AssetBundleImportJobOverrideTags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobOverrideTags> {
        /**
         * <p>
         * A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param vpcConnections
         *        A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnections(Collection<AssetBundleImportJobVPCConnectionOverrideTags> vpcConnections);

        /**
         * <p>
         * A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param vpcConnections
         *        A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnections(AssetBundleImportJobVPCConnectionOverrideTags... vpcConnections);

        /**
         * <p>
         * A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideTags#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vpcConnections(List<AssetBundleImportJobVPCConnectionOverrideTags>)}.
         * 
         * @param vpcConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobVPCConnectionOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnections(java.util.Collection<AssetBundleImportJobVPCConnectionOverrideTags>)
         */
        Builder vpcConnections(Consumer<AssetBundleImportJobVPCConnectionOverrideTags.Builder>... vpcConnections);

        /**
         * <p>
         * A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle that
         * is imported.
         * </p>
         * 
         * @param dataSources
         *        A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<AssetBundleImportJobDataSourceOverrideTags> dataSources);

        /**
         * <p>
         * A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle that
         * is imported.
         * </p>
         * 
         * @param dataSources
         *        A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(AssetBundleImportJobDataSourceOverrideTags... dataSources);

        /**
         * <p>
         * A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle that
         * is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideTags#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSources(List<AssetBundleImportJobDataSourceOverrideTags>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<AssetBundleImportJobDataSourceOverrideTags>)
         */
        Builder dataSources(Consumer<AssetBundleImportJobDataSourceOverrideTags.Builder>... dataSources);

        /**
         * <p>
         * A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dataSets
         *        A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<AssetBundleImportJobDataSetOverrideTags> dataSets);

        /**
         * <p>
         * A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dataSets
         *        A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(AssetBundleImportJobDataSetOverrideTags... dataSets);

        /**
         * <p>
         * A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSets(List<AssetBundleImportJobDataSetOverrideTags>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<AssetBundleImportJobDataSetOverrideTags>)
         */
        Builder dataSets(Consumer<AssetBundleImportJobDataSetOverrideTags.Builder>... dataSets);

        /**
         * <p>
         * A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param themes
         *        A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(Collection<AssetBundleImportJobThemeOverrideTags> themes);

        /**
         * <p>
         * A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param themes
         *        A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that
         *        is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(AssetBundleImportJobThemeOverrideTags... themes);

        /**
         * <p>
         * A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #themes(List<AssetBundleImportJobThemeOverrideTags>)}.
         * 
         * @param themes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themes(java.util.Collection<AssetBundleImportJobThemeOverrideTags>)
         */
        Builder themes(Consumer<AssetBundleImportJobThemeOverrideTags.Builder>... themes);

        /**
         * <p>
         * A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param analyses
         *        A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(Collection<AssetBundleImportJobAnalysisOverrideTags> analyses);

        /**
         * <p>
         * A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param analyses
         *        A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(AssetBundleImportJobAnalysisOverrideTags... analyses);

        /**
         * <p>
         * A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #analyses(List<AssetBundleImportJobAnalysisOverrideTags>)}.
         * 
         * @param analyses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyses(java.util.Collection<AssetBundleImportJobAnalysisOverrideTags>)
         */
        Builder analyses(Consumer<AssetBundleImportJobAnalysisOverrideTags.Builder>... analyses);

        /**
         * <p>
         * A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dashboards
         *        A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(Collection<AssetBundleImportJobDashboardOverrideTags> dashboards);

        /**
         * <p>
         * A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param dashboards
         *        A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(AssetBundleImportJobDashboardOverrideTags... dashboards);

        /**
         * <p>
         * A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dashboards(List<AssetBundleImportJobDashboardOverrideTags>)}.
         * 
         * @param dashboards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboards(java.util.Collection<AssetBundleImportJobDashboardOverrideTags>)
         */
        Builder dashboards(Consumer<AssetBundleImportJobDashboardOverrideTags.Builder>... dashboards);

        /**
         * <p>
         * A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param folders
         *        A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(Collection<AssetBundleImportJobFolderOverrideTags> folders);

        /**
         * <p>
         * A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * 
         * @param folders
         *        A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle
         *        that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(AssetBundleImportJobFolderOverrideTags... folders);

        /**
         * <p>
         * A list of tag overrides for any <code>Folder</code> resources that are present in the asset bundle that is
         * imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideTags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideTags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #folders(List<AssetBundleImportJobFolderOverrideTags>)}.
         * 
         * @param folders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverrideTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folders(java.util.Collection<AssetBundleImportJobFolderOverrideTags>)
         */
        Builder folders(Consumer<AssetBundleImportJobFolderOverrideTags.Builder>... folders);
    }

    static final class BuilderImpl implements Builder {
        private List<AssetBundleImportJobVPCConnectionOverrideTags> vpcConnections = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDataSourceOverrideTags> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDataSetOverrideTags> dataSets = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobThemeOverrideTags> themes = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobAnalysisOverrideTags> analyses = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDashboardOverrideTags> dashboards = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobFolderOverrideTags> folders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobOverrideTags model) {
            vpcConnections(model.vpcConnections);
            dataSources(model.dataSources);
            dataSets(model.dataSets);
            themes(model.themes);
            analyses(model.analyses);
            dashboards(model.dashboards);
            folders(model.folders);
        }

        public final List<AssetBundleImportJobVPCConnectionOverrideTags.Builder> getVpcConnections() {
            List<AssetBundleImportJobVPCConnectionOverrideTags.Builder> result = AssetBundleImportJobVPCConnectionOverrideTagsListCopier
                    .copyToBuilder(this.vpcConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConnections(Collection<AssetBundleImportJobVPCConnectionOverrideTags.BuilderImpl> vpcConnections) {
            this.vpcConnections = AssetBundleImportJobVPCConnectionOverrideTagsListCopier.copyFromBuilder(vpcConnections);
        }

        @Override
        public final Builder vpcConnections(Collection<AssetBundleImportJobVPCConnectionOverrideTags> vpcConnections) {
            this.vpcConnections = AssetBundleImportJobVPCConnectionOverrideTagsListCopier.copy(vpcConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnections(AssetBundleImportJobVPCConnectionOverrideTags... vpcConnections) {
            vpcConnections(Arrays.asList(vpcConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnections(Consumer<AssetBundleImportJobVPCConnectionOverrideTags.Builder>... vpcConnections) {
            vpcConnections(Stream.of(vpcConnections)
                    .map(c -> AssetBundleImportJobVPCConnectionOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDataSourceOverrideTags.Builder> getDataSources() {
            List<AssetBundleImportJobDataSourceOverrideTags.Builder> result = AssetBundleImportJobDataSourceOverrideTagsListCopier
                    .copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<AssetBundleImportJobDataSourceOverrideTags.BuilderImpl> dataSources) {
            this.dataSources = AssetBundleImportJobDataSourceOverrideTagsListCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<AssetBundleImportJobDataSourceOverrideTags> dataSources) {
            this.dataSources = AssetBundleImportJobDataSourceOverrideTagsListCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(AssetBundleImportJobDataSourceOverrideTags... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<AssetBundleImportJobDataSourceOverrideTags.Builder>... dataSources) {
            dataSources(Stream.of(dataSources)
                    .map(c -> AssetBundleImportJobDataSourceOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDataSetOverrideTags.Builder> getDataSets() {
            List<AssetBundleImportJobDataSetOverrideTags.Builder> result = AssetBundleImportJobDataSetOverrideTagsListCopier
                    .copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<AssetBundleImportJobDataSetOverrideTags.BuilderImpl> dataSets) {
            this.dataSets = AssetBundleImportJobDataSetOverrideTagsListCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<AssetBundleImportJobDataSetOverrideTags> dataSets) {
            this.dataSets = AssetBundleImportJobDataSetOverrideTagsListCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(AssetBundleImportJobDataSetOverrideTags... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<AssetBundleImportJobDataSetOverrideTags.Builder>... dataSets) {
            dataSets(Stream.of(dataSets).map(c -> AssetBundleImportJobDataSetOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobThemeOverrideTags.Builder> getThemes() {
            List<AssetBundleImportJobThemeOverrideTags.Builder> result = AssetBundleImportJobThemeOverrideTagsListCopier
                    .copyToBuilder(this.themes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemes(Collection<AssetBundleImportJobThemeOverrideTags.BuilderImpl> themes) {
            this.themes = AssetBundleImportJobThemeOverrideTagsListCopier.copyFromBuilder(themes);
        }

        @Override
        public final Builder themes(Collection<AssetBundleImportJobThemeOverrideTags> themes) {
            this.themes = AssetBundleImportJobThemeOverrideTagsListCopier.copy(themes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(AssetBundleImportJobThemeOverrideTags... themes) {
            themes(Arrays.asList(themes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(Consumer<AssetBundleImportJobThemeOverrideTags.Builder>... themes) {
            themes(Stream.of(themes).map(c -> AssetBundleImportJobThemeOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobAnalysisOverrideTags.Builder> getAnalyses() {
            List<AssetBundleImportJobAnalysisOverrideTags.Builder> result = AssetBundleImportJobAnalysisOverrideTagsListCopier
                    .copyToBuilder(this.analyses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyses(Collection<AssetBundleImportJobAnalysisOverrideTags.BuilderImpl> analyses) {
            this.analyses = AssetBundleImportJobAnalysisOverrideTagsListCopier.copyFromBuilder(analyses);
        }

        @Override
        public final Builder analyses(Collection<AssetBundleImportJobAnalysisOverrideTags> analyses) {
            this.analyses = AssetBundleImportJobAnalysisOverrideTagsListCopier.copy(analyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(AssetBundleImportJobAnalysisOverrideTags... analyses) {
            analyses(Arrays.asList(analyses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(Consumer<AssetBundleImportJobAnalysisOverrideTags.Builder>... analyses) {
            analyses(Stream.of(analyses).map(c -> AssetBundleImportJobAnalysisOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDashboardOverrideTags.Builder> getDashboards() {
            List<AssetBundleImportJobDashboardOverrideTags.Builder> result = AssetBundleImportJobDashboardOverrideTagsListCopier
                    .copyToBuilder(this.dashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboards(Collection<AssetBundleImportJobDashboardOverrideTags.BuilderImpl> dashboards) {
            this.dashboards = AssetBundleImportJobDashboardOverrideTagsListCopier.copyFromBuilder(dashboards);
        }

        @Override
        public final Builder dashboards(Collection<AssetBundleImportJobDashboardOverrideTags> dashboards) {
            this.dashboards = AssetBundleImportJobDashboardOverrideTagsListCopier.copy(dashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(AssetBundleImportJobDashboardOverrideTags... dashboards) {
            dashboards(Arrays.asList(dashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(Consumer<AssetBundleImportJobDashboardOverrideTags.Builder>... dashboards) {
            dashboards(Stream.of(dashboards)
                    .map(c -> AssetBundleImportJobDashboardOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobFolderOverrideTags.Builder> getFolders() {
            List<AssetBundleImportJobFolderOverrideTags.Builder> result = AssetBundleImportJobFolderOverrideTagsListCopier
                    .copyToBuilder(this.folders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolders(Collection<AssetBundleImportJobFolderOverrideTags.BuilderImpl> folders) {
            this.folders = AssetBundleImportJobFolderOverrideTagsListCopier.copyFromBuilder(folders);
        }

        @Override
        public final Builder folders(Collection<AssetBundleImportJobFolderOverrideTags> folders) {
            this.folders = AssetBundleImportJobFolderOverrideTagsListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(AssetBundleImportJobFolderOverrideTags... folders) {
            folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(Consumer<AssetBundleImportJobFolderOverrideTags.Builder>... folders) {
            folders(Stream.of(folders).map(c -> AssetBundleImportJobFolderOverrideTags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetBundleImportJobOverrideTags build() {
            return new AssetBundleImportJobOverrideTags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
