/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateTopicReviewedAnswerRequest extends QuickSightRequest implements
        ToCopyableBuilder<BatchCreateTopicReviewedAnswerRequest.Builder, BatchCreateTopicReviewedAnswerRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(BatchCreateTopicReviewedAnswerRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(BatchCreateTopicReviewedAnswerRequest::topicId))
            .setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TopicId").build()).build();

    private static final SdkField<List<CreateTopicReviewedAnswer>> ANSWERS_FIELD = SdkField
            .<List<CreateTopicReviewedAnswer>> builder(MarshallingType.LIST)
            .memberName("Answers")
            .getter(getter(BatchCreateTopicReviewedAnswerRequest::answers))
            .setter(setter(Builder::answers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateTopicReviewedAnswer> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateTopicReviewedAnswer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TOPIC_ID_FIELD, ANSWERS_FIELD));

    private final String awsAccountId;

    private final String topicId;

    private final List<CreateTopicReviewedAnswer> answers;

    private BatchCreateTopicReviewedAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.topicId = builder.topicId;
        this.answers = builder.answers;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that you want to create a reviewed answer in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that you want to create a reviewed answer in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
     *         Region for each Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Answers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnswers() {
        return answers != null && !(answers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of the Answers to be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnswers} method.
     * </p>
     * 
     * @return The definition of the Answers to be created.
     */
    public final List<CreateTopicReviewedAnswer> answers() {
        return answers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswers() ? answers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateTopicReviewedAnswerRequest)) {
            return false;
        }
        BatchCreateTopicReviewedAnswerRequest other = (BatchCreateTopicReviewedAnswerRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(topicId(), other.topicId())
                && hasAnswers() == other.hasAnswers() && Objects.equals(answers(), other.answers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateTopicReviewedAnswerRequest").add("AwsAccountId", awsAccountId())
                .add("TopicId", topicId()).add("Answers", hasAnswers() ? answers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "Answers":
            return Optional.ofNullable(clazz.cast(answers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateTopicReviewedAnswerRequest, T> g) {
        return obj -> g.apply((BatchCreateTopicReviewedAnswerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateTopicReviewedAnswerRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that you want to create a reviewed answer in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that you want to create a reviewed answer in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
         * Region for each Amazon Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web
         *        Services Region for each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The definition of the Answers to be created.
         * </p>
         * 
         * @param answers
         *        The definition of the Answers to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answers(Collection<CreateTopicReviewedAnswer> answers);

        /**
         * <p>
         * The definition of the Answers to be created.
         * </p>
         * 
         * @param answers
         *        The definition of the Answers to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answers(CreateTopicReviewedAnswer... answers);

        /**
         * <p>
         * The definition of the Answers to be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.CreateTopicReviewedAnswer.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.CreateTopicReviewedAnswer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.CreateTopicReviewedAnswer.Builder#build()} is called
         * immediately and its result is passed to {@link #answers(List<CreateTopicReviewedAnswer>)}.
         * 
         * @param answers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.CreateTopicReviewedAnswer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answers(java.util.Collection<CreateTopicReviewedAnswer>)
         */
        Builder answers(Consumer<CreateTopicReviewedAnswer.Builder>... answers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String topicId;

        private List<CreateTopicReviewedAnswer> answers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateTopicReviewedAnswerRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            topicId(model.topicId);
            answers(model.answers);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final List<CreateTopicReviewedAnswer.Builder> getAnswers() {
            List<CreateTopicReviewedAnswer.Builder> result = CreateTopicReviewedAnswersCopier.copyToBuilder(this.answers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnswers(Collection<CreateTopicReviewedAnswer.BuilderImpl> answers) {
            this.answers = CreateTopicReviewedAnswersCopier.copyFromBuilder(answers);
        }

        @Override
        public final Builder answers(Collection<CreateTopicReviewedAnswer> answers) {
            this.answers = CreateTopicReviewedAnswersCopier.copy(answers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answers(CreateTopicReviewedAnswer... answers) {
            answers(Arrays.asList(answers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answers(Consumer<CreateTopicReviewedAnswer.Builder>... answers) {
            answers(Stream.of(answers).map(c -> CreateTopicReviewedAnswer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateTopicReviewedAnswerRequest build() {
            return new BatchCreateTopicReviewedAnswerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
