/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicIRFilterOption</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicIRFilterOption implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicIRFilterOption.Builder, TopicIRFilterOption> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterType").getter(getter(TopicIRFilterOption::filterTypeAsString)).setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()).build();

    private static final SdkField<String> FILTER_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterClass").getter(getter(TopicIRFilterOption::filterClassAsString))
            .setter(setter(Builder::filterClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterClass").build()).build();

    private static final SdkField<Identifier> OPERAND_FIELD_FIELD = SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
            .memberName("OperandField").getter(getter(TopicIRFilterOption::operandField)).setter(setter(Builder::operandField))
            .constructor(Identifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperandField").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(TopicIRFilterOption::functionAsString)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<TopicConstantValue> CONSTANT_FIELD = SdkField
            .<TopicConstantValue> builder(MarshallingType.SDK_POJO).memberName("Constant")
            .getter(getter(TopicIRFilterOption::constant)).setter(setter(Builder::constant))
            .constructor(TopicConstantValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()).build();

    private static final SdkField<Boolean> INVERSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inverse").getter(getter(TopicIRFilterOption::inverse)).setter(setter(Builder::inverse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverse").build()).build();

    private static final SdkField<String> NULL_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullFilter").getter(getter(TopicIRFilterOption::nullFilterAsString)).setter(setter(Builder::nullFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullFilter").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(TopicIRFilterOption::aggregationAsString))
            .setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final SdkField<Map<String, String>> AGGREGATION_FUNCTION_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AggregationFunctionParameters")
            .getter(getter(TopicIRFilterOption::aggregationFunctionParameters))
            .setter(setter(Builder::aggregationFunctionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunctionParameters")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AggregationPartitionBy>> AGGREGATION_PARTITION_BY_FIELD = SdkField
            .<List<AggregationPartitionBy>> builder(MarshallingType.LIST)
            .memberName("AggregationPartitionBy")
            .getter(getter(TopicIRFilterOption::aggregationPartitionBy))
            .setter(setter(Builder::aggregationPartitionBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPartitionBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregationPartitionBy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregationPartitionBy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TopicConstantValue> RANGE_FIELD = SdkField
            .<TopicConstantValue> builder(MarshallingType.SDK_POJO).memberName("Range")
            .getter(getter(TopicIRFilterOption::range)).setter(setter(Builder::range)).constructor(TopicConstantValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final SdkField<Boolean> INCLUSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inclusive").getter(getter(TopicIRFilterOption::inclusive)).setter(setter(Builder::inclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inclusive").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TopicIRFilterOption::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<TopicConstantValue> LAST_NEXT_OFFSET_FIELD = SdkField
            .<TopicConstantValue> builder(MarshallingType.SDK_POJO).memberName("LastNextOffset")
            .getter(getter(TopicIRFilterOption::lastNextOffset)).setter(setter(Builder::lastNextOffset))
            .constructor(TopicConstantValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastNextOffset").build()).build();

    private static final SdkField<List<FilterAggMetrics>> AGG_METRICS_FIELD = SdkField
            .<List<FilterAggMetrics>> builder(MarshallingType.LIST)
            .memberName("AggMetrics")
            .getter(getter(TopicIRFilterOption::aggMetrics))
            .setter(setter(Builder::aggMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterAggMetrics> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterAggMetrics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TopicConstantValue> TOP_BOTTOM_LIMIT_FIELD = SdkField
            .<TopicConstantValue> builder(MarshallingType.SDK_POJO).memberName("TopBottomLimit")
            .getter(getter(TopicIRFilterOption::topBottomLimit)).setter(setter(Builder::topBottomLimit))
            .constructor(TopicConstantValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomLimit").build()).build();

    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortDirection").getter(getter(TopicIRFilterOption::sortDirectionAsString))
            .setter(setter(Builder::sortDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()).build();

    private static final SdkField<Anchor> ANCHOR_FIELD = SdkField.<Anchor> builder(MarshallingType.SDK_POJO).memberName("Anchor")
            .getter(getter(TopicIRFilterOption::anchor)).setter(setter(Builder::anchor)).constructor(Anchor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Anchor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_TYPE_FIELD,
            FILTER_CLASS_FIELD, OPERAND_FIELD_FIELD, FUNCTION_FIELD, CONSTANT_FIELD, INVERSE_FIELD, NULL_FILTER_FIELD,
            AGGREGATION_FIELD, AGGREGATION_FUNCTION_PARAMETERS_FIELD, AGGREGATION_PARTITION_BY_FIELD, RANGE_FIELD,
            INCLUSIVE_FIELD, TIME_GRANULARITY_FIELD, LAST_NEXT_OFFSET_FIELD, AGG_METRICS_FIELD, TOP_BOTTOM_LIMIT_FIELD,
            SORT_DIRECTION_FIELD, ANCHOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterType;

    private final String filterClass;

    private final Identifier operandField;

    private final String function;

    private final TopicConstantValue constant;

    private final Boolean inverse;

    private final String nullFilter;

    private final String aggregation;

    private final Map<String, String> aggregationFunctionParameters;

    private final List<AggregationPartitionBy> aggregationPartitionBy;

    private final TopicConstantValue range;

    private final Boolean inclusive;

    private final String timeGranularity;

    private final TopicConstantValue lastNextOffset;

    private final List<FilterAggMetrics> aggMetrics;

    private final TopicConstantValue topBottomLimit;

    private final String sortDirection;

    private final Anchor anchor;

    private TopicIRFilterOption(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.filterClass = builder.filterClass;
        this.operandField = builder.operandField;
        this.function = builder.function;
        this.constant = builder.constant;
        this.inverse = builder.inverse;
        this.nullFilter = builder.nullFilter;
        this.aggregation = builder.aggregation;
        this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
        this.aggregationPartitionBy = builder.aggregationPartitionBy;
        this.range = builder.range;
        this.inclusive = builder.inclusive;
        this.timeGranularity = builder.timeGranularity;
        this.lastNextOffset = builder.lastNextOffset;
        this.aggMetrics = builder.aggMetrics;
        this.topBottomLimit = builder.topBottomLimit;
        this.sortDirection = builder.sortDirection;
        this.anchor = builder.anchor;
    }

    /**
     * <p>
     * The filter type for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link TopicIRFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The filter type for the <code>TopicIRFilterOption</code>.
     * @see TopicIRFilterType
     */
    public final TopicIRFilterType filterType() {
        return TopicIRFilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The filter type for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link TopicIRFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The filter type for the <code>TopicIRFilterOption</code>.
     * @see TopicIRFilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    /**
     * <p>
     * The filter class for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterClass} will
     * return {@link FilterClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterClassAsString}.
     * </p>
     * 
     * @return The filter class for the <code>TopicIRFilterOption</code>.
     * @see FilterClass
     */
    public final FilterClass filterClass() {
        return FilterClass.fromValue(filterClass);
    }

    /**
     * <p>
     * The filter class for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterClass} will
     * return {@link FilterClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterClassAsString}.
     * </p>
     * 
     * @return The filter class for the <code>TopicIRFilterOption</code>.
     * @see FilterClass
     */
    public final String filterClassAsString() {
        return filterClass;
    }

    /**
     * <p>
     * The operand field for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The operand field for the <code>TopicIRFilterOption</code>.
     */
    public final Identifier operandField() {
        return operandField;
    }

    /**
     * <p>
     * The function for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #function} will
     * return {@link TopicIRFilterFunction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #functionAsString}.
     * </p>
     * 
     * @return The function for the <code>TopicIRFilterOption</code>.
     * @see TopicIRFilterFunction
     */
    public final TopicIRFilterFunction function() {
        return TopicIRFilterFunction.fromValue(function);
    }

    /**
     * <p>
     * The function for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #function} will
     * return {@link TopicIRFilterFunction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #functionAsString}.
     * </p>
     * 
     * @return The function for the <code>TopicIRFilterOption</code>.
     * @see TopicIRFilterFunction
     */
    public final String functionAsString() {
        return function;
    }

    /**
     * <p>
     * The constant for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The constant for the <code>TopicIRFilterOption</code>.
     */
    public final TopicConstantValue constant() {
        return constant;
    }

    /**
     * <p>
     * The inverse for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The inverse for the <code>TopicIRFilterOption</code>.
     */
    public final Boolean inverse() {
        return inverse;
    }

    /**
     * <p>
     * The null filter for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullFilter} will
     * return {@link NullFilterOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullFilterAsString}.
     * </p>
     * 
     * @return The null filter for the <code>TopicIRFilterOption</code>.
     * @see NullFilterOption
     */
    public final NullFilterOption nullFilter() {
        return NullFilterOption.fromValue(nullFilter);
    }

    /**
     * <p>
     * The null filter for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullFilter} will
     * return {@link NullFilterOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullFilterAsString}.
     * </p>
     * 
     * @return The null filter for the <code>TopicIRFilterOption</code>.
     * @see NullFilterOption
     */
    public final String nullFilterAsString() {
        return nullFilter;
    }

    /**
     * <p>
     * The aggregation for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link AggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The aggregation for the <code>TopicIRFilterOption</code>.
     * @see AggType
     */
    public final AggType aggregation() {
        return AggType.fromValue(aggregation);
    }

    /**
     * <p>
     * The aggregation for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link AggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The aggregation for the <code>TopicIRFilterOption</code>.
     * @see AggType
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregationFunctionParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregationFunctionParameters() {
        return aggregationFunctionParameters != null && !(aggregationFunctionParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The aggregation function parameters for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregationFunctionParameters} method.
     * </p>
     * 
     * @return The aggregation function parameters for the <code>TopicIRFilterOption</code>.
     */
    public final Map<String, String> aggregationFunctionParameters() {
        return aggregationFunctionParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregationPartitionBy property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregationPartitionBy() {
        return aggregationPartitionBy != null && !(aggregationPartitionBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregationPartitionBy} method.
     * </p>
     * 
     * @return The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
     */
    public final List<AggregationPartitionBy> aggregationPartitionBy() {
        return aggregationPartitionBy;
    }

    /**
     * <p>
     * The range for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The range for the <code>TopicIRFilterOption</code>.
     */
    public final TopicConstantValue range() {
        return range;
    }

    /**
     * <p>
     * The inclusive for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The inclusive for the <code>TopicIRFilterOption</code>.
     */
    public final Boolean inclusive() {
        return inclusive;
    }

    /**
     * <p>
     * The time granularity for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The time granularity for the <code>TopicIRFilterOption</code>.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The time granularity for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The time granularity for the <code>TopicIRFilterOption</code>.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The last next offset for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The last next offset for the <code>TopicIRFilterOption</code>.
     */
    public final TopicConstantValue lastNextOffset() {
        return lastNextOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggMetrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAggMetrics() {
        return aggMetrics != null && !(aggMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The agg metrics for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggMetrics} method.
     * </p>
     * 
     * @return The agg metrics for the <code>TopicIRFilterOption</code>.
     */
    public final List<FilterAggMetrics> aggMetrics() {
        return aggMetrics;
    }

    /**
     * <p>
     * The <code>TopBottomLimit</code> for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The <code>TopBottomLimit</code> for the <code>TopicIRFilterOption</code>.
     */
    public final TopicConstantValue topBottomLimit() {
        return topBottomLimit;
    }

    /**
     * <p>
     * The sort direction for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link TopicSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction for the <code>TopicIRFilterOption</code>.
     * @see TopicSortDirection
     */
    public final TopicSortDirection sortDirection() {
        return TopicSortDirection.fromValue(sortDirection);
    }

    /**
     * <p>
     * The sort direction for the <code>TopicIRFilterOption</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link TopicSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction for the <code>TopicIRFilterOption</code>.
     * @see TopicSortDirection
     */
    public final String sortDirectionAsString() {
        return sortDirection;
    }

    /**
     * <p>
     * The anchor for the <code>TopicIRFilterOption</code>.
     * </p>
     * 
     * @return The anchor for the <code>TopicIRFilterOption</code>.
     */
    public final Anchor anchor() {
        return anchor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operandField());
        hashCode = 31 * hashCode + Objects.hashCode(functionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        hashCode = 31 * hashCode + Objects.hashCode(inverse());
        hashCode = 31 * hashCode + Objects.hashCode(nullFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregationFunctionParameters() ? aggregationFunctionParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregationPartitionBy() ? aggregationPartitionBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(inclusive());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastNextOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggMetrics() ? aggMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(topBottomLimit());
        hashCode = 31 * hashCode + Objects.hashCode(sortDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(anchor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRFilterOption)) {
            return false;
        }
        TopicIRFilterOption other = (TopicIRFilterOption) obj;
        return Objects.equals(filterTypeAsString(), other.filterTypeAsString())
                && Objects.equals(filterClassAsString(), other.filterClassAsString())
                && Objects.equals(operandField(), other.operandField())
                && Objects.equals(functionAsString(), other.functionAsString()) && Objects.equals(constant(), other.constant())
                && Objects.equals(inverse(), other.inverse()) && Objects.equals(nullFilterAsString(), other.nullFilterAsString())
                && Objects.equals(aggregationAsString(), other.aggregationAsString())
                && hasAggregationFunctionParameters() == other.hasAggregationFunctionParameters()
                && Objects.equals(aggregationFunctionParameters(), other.aggregationFunctionParameters())
                && hasAggregationPartitionBy() == other.hasAggregationPartitionBy()
                && Objects.equals(aggregationPartitionBy(), other.aggregationPartitionBy())
                && Objects.equals(range(), other.range()) && Objects.equals(inclusive(), other.inclusive())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(lastNextOffset(), other.lastNextOffset()) && hasAggMetrics() == other.hasAggMetrics()
                && Objects.equals(aggMetrics(), other.aggMetrics()) && Objects.equals(topBottomLimit(), other.topBottomLimit())
                && Objects.equals(sortDirectionAsString(), other.sortDirectionAsString())
                && Objects.equals(anchor(), other.anchor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TopicIRFilterOption")
                .add("FilterType", filterTypeAsString())
                .add("FilterClass", filterClassAsString())
                .add("OperandField", operandField())
                .add("Function", functionAsString())
                .add("Constant", constant())
                .add("Inverse", inverse())
                .add("NullFilter", nullFilterAsString())
                .add("Aggregation", aggregationAsString())
                .add("AggregationFunctionParameters", hasAggregationFunctionParameters() ? aggregationFunctionParameters() : null)
                .add("AggregationPartitionBy", hasAggregationPartitionBy() ? aggregationPartitionBy() : null)
                .add("Range", range()).add("Inclusive", inclusive()).add("TimeGranularity", timeGranularityAsString())
                .add("LastNextOffset", lastNextOffset()).add("AggMetrics", hasAggMetrics() ? aggMetrics() : null)
                .add("TopBottomLimit", topBottomLimit()).add("SortDirection", sortDirectionAsString()).add("Anchor", anchor())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        case "FilterClass":
            return Optional.ofNullable(clazz.cast(filterClassAsString()));
        case "OperandField":
            return Optional.ofNullable(clazz.cast(operandField()));
        case "Function":
            return Optional.ofNullable(clazz.cast(functionAsString()));
        case "Constant":
            return Optional.ofNullable(clazz.cast(constant()));
        case "Inverse":
            return Optional.ofNullable(clazz.cast(inverse()));
        case "NullFilter":
            return Optional.ofNullable(clazz.cast(nullFilterAsString()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "AggregationFunctionParameters":
            return Optional.ofNullable(clazz.cast(aggregationFunctionParameters()));
        case "AggregationPartitionBy":
            return Optional.ofNullable(clazz.cast(aggregationPartitionBy()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        case "Inclusive":
            return Optional.ofNullable(clazz.cast(inclusive()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "LastNextOffset":
            return Optional.ofNullable(clazz.cast(lastNextOffset()));
        case "AggMetrics":
            return Optional.ofNullable(clazz.cast(aggMetrics()));
        case "TopBottomLimit":
            return Optional.ofNullable(clazz.cast(topBottomLimit()));
        case "SortDirection":
            return Optional.ofNullable(clazz.cast(sortDirectionAsString()));
        case "Anchor":
            return Optional.ofNullable(clazz.cast(anchor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicIRFilterOption, T> g) {
        return obj -> g.apply((TopicIRFilterOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicIRFilterOption> {
        /**
         * <p>
         * The filter type for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param filterType
         *        The filter type for the <code>TopicIRFilterOption</code>.
         * @see TopicIRFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicIRFilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The filter type for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param filterType
         *        The filter type for the <code>TopicIRFilterOption</code>.
         * @see TopicIRFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicIRFilterType
         */
        Builder filterType(TopicIRFilterType filterType);

        /**
         * <p>
         * The filter class for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param filterClass
         *        The filter class for the <code>TopicIRFilterOption</code>.
         * @see FilterClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterClass
         */
        Builder filterClass(String filterClass);

        /**
         * <p>
         * The filter class for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param filterClass
         *        The filter class for the <code>TopicIRFilterOption</code>.
         * @see FilterClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterClass
         */
        Builder filterClass(FilterClass filterClass);

        /**
         * <p>
         * The operand field for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param operandField
         *        The operand field for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operandField(Identifier operandField);

        /**
         * <p>
         * The operand field for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identifier.Builder} avoiding the need to
         * create one manually via {@link Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identifier.Builder#build()} is called immediately and its result
         * is passed to {@link #operandField(Identifier)}.
         * 
         * @param operandField
         *        a consumer that will call methods on {@link Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operandField(Identifier)
         */
        default Builder operandField(Consumer<Identifier.Builder> operandField) {
            return operandField(Identifier.builder().applyMutation(operandField).build());
        }

        /**
         * <p>
         * The function for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param function
         *        The function for the <code>TopicIRFilterOption</code>.
         * @see TopicIRFilterFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicIRFilterFunction
         */
        Builder function(String function);

        /**
         * <p>
         * The function for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param function
         *        The function for the <code>TopicIRFilterOption</code>.
         * @see TopicIRFilterFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicIRFilterFunction
         */
        Builder function(TopicIRFilterFunction function);

        /**
         * <p>
         * The constant for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param constant
         *        The constant for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(TopicConstantValue constant);

        /**
         * <p>
         * The constant for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicConstantValue.Builder} avoiding the
         * need to create one manually via {@link TopicConstantValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicConstantValue.Builder#build()} is called immediately and its
         * result is passed to {@link #constant(TopicConstantValue)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link TopicConstantValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(TopicConstantValue)
         */
        default Builder constant(Consumer<TopicConstantValue.Builder> constant) {
            return constant(TopicConstantValue.builder().applyMutation(constant).build());
        }

        /**
         * <p>
         * The inverse for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param inverse
         *        The inverse for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inverse(Boolean inverse);

        /**
         * <p>
         * The null filter for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param nullFilter
         *        The null filter for the <code>TopicIRFilterOption</code>.
         * @see NullFilterOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NullFilterOption
         */
        Builder nullFilter(String nullFilter);

        /**
         * <p>
         * The null filter for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param nullFilter
         *        The null filter for the <code>TopicIRFilterOption</code>.
         * @see NullFilterOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NullFilterOption
         */
        Builder nullFilter(NullFilterOption nullFilter);

        /**
         * <p>
         * The aggregation for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggregation
         *        The aggregation for the <code>TopicIRFilterOption</code>.
         * @see AggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggType
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * The aggregation for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggregation
         *        The aggregation for the <code>TopicIRFilterOption</code>.
         * @see AggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggType
         */
        Builder aggregation(AggType aggregation);

        /**
         * <p>
         * The aggregation function parameters for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggregationFunctionParameters
         *        The aggregation function parameters for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters);

        /**
         * <p>
         * The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggregationPartitionBy
         *        The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationPartitionBy(Collection<AggregationPartitionBy> aggregationPartitionBy);

        /**
         * <p>
         * The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggregationPartitionBy
         *        The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationPartitionBy(AggregationPartitionBy... aggregationPartitionBy);

        /**
         * <p>
         * The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AggregationPartitionBy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AggregationPartitionBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AggregationPartitionBy.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationPartitionBy(List<AggregationPartitionBy>)}.
         * 
         * @param aggregationPartitionBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AggregationPartitionBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationPartitionBy(java.util.Collection<AggregationPartitionBy>)
         */
        Builder aggregationPartitionBy(Consumer<AggregationPartitionBy.Builder>... aggregationPartitionBy);

        /**
         * <p>
         * The range for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param range
         *        The range for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(TopicConstantValue range);

        /**
         * <p>
         * The range for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicConstantValue.Builder} avoiding the
         * need to create one manually via {@link TopicConstantValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicConstantValue.Builder#build()} is called immediately and its
         * result is passed to {@link #range(TopicConstantValue)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link TopicConstantValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(TopicConstantValue)
         */
        default Builder range(Consumer<TopicConstantValue.Builder> range) {
            return range(TopicConstantValue.builder().applyMutation(range).build());
        }

        /**
         * <p>
         * The inclusive for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param inclusive
         *        The inclusive for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusive(Boolean inclusive);

        /**
         * <p>
         * The time granularity for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param timeGranularity
         *        The time granularity for the <code>TopicIRFilterOption</code>.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The time granularity for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param timeGranularity
         *        The time granularity for the <code>TopicIRFilterOption</code>.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);

        /**
         * <p>
         * The last next offset for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param lastNextOffset
         *        The last next offset for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastNextOffset(TopicConstantValue lastNextOffset);

        /**
         * <p>
         * The last next offset for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicConstantValue.Builder} avoiding the
         * need to create one manually via {@link TopicConstantValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicConstantValue.Builder#build()} is called immediately and its
         * result is passed to {@link #lastNextOffset(TopicConstantValue)}.
         * 
         * @param lastNextOffset
         *        a consumer that will call methods on {@link TopicConstantValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastNextOffset(TopicConstantValue)
         */
        default Builder lastNextOffset(Consumer<TopicConstantValue.Builder> lastNextOffset) {
            return lastNextOffset(TopicConstantValue.builder().applyMutation(lastNextOffset).build());
        }

        /**
         * <p>
         * The agg metrics for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggMetrics
         *        The agg metrics for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggMetrics(Collection<FilterAggMetrics> aggMetrics);

        /**
         * <p>
         * The agg metrics for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param aggMetrics
         *        The agg metrics for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggMetrics(FilterAggMetrics... aggMetrics);

        /**
         * <p>
         * The agg metrics for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FilterAggMetrics.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FilterAggMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FilterAggMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #aggMetrics(List<FilterAggMetrics>)}.
         * 
         * @param aggMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FilterAggMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggMetrics(java.util.Collection<FilterAggMetrics>)
         */
        Builder aggMetrics(Consumer<FilterAggMetrics.Builder>... aggMetrics);

        /**
         * <p>
         * The <code>TopBottomLimit</code> for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param topBottomLimit
         *        The <code>TopBottomLimit</code> for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topBottomLimit(TopicConstantValue topBottomLimit);

        /**
         * <p>
         * The <code>TopBottomLimit</code> for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicConstantValue.Builder} avoiding the
         * need to create one manually via {@link TopicConstantValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicConstantValue.Builder#build()} is called immediately and its
         * result is passed to {@link #topBottomLimit(TopicConstantValue)}.
         * 
         * @param topBottomLimit
         *        a consumer that will call methods on {@link TopicConstantValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topBottomLimit(TopicConstantValue)
         */
        default Builder topBottomLimit(Consumer<TopicConstantValue.Builder> topBottomLimit) {
            return topBottomLimit(TopicConstantValue.builder().applyMutation(topBottomLimit).build());
        }

        /**
         * <p>
         * The sort direction for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction for the <code>TopicIRFilterOption</code>.
         * @see TopicSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicSortDirection
         */
        Builder sortDirection(String sortDirection);

        /**
         * <p>
         * The sort direction for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction for the <code>TopicIRFilterOption</code>.
         * @see TopicSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicSortDirection
         */
        Builder sortDirection(TopicSortDirection sortDirection);

        /**
         * <p>
         * The anchor for the <code>TopicIRFilterOption</code>.
         * </p>
         * 
         * @param anchor
         *        The anchor for the <code>TopicIRFilterOption</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anchor(Anchor anchor);

        /**
         * <p>
         * The anchor for the <code>TopicIRFilterOption</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Anchor.Builder} avoiding the need to
         * create one manually via {@link Anchor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Anchor.Builder#build()} is called immediately and its result is
         * passed to {@link #anchor(Anchor)}.
         * 
         * @param anchor
         *        a consumer that will call methods on {@link Anchor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anchor(Anchor)
         */
        default Builder anchor(Consumer<Anchor.Builder> anchor) {
            return anchor(Anchor.builder().applyMutation(anchor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterType;

        private String filterClass;

        private Identifier operandField;

        private String function;

        private TopicConstantValue constant;

        private Boolean inverse;

        private String nullFilter;

        private String aggregation;

        private Map<String, String> aggregationFunctionParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<AggregationPartitionBy> aggregationPartitionBy = DefaultSdkAutoConstructList.getInstance();

        private TopicConstantValue range;

        private Boolean inclusive;

        private String timeGranularity;

        private TopicConstantValue lastNextOffset;

        private List<FilterAggMetrics> aggMetrics = DefaultSdkAutoConstructList.getInstance();

        private TopicConstantValue topBottomLimit;

        private String sortDirection;

        private Anchor anchor;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRFilterOption model) {
            filterType(model.filterType);
            filterClass(model.filterClass);
            operandField(model.operandField);
            function(model.function);
            constant(model.constant);
            inverse(model.inverse);
            nullFilter(model.nullFilter);
            aggregation(model.aggregation);
            aggregationFunctionParameters(model.aggregationFunctionParameters);
            aggregationPartitionBy(model.aggregationPartitionBy);
            range(model.range);
            inclusive(model.inclusive);
            timeGranularity(model.timeGranularity);
            lastNextOffset(model.lastNextOffset);
            aggMetrics(model.aggMetrics);
            topBottomLimit(model.topBottomLimit);
            sortDirection(model.sortDirection);
            anchor(model.anchor);
        }

        public final String getFilterType() {
            return filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(TopicIRFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final String getFilterClass() {
            return filterClass;
        }

        public final void setFilterClass(String filterClass) {
            this.filterClass = filterClass;
        }

        @Override
        public final Builder filterClass(String filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        @Override
        public final Builder filterClass(FilterClass filterClass) {
            this.filterClass(filterClass == null ? null : filterClass.toString());
            return this;
        }

        public final Identifier.Builder getOperandField() {
            return operandField != null ? operandField.toBuilder() : null;
        }

        public final void setOperandField(Identifier.BuilderImpl operandField) {
            this.operandField = operandField != null ? operandField.build() : null;
        }

        @Override
        public final Builder operandField(Identifier operandField) {
            this.operandField = operandField;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public final Builder function(TopicIRFilterFunction function) {
            this.function(function == null ? null : function.toString());
            return this;
        }

        public final TopicConstantValue.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(TopicConstantValue.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicConstantValue constant) {
            this.constant = constant;
            return this;
        }

        public final Boolean getInverse() {
            return inverse;
        }

        public final void setInverse(Boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public final Builder inverse(Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public final String getNullFilter() {
            return nullFilter;
        }

        public final void setNullFilter(String nullFilter) {
            this.nullFilter = nullFilter;
        }

        @Override
        public final Builder nullFilter(String nullFilter) {
            this.nullFilter = nullFilter;
            return this;
        }

        @Override
        public final Builder nullFilter(NullFilterOption nullFilter) {
            this.nullFilter(nullFilter == null ? null : nullFilter.toString());
            return this;
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(AggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Map<String, String> getAggregationFunctionParameters() {
            if (aggregationFunctionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return aggregationFunctionParameters;
        }

        public final void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
        }

        @Override
        public final Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
            return this;
        }

        public final List<AggregationPartitionBy.Builder> getAggregationPartitionBy() {
            List<AggregationPartitionBy.Builder> result = AggregationPartitionByListCopier
                    .copyToBuilder(this.aggregationPartitionBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationPartitionBy(Collection<AggregationPartitionBy.BuilderImpl> aggregationPartitionBy) {
            this.aggregationPartitionBy = AggregationPartitionByListCopier.copyFromBuilder(aggregationPartitionBy);
        }

        @Override
        public final Builder aggregationPartitionBy(Collection<AggregationPartitionBy> aggregationPartitionBy) {
            this.aggregationPartitionBy = AggregationPartitionByListCopier.copy(aggregationPartitionBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationPartitionBy(AggregationPartitionBy... aggregationPartitionBy) {
            aggregationPartitionBy(Arrays.asList(aggregationPartitionBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationPartitionBy(Consumer<AggregationPartitionBy.Builder>... aggregationPartitionBy) {
            aggregationPartitionBy(Stream.of(aggregationPartitionBy)
                    .map(c -> AggregationPartitionBy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TopicConstantValue.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(TopicConstantValue.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(TopicConstantValue range) {
            this.range = range;
            return this;
        }

        public final Boolean getInclusive() {
            return inclusive;
        }

        public final void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Override
        public final Builder inclusive(Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final TopicConstantValue.Builder getLastNextOffset() {
            return lastNextOffset != null ? lastNextOffset.toBuilder() : null;
        }

        public final void setLastNextOffset(TopicConstantValue.BuilderImpl lastNextOffset) {
            this.lastNextOffset = lastNextOffset != null ? lastNextOffset.build() : null;
        }

        @Override
        public final Builder lastNextOffset(TopicConstantValue lastNextOffset) {
            this.lastNextOffset = lastNextOffset;
            return this;
        }

        public final List<FilterAggMetrics.Builder> getAggMetrics() {
            List<FilterAggMetrics.Builder> result = FilterAggMetricsListCopier.copyToBuilder(this.aggMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggMetrics(Collection<FilterAggMetrics.BuilderImpl> aggMetrics) {
            this.aggMetrics = FilterAggMetricsListCopier.copyFromBuilder(aggMetrics);
        }

        @Override
        public final Builder aggMetrics(Collection<FilterAggMetrics> aggMetrics) {
            this.aggMetrics = FilterAggMetricsListCopier.copy(aggMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggMetrics(FilterAggMetrics... aggMetrics) {
            aggMetrics(Arrays.asList(aggMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggMetrics(Consumer<FilterAggMetrics.Builder>... aggMetrics) {
            aggMetrics(Stream.of(aggMetrics).map(c -> FilterAggMetrics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TopicConstantValue.Builder getTopBottomLimit() {
            return topBottomLimit != null ? topBottomLimit.toBuilder() : null;
        }

        public final void setTopBottomLimit(TopicConstantValue.BuilderImpl topBottomLimit) {
            this.topBottomLimit = topBottomLimit != null ? topBottomLimit.build() : null;
        }

        @Override
        public final Builder topBottomLimit(TopicConstantValue topBottomLimit) {
            this.topBottomLimit = topBottomLimit;
            return this;
        }

        public final String getSortDirection() {
            return sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(TopicSortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final Anchor.Builder getAnchor() {
            return anchor != null ? anchor.toBuilder() : null;
        }

        public final void setAnchor(Anchor.BuilderImpl anchor) {
            this.anchor = anchor != null ? anchor.build() : null;
        }

        @Override
        public final Builder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        @Override
        public TopicIRFilterOption build() {
            return new TopicIRFilterOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
